/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

class Like
implements Cloneable {
    private static final BinaryData maxByteValue = new BinaryData(new byte[]{-128}, false);
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    int escapeChar;
    String prefix = "";
    static final int NORMAL_CHAR = 0;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;
    boolean isVariable = true;
    boolean isBinary = false;
    Type dataType;

    Like() {
    }

    void setIgnoreCase(boolean bl) {
        this.isIgnoreCase = bl;
    }

    private Object getStartsWith() {
        int n2;
        if (this.iLen == 0) {
            return this.isBinary ? BinaryData.zeroLengthBinary : "";
        }
        StringBuilder stringBuilder = null;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        if (this.isBinary) {
            hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        } else {
            stringBuilder = new StringBuilder();
        }
        for (n2 = 0; n2 < this.iLen && this.wildCardType[n2] == 0; ++n2) {
            if (this.isBinary) {
                hsqlByteArrayOutputStream.writeByte(this.cLike[n2]);
                continue;
            }
            stringBuilder.append(this.cLike[n2]);
        }
        if (n2 == 0) {
            return null;
        }
        return this.isBinary ? new BinaryData(hsqlByteArrayOutputStream.toByteArray(), false) : stringBuilder.toString();
    }

    Boolean compare(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.isNull) {
            return null;
        }
        if (this.isIgnoreCase) {
            object = ((CharacterType)this.dataType).upper(session, object);
        }
        int n2 = this.getLength(session, object);
        if (object instanceof ClobData) {
            object = ((ClobData)object).getChars(session, 0L, (int)((ClobData)object).length(session));
        }
        if (!this.isBinary && this.prefix.length() > 0) {
            if (n2 < this.prefix.length()) {
                return false;
            }
            int n3 = this.dataType.compare(session, this.prefix, object = ((String)object).substring(0, this.prefix.length()));
            return n3 == 0;
        }
        return this.compareAt(session, object, 0, 0, this.iLen, n2, this.cLike, this.wildCardType) ? Boolean.TRUE : Boolean.FALSE;
    }

    char getChar(Session session, Object object, int n2) {
        char c2 = this.isBinary ? (char)((BlobData)object).getBytes()[n2] : (object instanceof char[] ? ((char[])object)[n2] : (object instanceof ClobData ? ((ClobData)object).getChars(session, n2, 1)[0] : ((String)object).charAt(n2)));
        return c2;
    }

    int getLength(SessionInterface sessionInterface, Object object) {
        int n2 = object instanceof LobData ? (int)((LobData)object).length(sessionInterface) : ((String)object).length();
        return n2;
    }

    private boolean compareAt(Session session, Object object, int n2, int n3, int n4, int n5, char[] cArray, int[] nArray) {
        while (n2 < n4) {
            switch (nArray[n2]) {
                case 0: {
                    if (n3 < n5 && cArray[n2] == this.getChar(session, object, n3++)) break;
                    return false;
                }
                case 1: {
                    if (n3++ < n5) break;
                    return false;
                }
                case 2: {
                    if (++n2 >= n4) {
                        return true;
                    }
                    while (n3 < n5) {
                        if (cArray[n2] == this.getChar(session, object, n3) && this.compareAt(session, object, n2, n3, n4, n5, cArray, nArray)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
            }
            ++n2;
        }
        return n3 == n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setPattern(Session session, Object object, Object object2, boolean bl) {
        char c2;
        int n2;
        int n3;
        boolean bl2 = this.isNull = object == null;
        if (!bl) {
            this.escapeChar = -1;
        } else {
            if (object2 == null) {
                this.isNull = true;
                return;
            }
            n3 = this.getLength(session, object2);
            if (n3 != 1) {
                if (!this.isBinary) throw Error.error(3439);
                throw Error.error(3412);
            }
            this.escapeChar = this.getChar(session, object2, 0);
        }
        if (this.isNull) {
            return;
        }
        if (this.isIgnoreCase) {
            object = ((CharacterType)this.dataType).upper(null, object);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        n3 = this.getLength(session, object);
        this.cLike = new char[n3];
        this.wildCardType = new int[n3];
        boolean bl3 = false;
        boolean bl4 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            block25: {
                block23: {
                    block24: {
                        c2 = this.getChar(session, object, n2);
                        if (bl3) break block23;
                        if (this.escapeChar == c2) {
                            bl3 = true;
                            continue;
                        }
                        if (c2 != '_') break block24;
                        this.wildCardType[this.iLen] = 1;
                        if (this.iFirstWildCard == -1) {
                            this.iFirstWildCard = this.iLen;
                        }
                        break block25;
                    }
                    if (c2 == '%') {
                        if (bl4) continue;
                        bl4 = true;
                        this.wildCardType[this.iLen] = 2;
                        if (this.iFirstWildCard == -1) {
                            this.iFirstWildCard = this.iLen;
                        }
                        break block25;
                    } else {
                        bl4 = false;
                    }
                    break block25;
                }
                if (c2 != this.escapeChar && c2 != '_' && c2 != '%') {
                    throw Error.error(3458);
                }
                bl4 = false;
                bl3 = false;
            }
            this.cLike[this.iLen++] = c2;
        }
        if (bl3) {
            throw Error.error(3458);
        }
        for (n2 = 0; n2 < this.iLen - 1; ++n2) {
            if (this.wildCardType[n2] != 2 || this.wildCardType[n2 + 1] != 1) continue;
            this.wildCardType[n2] = 1;
            this.wildCardType[n2 + 1] = 2;
        }
        if (this.isBinary) {
            return;
        }
        this.prefix = "";
        n2 = 0;
        c2 = '\u0000';
        for (int i2 = 0; i2 < this.iLen; ++i2) {
            switch (this.wildCardType[i2]) {
                case 0: {
                    if (c2 == '\u0000') break;
                    return;
                }
                case 1: {
                    return;
                }
                case 2: {
                    if (c2 != '\u0000') {
                        return;
                    }
                    n2 = i2;
                    c2 = '\u0001';
                }
            }
        }
        if (c2 == '\u0000') return;
        this.prefix = String.valueOf(this.cLike, 0, n2);
    }

    boolean isEquivalentToUnknownPredicate() {
        return !this.isVariable && this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return !this.isVariable && this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isVariable || this.isNull || this.iFirstWildCard == -1) {
            return false;
        }
        for (int i2 = 0; i2 < this.wildCardType.length; ++i2) {
            if (this.wildCardType[i2] == 2) continue;
            return false;
        }
        return true;
    }

    int getFirstWildCardIndex() {
        return this.iFirstWildCard;
    }

    Object getRangeLow() {
        return this.getStartsWith();
    }

    public String describe(Session session) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append("[\n");
        stringBuilder.append("escapeChar=").append(this.escapeChar).append('\n');
        stringBuilder.append("isNull=").append(this.isNull).append('\n');
        stringBuilder.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        stringBuilder.append("iLen=").append(this.iLen).append('\n');
        stringBuilder.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        stringBuilder.append("cLike=");
        if (this.cLike != null) {
            stringBuilder.append(StringUtil.arrayToString(this.cLike));
        }
        stringBuilder.append('\n');
        stringBuilder.append("wildCardType=");
        if (this.wildCardType != null) {
            stringBuilder.append(StringUtil.arrayToString(this.wildCardType));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Like duplicate() {
        try {
            return (Like)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
    }
}

