/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Arrays;
import org.hsqldb.Expression;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;

public class GroupSet {
    Expression[] groupExpressions;
    HsqlArrayList sets = new HsqlArrayList();
    int nullSets = 0;
    boolean isDistinctGroups;

    public GroupSet(Expression[] expressionArray, boolean bl) {
        this.groupExpressions = expressionArray;
        this.isDistinctGroups = bl;
    }

    public Iterator getIterator() {
        return this.sets.iterator();
    }

    public int isGrouped(List list, Expression expression) {
        int n2 = 0;
        if (list == null) {
            return (1 << expression.nodes.length) - 1;
        }
        for (int i2 = 0; i2 < expression.nodes.length; ++i2) {
            n2 <<= 1;
            int n3 = expression.nodes[i2].columnIndex;
            if (list.contains(n3)) continue;
            ++n2;
        }
        return n2;
    }

    public void process() {
        HsqlArrayList hsqlArrayList = GroupSet.evaluate(this.groupExpressions);
        Iterator iterator = hsqlArrayList.iterator();
        block0: while (iterator.hasNext()) {
            OrderedHashSet orderedHashSet = (OrderedHashSet)iterator.next();
            if (orderedHashSet.isEmpty()) {
                if (this.isDistinctGroups) {
                    this.nullSets = 1;
                    continue;
                }
                ++this.nullSets;
                continue;
            }
            if (this.isDistinctGroups) {
                OrderedHashSet orderedHashSet2 = new OrderedHashSet();
                orderedHashSet2.addAll(orderedHashSet);
                for (int i2 = 0; i2 < this.sets.size(); ++i2) {
                    List list = (List)this.sets.get(i2);
                    if (list.size() == orderedHashSet2.size() && orderedHashSet2.containsAll(list)) continue block0;
                }
                orderedHashSet = orderedHashSet2;
            }
            this.sets.add(orderedHashSet);
        }
    }

    private static int getColumnIndex(Expression expression) {
        return expression.resultTableColumnIndex;
    }

    private static HsqlArrayList evaluate(Expression expression) {
        if (expression.opType == 0) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            hsqlArrayList.add(new HsqlArrayList());
            return hsqlArrayList;
        }
        Expression[] expressionArray = expression.nodes;
        if (expressionArray.length == 0 || expression.opType != 26 && expression.opType != 25) {
            expressionArray = new Expression[]{expression};
        }
        switch (expression.groupingType) {
            case 61: {
                return GroupSet.powerSet(expressionArray);
            }
            case 256: {
                return GroupSet.rollUp(expressionArray);
            }
            case 553: {
                return GroupSet.grouping(expressionArray);
            }
        }
        if (expression.nodes.length == 0) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            HsqlArrayList<Integer> hsqlArrayList2 = new HsqlArrayList<Integer>();
            hsqlArrayList2.add(GroupSet.getColumnIndex(expression));
            hsqlArrayList.add(hsqlArrayList2);
            return hsqlArrayList;
        }
        return GroupSet.evaluate(expression.nodes);
    }

    private static HsqlArrayList evaluate(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (expressionArray.length == 0) {
            hsqlArrayList.add(new HsqlArrayList());
            return hsqlArrayList;
        }
        if (expressionArray[0] == null) {
            return hsqlArrayList;
        }
        HsqlArrayList hsqlArrayList2 = GroupSet.evaluate(expressionArray[0]);
        HsqlArrayList hsqlArrayList3 = GroupSet.evaluate(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        Iterator iterator = hsqlArrayList3.iterator();
        while (iterator.hasNext()) {
            HsqlArrayList hsqlArrayList4 = (HsqlArrayList)iterator.next();
            Iterator iterator2 = hsqlArrayList2.iterator();
            while (iterator2.hasNext()) {
                HsqlArrayList hsqlArrayList5 = new HsqlArrayList();
                HsqlArrayList hsqlArrayList6 = (HsqlArrayList)iterator2.next();
                hsqlArrayList5.addAll((Collection)hsqlArrayList6);
                hsqlArrayList5.addAll((Collection)hsqlArrayList4);
                hsqlArrayList.add(hsqlArrayList5);
            }
        }
        return hsqlArrayList;
    }

    private static HsqlArrayList powerSet(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList;
        HsqlArrayList hsqlArrayList2;
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        if (expressionArray.length == 0) {
            hsqlArrayList3.add(new HsqlArrayList());
            return hsqlArrayList3;
        }
        if (expressionArray[0].nodes.length != 0 && (expressionArray[0].opType == 26 || expressionArray[0].opType == 25)) {
            hsqlArrayList2 = GroupSet.evaluate(expressionArray[0]);
        } else {
            hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList = new HsqlArrayList();
            hsqlArrayList.add(GroupSet.getColumnIndex(expressionArray[0]));
            hsqlArrayList2.add(hsqlArrayList);
        }
        hsqlArrayList = GroupSet.powerSet(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        Iterator iterator = hsqlArrayList2.iterator();
        while (iterator.hasNext()) {
            HsqlArrayList hsqlArrayList4 = (HsqlArrayList)iterator.next();
            Iterator iterator2 = hsqlArrayList.iterator();
            while (iterator2.hasNext()) {
                HsqlArrayList hsqlArrayList5 = new HsqlArrayList();
                HsqlArrayList hsqlArrayList6 = (HsqlArrayList)iterator2.next();
                hsqlArrayList5.addAll((Collection)hsqlArrayList4);
                hsqlArrayList5.addAll((Collection)hsqlArrayList6);
                if (hsqlArrayList5.isEmpty()) continue;
                hsqlArrayList3.add(hsqlArrayList5);
            }
        }
        hsqlArrayList3.addAll((Collection)hsqlArrayList);
        return hsqlArrayList3;
    }

    private static HsqlArrayList rollUp(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList;
        HsqlArrayList hsqlArrayList2;
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        if (expressionArray.length == 0) {
            hsqlArrayList3.add(new HsqlArrayList());
            return hsqlArrayList3;
        }
        if (expressionArray[0].nodes.length != 0 && (expressionArray[0].opType == 26 || expressionArray[0].opType == 25)) {
            hsqlArrayList2 = GroupSet.evaluate(expressionArray[0]);
        } else {
            hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList = new HsqlArrayList();
            hsqlArrayList.add(GroupSet.getColumnIndex(expressionArray[0]));
            hsqlArrayList2.add(hsqlArrayList);
        }
        hsqlArrayList = GroupSet.rollUp(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        Iterator iterator = hsqlArrayList.iterator();
        while (iterator.hasNext()) {
            HsqlArrayList hsqlArrayList4 = (HsqlArrayList)iterator.next();
            Iterator iterator2 = hsqlArrayList2.iterator();
            while (iterator2.hasNext()) {
                HsqlArrayList hsqlArrayList5 = (HsqlArrayList)iterator2.next();
                HsqlArrayList hsqlArrayList6 = new HsqlArrayList();
                hsqlArrayList6.addAll((Collection)hsqlArrayList5);
                hsqlArrayList6.addAll((Collection)hsqlArrayList4);
                hsqlArrayList3.add(hsqlArrayList6);
            }
        }
        hsqlArrayList3.add(new HsqlArrayList());
        return hsqlArrayList3;
    }

    private static HsqlArrayList grouping(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList;
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        if (expressionArray.length == 0) {
            return hsqlArrayList2;
        }
        if (expressionArray[0].nodes.length != 0 && (expressionArray[0].opType == 26 || expressionArray[0].opType == 25)) {
            hsqlArrayList2 = GroupSet.evaluate(expressionArray[0]);
        } else {
            hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList = new HsqlArrayList();
            if (expressionArray[0].opType != 0) {
                hsqlArrayList.add(GroupSet.getColumnIndex(expressionArray[0]));
            }
            hsqlArrayList2.add(hsqlArrayList);
        }
        hsqlArrayList = GroupSet.grouping(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        hsqlArrayList2.addAll((Collection)hsqlArrayList);
        return hsqlArrayList2;
    }
}

