/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class FunctionSQL
extends Expression {
    protected static final int FUNC_POSITION_CHAR = 1;
    private static final int FUNC_POSITION_BINARY = 2;
    private static final int FUNC_OCCURENCES_REGEX = 3;
    private static final int FUNC_POSITION_REGEX = 4;
    protected static final int FUNC_EXTRACT = 5;
    protected static final int FUNC_BIT_LENGTH = 6;
    protected static final int FUNC_CHAR_LENGTH = 7;
    protected static final int FUNC_OCTET_LENGTH = 8;
    private static final int FUNC_CARDINALITY = 9;
    private static final int FUNC_MAX_CARDINALITY = 10;
    private static final int FUNC_TRIM_ARRAY = 11;
    private static final int FUNC_ABS = 12;
    private static final int FUNC_MOD = 13;
    protected static final int FUNC_LN = 14;
    private static final int FUNC_EXP = 15;
    private static final int FUNC_POWER = 16;
    private static final int FUNC_SQRT = 17;
    private static final int FUNC_FLOOR = 20;
    private static final int FUNC_CEILING = 21;
    private static final int FUNC_WIDTH_BUCKET = 22;
    protected static final int FUNC_SUBSTRING_CHAR = 23;
    private static final int FUNC_SUBSTRING_REG_EXPR = 24;
    private static final int FUNC_SUBSTRING_REGEX = 25;
    protected static final int FUNC_FOLD_LOWER = 26;
    protected static final int FUNC_FOLD_UPPER = 27;
    private static final int FUNC_TRANSCODING = 28;
    private static final int FUNC_TRANSLITERATION = 29;
    private static final int FUNC_REGEX_TRANSLITERATION = 30;
    protected static final int FUNC_TRIM_CHAR = 31;
    static final int FUNC_OVERLAY_CHAR = 32;
    private static final int FUNC_CHAR_NORMALIZE = 33;
    private static final int FUNC_SUBSTRING_BINARY = 40;
    private static final int FUNC_TRIM_BINARY = 41;
    private static final int FUNC_OVERLAY_BINARY = 42;
    protected static final int FUNC_CURRENT_DATE = 43;
    protected static final int FUNC_CURRENT_TIME = 44;
    protected static final int FUNC_CURRENT_TIMESTAMP = 50;
    protected static final int FUNC_LOCALTIME = 51;
    protected static final int FUNC_LOCALTIMESTAMP = 52;
    private static final int FUNC_CURRENT_CATALOG = 53;
    private static final int FUNC_CURRENT_DEFAULT_TRANSFORM_GROUP = 54;
    private static final int FUNC_CURRENT_PATH = 55;
    private static final int FUNC_CURRENT_ROLE = 56;
    private static final int FUNC_CURRENT_SCHEMA = 57;
    private static final int FUNC_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 58;
    private static final int FUNC_CURRENT_USER = 59;
    private static final int FUNC_SESSION_USER = 60;
    private static final int FUNC_SYSTEM_USER = 61;
    protected static final int FUNC_USER = 62;
    private static final int FUNC_VALUE = 63;
    static final short[] noParamList = new short[0];
    static final short[] emptyParamList = new short[]{937, 922};
    static final short[] optionalNoParamList = new short[]{1002, 2, 937, 922};
    static final short[] optionalSingleParamList = new short[]{937, 1002, 1, 939, 922};
    static final short[] singleParamList = new short[]{937, 939, 922};
    static final short[] optionalIntegerParamList = new short[]{1002, 3, 937, 1004, 922};
    static final short[] optionalDoubleParamList = new short[]{937, 939, 1002, 2, 924, 939, 922};
    static final short[] doubleParamList = new short[]{937, 939, 924, 939, 922};
    static final short[] tripleParamList = new short[]{937, 939, 924, 939, 924, 939, 922};
    static final short[] quadParamList = new short[]{937, 939, 924, 939, 924, 939, 924, 939, 922};
    static IntValueHashMap valueFuncMap = new IntValueHashMap();
    static IntValueHashMap regularFuncMap = new IntValueHashMap();
    static OrderedIntHashSet nonDeterministicFuncSet = new OrderedIntHashSet();
    int funcType;
    boolean isDeterministic;
    String name;
    short[] parseList;
    short[] parseListAlt;
    boolean isSQLValueFunction;

    public static FunctionSQL newSQLFunction(String string, ParserDQL.CompileContext compileContext) {
        int n2 = regularFuncMap.get((Object)string, -1);
        boolean bl = false;
        if (n2 == -1) {
            n2 = valueFuncMap.get((Object)string, -1);
            bl = true;
        }
        if (n2 == -1) {
            return null;
        }
        FunctionSQL functionSQL = new FunctionSQL(n2);
        if (n2 == 63) {
            if (compileContext.currentDomain == null) {
                return null;
            }
            functionSQL.dataType = compileContext.currentDomain;
        } else {
            functionSQL.isSQLValueFunction = bl;
        }
        return functionSQL;
    }

    protected FunctionSQL() {
        super(28);
    }

    protected FunctionSQL(int n2) {
        this();
        this.funcType = n2;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n2);
        switch (n2) {
            case 1: 
            case 2: {
                this.name = "POSITION";
                this.parseList = new short[]{937, 939, 140, 939, 1002, 5, 322, 1001, 2, 377, 492, 922};
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = new short[]{937, 1001, 20, 341, 183, 78, 137, 179, 264, 736, 851, 787, 737, 735, 852, 734, 773, 805, 299, 300, 872, 871, 873, 124, 939, 922};
                break;
            }
            case 7: {
                this.name = "CHAR_LENGTH";
                this.parseList = new short[]{937, 939, 1002, 5, 322, 1001, 2, 377, 492, 922};
                break;
            }
            case 6: {
                this.name = "BIT_LENGTH";
                this.parseList = singleParamList;
                break;
            }
            case 8: {
                this.name = "OCTET_LENGTH";
                this.parseList = singleParamList;
                break;
            }
            case 9: {
                this.name = "CARDINALITY";
                this.parseList = singleParamList;
                break;
            }
            case 10: {
                this.name = "MAX_CARDINALITY";
                this.parseList = singleParamList;
                break;
            }
            case 11: {
                this.name = "TRIM_ARRAY";
                this.parseList = doubleParamList;
                break;
            }
            case 12: {
                this.name = "ABS";
                this.parseList = singleParamList;
                break;
            }
            case 13: {
                this.name = "MOD";
                this.parseList = doubleParamList;
                break;
            }
            case 14: {
                this.name = "LN";
                this.parseList = singleParamList;
                break;
            }
            case 15: {
                this.name = "EXP";
                this.parseList = singleParamList;
                break;
            }
            case 16: {
                this.name = "POWER";
                this.parseList = doubleParamList;
                break;
            }
            case 17: {
                this.name = "SQRT";
                this.parseList = singleParamList;
                break;
            }
            case 20: {
                this.name = "FLOOR";
                this.parseList = singleParamList;
                break;
            }
            case 21: {
                this.name = "CEILING";
                this.parseList = singleParamList;
                break;
            }
            case 22: {
                this.name = "WIDTH_BUCKET";
                this.parseList = quadParamList;
                break;
            }
            case 23: 
            case 40: {
                this.name = "SUBSTRING";
                this.parseList = new short[]{937, 939, 124, 939, 1002, 2, 120, 939, 1002, 5, 322, 1001, 2, 377, 492, 922};
                this.parseListAlt = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 26: {
                this.name = "LOWER";
                this.parseList = singleParamList;
                break;
            }
            case 27: {
                this.name = "UPPER";
                this.parseList = singleParamList;
                break;
            }
            case 31: 
            case 41: {
                this.name = "TRIM";
                this.parseList = new short[]{937, 1002, 11, 1002, 5, 1001, 3, 161, 302, 26, 1002, 1, 939, 124, 939, 922};
                break;
            }
            case 32: 
            case 42: {
                this.name = "OVERLAY";
                this.parseList = new short[]{937, 939, 514, 939, 124, 939, 1002, 2, 120, 939, 1002, 2, 322, 377, 922};
                break;
            }
            case 53: {
                this.name = "CURRENT_CATALOG";
                this.parseList = noParamList;
                break;
            }
            case 56: {
                this.name = "CURRENT_ROLE";
                this.parseList = noParamList;
                break;
            }
            case 57: {
                this.name = "CURRENT_SCHEMA";
                this.parseList = noParamList;
                break;
            }
            case 59: {
                this.name = "CURRENT_USER";
                this.parseList = noParamList;
                break;
            }
            case 60: {
                this.name = "SESSION_USER";
                this.parseList = noParamList;
                break;
            }
            case 61: {
                this.name = "SYSTEM_USER";
                this.parseList = noParamList;
                break;
            }
            case 62: {
                this.name = "USER";
                this.parseList = optionalNoParamList;
                break;
            }
            case 63: {
                this.name = "VALUE";
                this.parseList = noParamList;
                break;
            }
            case 43: {
                this.name = "CURRENT_DATE";
                this.parseList = noParamList;
                break;
            }
            case 44: {
                this.name = "CURRENT_TIME";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 50: {
                this.name = "CURRENT_TIMESTAMP";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 51: {
                this.name = "LOCALTIME";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 52: {
                this.name = "LOCALTIMESTAMP";
                this.parseList = optionalIntegerParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    public void setArguments(Expression[] expressionArray) {
        this.nodes = expressionArray;
    }

    public Expression getFunctionExpression() {
        return this;
    }

    @Override
    public Object getValue(Session session) {
        Object[] objectArray = ValuePool.emptyObjectArray;
        if (this.nodes.length > 0) {
            objectArray = new Object[this.nodes.length];
            for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                Expression expression = this.nodes[i2];
                if (expression == null) continue;
                objectArray[i2] = expression.getValue(session, expression.dataType);
            }
        }
        return this.getValue(session, objectArray);
    }

    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 1: {
                Object object;
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                long l2 = 0L;
                if (this.nodes.length > 3 && this.nodes[3] != null && (l2 = ((Number)(object = this.nodes[3].getValue(session))).longValue() - 1L) < 0L) {
                    l2 = 0L;
                }
                long l3 = ((CharacterType)this.nodes[1].dataType).position(session, objectArray[1], objectArray[0], this.nodes[0].dataType, l2) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 492) {
                    l3 *= 2L;
                }
                return ValuePool.getLong(l3);
            }
            case 2: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                long l4 = ((BinaryType)this.nodes[1].dataType).position(session, (BlobData)objectArray[1], (BlobData)objectArray[0], this.nodes[0].dataType, 0L) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 492) {
                    l4 *= 2L;
                }
                return ValuePool.getLong(l4);
            }
            case 5: {
                return this.getExtractValue(session, objectArray);
            }
            case 7: {
                if (objectArray[0] == null) {
                    return null;
                }
                long l5 = ((CharacterType)this.nodes[0].dataType).size(session, objectArray[0]);
                return ValuePool.getLong(l5);
            }
            case 6: {
                if (objectArray[0] == null) {
                    return null;
                }
                long l6 = this.nodes[0].dataType.isBinaryType() ? ((BlobData)objectArray[0]).bitLength(session) : 16L * ((CharacterType)this.nodes[0].dataType).size(session, objectArray[0]);
                return ValuePool.getLong(l6);
            }
            case 8: {
                if (objectArray[0] == null) {
                    return null;
                }
                long l7 = this.nodes[0].dataType.isBinaryType() ? ((BlobData)objectArray[0]).length(session) : 2L * ((CharacterType)this.nodes[0].dataType).size(session, objectArray[0]);
                return ValuePool.getLong(l7);
            }
            case 9: {
                if (objectArray[0] == null) {
                    return null;
                }
                int n2 = this.nodes[0].dataType.cardinality(session, objectArray[0]);
                return ValuePool.getInt(n2);
            }
            case 10: {
                if (objectArray[0] == null) {
                    return null;
                }
                int n3 = this.nodes[0].dataType.arrayLimitCardinality();
                return ValuePool.getInt(n3);
            }
            case 11: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                Object[] objectArray2 = (Object[])objectArray[0];
                int n4 = ((Number)objectArray[1]).intValue();
                if (n4 < 0 || n4 > objectArray2.length) {
                    throw Error.error(3490);
                }
                Object[] objectArray3 = new Object[objectArray2.length - n4];
                System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray3.length);
                return objectArray3;
            }
            case 12: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.absolute(objectArray[0]);
            }
            case 13: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                objectArray[0] = this.nodeDataTypes[0].convertToType(session, objectArray[0], this.nodes[0].dataType);
                objectArray[1] = this.nodeDataTypes[1].convertToType(session, objectArray[1], this.nodes[1].dataType);
                Object object = ((NumberType)this.nodeDataTypes[0]).modulo(session, objectArray[0], objectArray[1], this.nodeDataTypes[1]);
                return object;
            }
            case 14: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d2 = ((Number)objectArray[0]).doubleValue();
                if (d2 <= 0.0 && session.database.sqlDoubleNaN) {
                    throw Error.error(3444);
                }
                d2 = Math.log(d2);
                return ValuePool.getDouble(Double.doubleToLongBits(d2));
            }
            case 15: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d3 = Math.exp(((Number)objectArray[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(d3));
            }
            case 16: {
                double d4;
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                double d5 = ((Number)objectArray[0]).doubleValue();
                double d6 = ((Number)objectArray[1]).doubleValue();
                if (d5 == 0.0) {
                    if (d6 < 0.0) {
                        throw Error.error(3445);
                    }
                    d4 = d6 == 0.0 ? 1.0 : 0.0;
                } else {
                    d4 = Math.pow(d5, d6);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(d4));
            }
            case 17: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d7 = ((Number)objectArray[0]).doubleValue();
                if (d7 < 0.0 && session.database.sqlDoubleNaN) {
                    throw Error.error(3444);
                }
                double d8 = Math.sqrt(((Number)objectArray[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(d8));
            }
            case 20: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).floor(objectArray[0]);
            }
            case 21: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).ceiling(objectArray[0]);
            }
            case 22: {
                Type type;
                Object object;
                Object object2;
                int n5;
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    if (objectArray[n5] == null) {
                        return null;
                    }
                    objectArray[n5] = this.nodeDataTypes[n5].convertToType(session, objectArray[n5], this.nodes[n5].dataType);
                }
                if (this.nodeDataTypes[3].isNegative(objectArray[3])) {
                    throw Error.error(3446);
                }
                n5 = this.nodeDataTypes[1].compare(session, objectArray[1], objectArray[2]);
                Type type2 = this.nodeDataTypes[0].isNumberType() ? this.nodeDataTypes[0] : this.nodeDataTypes[0].getCombinedType(session, this.nodeDataTypes[0], 33);
                switch (n5) {
                    case 0: {
                        throw Error.error(3446);
                    }
                    case -1: {
                        if (this.nodeDataTypes[0].compare(session, objectArray[0], objectArray[1]) < 0) {
                            return ValuePool.INTEGER_0;
                        }
                        if (this.nodeDataTypes[0].compare(session, objectArray[0], objectArray[2]) >= 0) {
                            return this.dataType.add(session, objectArray[3], ValuePool.INTEGER_1, Type.SQL_INTEGER);
                        }
                        object2 = type2.subtract(session, objectArray[0], objectArray[1], this.nodeDataTypes[1]);
                        object = type2.subtract(session, objectArray[2], objectArray[1], this.nodeDataTypes[1]);
                        break;
                    }
                    case 1: {
                        if (this.nodeDataTypes[0].compare(session, objectArray[0], objectArray[1]) > 0) {
                            return ValuePool.INTEGER_0;
                        }
                        if (this.nodeDataTypes[0].compare(session, objectArray[0], objectArray[2]) <= 0) {
                            return this.dataType.add(session, objectArray[3], ValuePool.INTEGER_1, Type.SQL_INTEGER);
                        }
                        object2 = type2.subtract(session, objectArray[1], objectArray[0], this.nodeDataTypes[0]);
                        object = type2.subtract(session, objectArray[1], objectArray[2], this.nodeDataTypes[2]);
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "");
                    }
                }
                if (type2.typeCode == 8) {
                    type = type2;
                } else {
                    type = IntervalType.factorType;
                    object2 = type.convertToType(session, object2, type2);
                    object = type.convertToType(session, object, type2);
                }
                object2 = type.multiply(object2, objectArray[3]);
                object2 = type.divide(session, object2, object);
                object2 = this.dataType.convertToDefaultType(session, object2);
                return this.dataType.add(session, object2, ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            case 23: {
                long l8 = 0L;
                boolean bl = false;
                boolean bl2 = false;
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                if (this.nodes[2] != null && objectArray[2] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].dataType);
                long l9 = ((Number)object).longValue();
                if (this.nodes[2] != null) {
                    bl = true;
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                    l8 = ((Number)object).longValue();
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null || ((Number)this.nodes[2].valueData).intValue() == 492) {
                    // empty if block
                }
                if (session.database.sqlSyntaxOra && this.name == "SUBSTR") {
                    if (l9 == 0L) {
                        l9 = 1L;
                    } else if (l9 < 0L) {
                        l9 = -l9 + 1L;
                        bl2 = true;
                    }
                }
                return ((CharacterType)this.dataType).substring(session, objectArray[0], --l9, l8, bl, bl2);
            }
            case 26: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).lower(session, objectArray[0]);
            }
            case 27: {
                if (objectArray[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).upper(session, objectArray[0]);
            }
            case 31: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                boolean bl = false;
                boolean bl3 = false;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 26: {
                        bl3 = true;
                        bl = true;
                        break;
                    }
                    case 161: {
                        bl = true;
                        break;
                    }
                    case 302: {
                        bl3 = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                String string = (String)objectArray[1];
                if (string.length() != 1) {
                    throw Error.error(3460);
                }
                char c2 = string.charAt(0);
                return ((CharacterType)this.dataType).trim(session, objectArray[2], c2, bl, bl3);
            }
            case 32: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                long l10 = ((Number)object).longValue() - 1L;
                long l11 = 0L;
                if (this.nodes[3] != null) {
                    if (objectArray[3] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[3], this.nodes[3].dataType);
                    l11 = ((Number)object).longValue();
                }
                return ((CharacterType)this.dataType).overlay(session, objectArray[0], objectArray[1], l10, l11, this.nodes[3] != null);
            }
            case 40: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].dataType);
                long l12 = ((Number)object).longValue() - 1L;
                long l13 = 0L;
                if (this.nodes[2] != null) {
                    if (objectArray[2] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                    l13 = ((Number)object).intValue();
                }
                return ((BinaryType)this.dataType).substring(session, (BlobData)objectArray[0], l12, l13, this.nodes[2] != null);
            }
            case 41: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                boolean bl = false;
                boolean bl4 = false;
                int n6 = ((Number)this.nodes[0].valueData).intValue();
                switch (n6) {
                    case 26: {
                        bl4 = true;
                        bl = true;
                        break;
                    }
                    case 161: {
                        bl = true;
                        break;
                    }
                    case 302: {
                        bl4 = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                BlobData blobData = (BlobData)objectArray[1];
                if (blobData.length(session) != 1L) {
                    throw Error.error(3460);
                }
                byte[] byArray = blobData.getBytes();
                return ((BinaryType)this.dataType).trim(session, (BlobData)objectArray[2], byArray[0], bl, bl4);
            }
            case 42: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                Object object = Type.SQL_BIGINT.convertToType(session, objectArray[2], this.nodes[2].dataType);
                long l14 = ((Number)object).longValue() - 1L;
                long l15 = 0L;
                if (this.nodes[3] != null) {
                    if (objectArray[3] == null) {
                        return null;
                    }
                    object = Type.SQL_BIGINT.convertToType(session, objectArray[3], this.nodes[3].dataType);
                    l15 = ((Number)object).longValue();
                }
                return ((BinaryType)this.dataType).overlay(session, (BlobData)objectArray[0], (BlobData)objectArray[1], l14, l15, this.nodes[3] != null);
            }
            case 53: {
                return session.database.getCatalogName().name;
            }
            case 56: {
                return session.getRole() == null ? null : session.getRole().getName().getNameString();
            }
            case 57: {
                return session.getCurrentSchemaHsqlName().name;
            }
            case 59: {
                return session.getUser().getName().getNameString();
            }
            case 60: {
                return session.getUser().getName().getNameString();
            }
            case 61: {
                return session.getUser().getName().getNameString();
            }
            case 62: {
                return session.getUser().getName().getNameString();
            }
            case 63: {
                return session.sessionData.currentValue;
            }
            case 43: {
                if (session.database.sqlSyntaxOra) {
                    return this.dataType.convertToTypeLimits(session, session.getLocalTimestamp());
                }
                return session.getCurrentDate();
            }
            case 44: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime());
            }
            case 50: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp());
            }
            case 51: {
                return this.dataType.convertToTypeLimits(session, session.getLocalTime());
            }
            case 52: {
                return this.dataType.convertToTypeLimits(session, session.getLocalTimestamp());
            }
        }
        throw Error.runtimeError(201, "FunctionSQL");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            this.nodes[n2].resolveTypes(session, this);
        }
        switch (this.funcType) {
            case 1: 
            case 2: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        throw Error.error(5567);
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 1;
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    if (this.nodes[0].dataType.isBitType() || this.nodes[1].dataType.isBitType()) {
                        throw Error.error(5563);
                    }
                    this.funcType = 2;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    if (this.nodes[3].isDynamicParam()) {
                        this.nodes[3].dataType = Type.SQL_BIGINT;
                    }
                    if (!this.nodes[3].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 5: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType() && !this.nodes[1].dataType.isIntervalType()) {
                    throw Error.error(5563);
                }
                n2 = ((Number)this.nodes[0].valueData).intValue();
                DTIType dTIType = (DTIType)this.nodes[1].dataType;
                n2 = DTIType.getFieldNameTypeForToken(n2);
                this.dataType = dTIType.getExtractType(n2);
                break;
            }
            case 6: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_BIT_VARYING_MAX_LENGTH;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 7: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
            }
            case 8: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 9: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 10: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 11: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 13: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodeDataTypes = new Type[2];
                if (session.database.sqlSyntaxOra) {
                    this.nodeDataTypes[0] = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                    this.nodeDataTypes[1] = this.nodes[1].dataType;
                } else {
                    this.nodeDataTypes[0] = ((NumberType)this.nodes[0].dataType).getIntegralType();
                    this.nodeDataTypes[1] = ((NumberType)this.nodes[1].dataType).getIntegralType();
                }
                this.dataType = this.nodeDataTypes[1];
                break;
            }
            case 16: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 12: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isIntervalType()) {
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
            }
            case 20: 
            case 21: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 3 && this.dataType.typeCode != 2 || this.dataType.scale <= 0) break;
                this.dataType = NumberType.getNumberType(this.dataType.typeCode, this.dataType.precision + 1L, 0);
                break;
            }
            case 22: {
                this.nodeDataTypes = new Type[4];
                this.nodeDataTypes[0] = Type.getAggregateType(this.nodes[0].dataType, this.nodes[1].dataType);
                this.nodeDataTypes[0] = Type.getAggregateType(this.nodeDataTypes[0], this.nodes[2].dataType);
                if (this.nodeDataTypes[0] == null) {
                    throw Error.error(5567);
                }
                if (!this.nodeDataTypes[0].isNumberType() && !this.nodeDataTypes[0].isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.nodeDataTypes[1] = this.nodeDataTypes[0];
                this.nodeDataTypes[2] = this.nodeDataTypes[0];
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodeDataTypes[1];
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodeDataTypes[2];
                }
                if (this.nodes[3].dataType == null) {
                    this.nodes[3].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[3].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.nodeDataTypes[3] = this.nodes[3].dataType;
                this.dataType = this.nodes[3].dataType;
                break;
            }
            case 23: 
            case 40: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_NUMERIC;
                    }
                    if (!this.nodes[2].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 23;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision, this.dataType.getCollation());
                    }
                } else if (this.dataType.isBinaryType()) {
                    this.funcType = 40;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null) break;
                break;
            }
            case 26: 
            case 27: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) break;
                throw Error.error(5563);
            }
            case 31: 
            case 41: {
                if (this.nodes[0] == null) {
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(26), Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 31;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision, this.dataType.getCollation());
                    }
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(" ", Type.SQL_CHAR);
                    break;
                }
                if (this.dataType.isBinaryType()) {
                    this.funcType = 41;
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(new BinaryData(new byte[]{0}, false), Type.SQL_BINARY);
                    break;
                }
                throw Error.error(5563);
            }
            case 32: 
            case 42: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                        this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 32;
                    this.dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[1].dataType.typeCode == 40 ? CharacterType.getCharacterType(40, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision, this.nodes[0].dataType.getCollation()) : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision, this.nodes[0].dataType.getCollation());
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    this.funcType = 42;
                    this.dataType = this.nodes[0].dataType.typeCode == 30 || this.nodes[1].dataType.typeCode == 30 ? BinaryType.getBinaryType(30, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[2].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[3] == null) break;
                if (this.nodes[3].dataType == null) {
                    this.nodes[3].dataType = Type.SQL_NUMERIC;
                }
                if (this.nodes[3].dataType.isNumberType()) break;
                throw Error.error(5563);
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.dataType = TypeInvariants.SQL_IDENTIFIER;
                break;
            }
            case 63: {
                break;
            }
            case 43: {
                if (session.database.sqlSyntaxOra) {
                    this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                    break;
                }
                this.dataType = Type.SQL_DATE;
                break;
            }
            case 44: {
                n2 = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n2 = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(94, n2);
                break;
            }
            case 50: {
                n2 = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n2 = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(95, n2);
                break;
            }
            case 51: {
                n2 = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n2 = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(92, n2);
                break;
            }
            case 52: {
                n2 = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n2 = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(93, n2);
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    Object getExtractValue(Session session, Object[] objectArray) {
        if (objectArray[1] == null) {
            return null;
        }
        int n2 = ((Number)this.nodes[0].valueData).intValue();
        n2 = DTIType.getFieldNameTypeForToken(n2);
        switch (n2) {
            case 106: {
                return ((DTIType)this.nodes[1].dataType).getSecondPart(session, objectArray[1]);
            }
            case 128: 
            case 129: {
                return ((DateTimeType)this.nodes[1].dataType).getPartString(session, objectArray[1], n2);
            }
        }
        int n3 = ((DTIType)this.nodes[1].dataType).getPart(session, objectArray[1], n2);
        return ValuePool.getInt(n3);
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.funcType) {
            case 1: 
            case 2: {
                stringBuilder.append("POSITION").append('(').append(this.nodes[0].getSQL()).append(' ').append("IN").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null && Boolean.TRUE.equals(this.nodes[2].valueData)) {
                    stringBuilder.append(' ').append("USING").append(' ').append("OCTETS");
                }
                stringBuilder.append(')');
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int n2 = (Integer)this.nodes[0].valueData;
                n2 = DTIType.getFieldNameTypeForToken(n2);
                String string = DTIType.getFieldNameTokenForType(n2);
                stringBuilder.append("EXTRACT").append('(').append(string).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 7: {
                stringBuilder.append("CHAR_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 6: {
                stringBuilder.append("BIT_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 8: {
                stringBuilder.append("OCTET_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 9: {
                stringBuilder.append("CARDINALITY").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 10: {
                stringBuilder.append("MAX_CARDINALITY").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 11: {
                stringBuilder.append("TRIM_ARRAY").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 12: {
                stringBuilder.append("ABS").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 13: {
                stringBuilder.append("MOD").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 14: {
                stringBuilder.append("LN").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 15: {
                stringBuilder.append("EXP").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 16: {
                stringBuilder.append("POWER").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 17: {
                stringBuilder.append("SQRT").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 20: {
                stringBuilder.append("FLOOR").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 21: {
                stringBuilder.append("CEILING").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 22: {
                stringBuilder.append("WIDTH_BUCKET").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(',').append(this.nodes[2].getSQL()).append(',').append(this.nodes[3].getSQL()).append(')');
                break;
            }
            case 23: 
            case 40: {
                stringBuilder.append("SUBSTRING").append('(').append(this.nodes[0].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuilder.append(' ').append("FOR").append(' ').append(this.nodes[2].getSQL());
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && Boolean.TRUE.equals(this.nodes[3].valueData)) {
                    stringBuilder.append(' ').append("USING").append(' ').append("OCTETS");
                }
                stringBuilder.append(')');
                break;
            }
            case 26: {
                stringBuilder.append("LOWER").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 27: {
                stringBuilder.append("UPPER").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 32: 
            case 42: {
                stringBuilder.append("OVERLAY").append('(').append(this.nodes[0].getSQL()).append(' ').append("PLACING").append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    stringBuilder.append(' ').append("FOR").append(' ').append(this.nodes[3].getSQL());
                }
                if (this.nodes[4] != null && Boolean.TRUE.equals(this.nodes[4].valueData)) {
                    stringBuilder.append(' ').append("USING").append(' ').append("OCTETS");
                }
                stringBuilder.append(')');
                break;
            }
            case 31: 
            case 41: {
                String string = null;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 26: {
                        string = "BOTH";
                        break;
                    }
                    case 161: {
                        string = "LEADING";
                        break;
                    }
                    case 302: {
                        string = "TRAILING";
                        break;
                    }
                }
                stringBuilder.append("TRIM").append('(').append(string).append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL()).append(')');
                break;
            }
            case 43: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.name;
            }
            case 44: 
            case 51: {
                int n3 = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n3 = ((Number)this.nodes[0].valueData).intValue();
                }
                if (n3 == 0) {
                    return this.name;
                }
                stringBuilder.append(this.name).append("(").append(n3);
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 50: 
            case 52: {
                int n4 = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    n4 = ((Number)this.nodes[0].valueData).intValue();
                }
                if (n4 == 6) {
                    return this.name;
                }
                stringBuilder.append(this.name).append("(").append(n4);
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    boolean equals(Expression expression) {
        if (expression instanceof FunctionSQL) {
            FunctionSQL functionSQL = (FunctionSQL)expression;
            return super.equals(expression) && this.funcType == functionSQL.funcType;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.opType + this.funcType;
    }

    @Override
    public String describe(Session session, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("FUNCTION ").append("=[\n");
        stringBuilder.append(this.name).append("(");
        for (n3 = 0; n3 < this.nodes.length; ++n3) {
            if (this.nodes[n3] == null) continue;
            stringBuilder.append("[").append(this.nodes[n3].describe(session, n2)).append("]");
        }
        stringBuilder.append(") returns ").append(this.dataType.getNameString());
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public boolean isValueFunction() {
        return this.isSQLValueFunction;
    }

    static {
        regularFuncMap.put("POSITION", 1);
        regularFuncMap.put("POSITION_REGEX", 4);
        regularFuncMap.put("EXTRACT", 5);
        regularFuncMap.put("BIT_LENGTH", 6);
        regularFuncMap.put("CHAR_LENGTH", 7);
        regularFuncMap.put("CHARACTER_LENGTH", 7);
        regularFuncMap.put("OCTET_LENGTH", 8);
        regularFuncMap.put("CARDINALITY", 9);
        regularFuncMap.put("ARRAY_MAX_CARDINALITY", 10);
        regularFuncMap.put("MAX_CARDINALITY", 10);
        regularFuncMap.put("TRIM_ARRAY", 11);
        regularFuncMap.put("ABS", 12);
        regularFuncMap.put("MOD", 13);
        regularFuncMap.put("LN", 14);
        regularFuncMap.put("EXP", 15);
        regularFuncMap.put("POWER", 16);
        regularFuncMap.put("SQRT", 17);
        regularFuncMap.put("FLOOR", 20);
        regularFuncMap.put("CEILING", 21);
        regularFuncMap.put("CEIL", 21);
        regularFuncMap.put("WIDTH_BUCKET", 22);
        regularFuncMap.put("SUBSTRING", 23);
        regularFuncMap.put("SUBSTRING_REGEX", 25);
        regularFuncMap.put("LOWER", 26);
        regularFuncMap.put("UPPER", 27);
        regularFuncMap.put("TRIM", 31);
        regularFuncMap.put("OVERLAY", 32);
        regularFuncMap.put("TRIM", 41);
        valueFuncMap.put("CURRENT_DATE", 43);
        valueFuncMap.put("CURRENT_TIME", 44);
        valueFuncMap.put("CURRENT_TIMESTAMP", 50);
        valueFuncMap.put("LOCALTIME", 51);
        valueFuncMap.put("LOCALTIMESTAMP", 52);
        valueFuncMap.put("CURRENT_CATALOG", 53);
        valueFuncMap.put("CURRENT_PATH", 55);
        valueFuncMap.put("CURRENT_ROLE", 56);
        valueFuncMap.put("CURRENT_SCHEMA", 57);
        valueFuncMap.put("CURRENT_USER", 59);
        valueFuncMap.put("SESSION_USER", 60);
        valueFuncMap.put("SYSTEM_USER", 61);
        valueFuncMap.put("USER", 62);
        valueFuncMap.put("VALUE", 63);
        nonDeterministicFuncSet.addAll(valueFuncMap.values());
    }
}

