/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.OpTypes;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    static final HsqlNameManager.SimpleName rownumName = HsqlNameManager.getSimpleName("ROWNUM", false);
    public static final OrderedHashMap diagnosticsList = new OrderedHashMap();
    static final String[] diagnosticsVariableTokens = new String[]{"NUMBER", "MORE", "ROW_COUNT"};
    public static final int idx_number = 0;
    public static final int idx_more = 1;
    public static final int idx_row_count = 2;
    ColumnSchema column;
    String schema;
    String tableName;
    String columnName;
    RangeVariable rangeVariable;
    int rangePosition = -1;
    NumberSequence sequence;
    boolean isUpdateColumn;
    boolean isParam;

    ExpressionColumn(String string, String string2, String string3) {
        super(2);
        this.schema = string;
        this.tableName = string2;
        this.columnName = string3;
    }

    ExpressionColumn(String string) {
        super(2);
        this.columnName = string;
        this.isUpdateColumn = true;
    }

    ExpressionColumn(ColumnSchema columnSchema) {
        super(2);
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
        this.columnName = columnSchema.getName().name;
    }

    ExpressionColumn(RangeVariable rangeVariable, ColumnSchema columnSchema) {
        super(2);
        this.columnIndex = rangeVariable.findColumn(columnSchema.getNameString());
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
        this.rangeVariable = rangeVariable;
        this.columnName = columnSchema.getName().name;
        this.tableName = rangeVariable.getTableAlias().name;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    ExpressionColumn(RangeVariable rangeVariable, int n2) {
        super(2);
        this.columnIndex = n2;
        this.setAutoAttributesAsColumn(rangeVariable, this.columnIndex);
    }

    ExpressionColumn(Expression expression, int n2, int n3) {
        super(5);
        this.dataType = expression.dataType;
        this.columnIndex = n2;
        this.alias = expression.getSimpleName();
        this.rangePosition = n3;
    }

    ExpressionColumn(int n2) {
        super(n2);
        if (n2 == 14) {
            this.columnName = ExpressionColumn.rownumName.name;
            this.dataType = Type.SQL_INTEGER;
        }
    }

    ExpressionColumn(int n2, int n3) {
        super(n2);
        if (n2 == 8) {
            this.isParam = true;
            this.parameterIndex = n3;
            return;
        }
        this.column = (ColumnSchema)diagnosticsList.get(n3);
        this.columnIndex = n3;
        this.dataType = this.column.dataType;
    }

    ExpressionColumn(Expression[] expressionArray, String string) {
        super(3);
        this.nodes = expressionArray;
        this.columnName = string;
    }

    ExpressionColumn(Expression expression) {
        super(105);
        Expression[] expressionArray = expression.nodes;
        if (expression.nodes.length == 0) {
            expressionArray = new Expression[]{expression};
        }
        this.nodes = expressionArray;
        this.dataType = Type.SQL_INTEGER;
    }

    ExpressionColumn(String string, String string2) {
        super(99);
        this.schema = string;
        this.tableName = string2;
    }

    ExpressionColumn(NumberSequence numberSequence, int n2) {
        super(n2);
        this.sequence = numberSequence;
        this.dataType = numberSequence.getDataType();
    }

    void setAutoAttributesAsColumn(RangeVariable rangeVariable, int n2) {
        this.columnIndex = n2;
        this.column = rangeVariable.getColumn(n2);
        this.dataType = this.column.getDataType();
        this.columnName = rangeVariable.getColumnAlias((int)n2).name;
        this.tableName = rangeVariable.getTableAlias().name;
        this.rangeVariable = rangeVariable;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    void setAttributesAsColumn(RangeVariable rangeVariable, int n2) {
        this.columnIndex = n2;
        this.column = rangeVariable.getColumn(n2);
        this.dataType = this.column.getDataType();
        this.rangeVariable = rangeVariable;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    @Override
    public byte getNullability() {
        switch (this.opType) {
            case 2: {
                if (this.nullability == 2) {
                    return this.column.getNullability();
                }
                return this.nullability;
            }
            case 3: 
            case 12: 
            case 14: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    void setAttributesAsColumn(ColumnSchema columnSchema) {
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
    }

    @Override
    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.rangeVariable != null && this.rangeVariable.hasColumnAlias()) {
            return this.rangeVariable.getColumnAlias(this.columnIndex);
        }
        if (this.column != null) {
            return this.column.getName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        if (this.opType == 14) {
            return rownumName;
        }
        return null;
    }

    @Override
    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        switch (this.opType) {
            case 2: 
            case 3: 
            case 14: {
                return this.columnName;
            }
        }
        return "";
    }

    @Override
    void collectObjectNames(Set set) {
        switch (this.opType) {
            case 12: {
                HsqlNameManager.HsqlName hsqlName = this.sequence.getName();
                set.add(hsqlName);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 99: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                set.add(this.column.getName());
                if (this.column.getName().parent == null) break;
                set.add(this.column.getName().parent);
            }
        }
    }

    @Override
    String getColumnName() {
        switch (this.opType) {
            case 2: 
            case 6: 
            case 7: {
                if (this.column != null) {
                    return this.column.getName().name;
                }
                if (this.columnName == null) break;
                return this.columnName;
            }
        }
        return this.getAlias();
    }

    @Override
    public ColumnSchema getColumn() {
        return this.column;
    }

    String getSchemaName() {
        return this.schema;
    }

    @Override
    RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n2, RangeGroup[] rangeGroupArray, List arrayListIdentity, boolean bl) {
        switch (this.opType) {
            case 12: {
                if (bl) break;
                throw Error.error(5598);
            }
            case 99: {
                throw Error.error(5581, "*");
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 3: 
            case 105: {
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    this.nodes[i2].resolveColumnReferences(session, rangeGroup, rangeGroupArray, arrayListIdentity);
                }
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                boolean bl2 = false;
                RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
                if (this.rangeVariable != null) {
                    return arrayListIdentity;
                }
                if (this.isUpdateColumn) {
                    if (arrayListIdentity == null) {
                        arrayListIdentity = new ArrayListIdentity<ExpressionColumn>();
                    }
                    arrayListIdentity.add(this);
                    return arrayListIdentity;
                }
                for (int i3 = 0; i3 < n2; ++i3) {
                    RangeVariable rangeVariable = rangeVariableArray[i3];
                    if (rangeVariable == null) continue;
                    if (bl2) {
                        if (!session.database.sqlEnforceRefs || !this.resolvesDuplicateColumnReference(rangeVariable)) continue;
                        String string = this.getColumnName();
                        if (this.alias != null) {
                            StringBuilder stringBuilder = new StringBuilder(string);
                            stringBuilder.append(' ').append("AS").append(' ').append(this.alias.getStatementName());
                            string = stringBuilder.toString();
                        }
                        throw Error.error(5580, string);
                    }
                    if (!this.resolveColumnReference(rangeVariable, false)) continue;
                    bl2 = true;
                    if (!session.database.sqlEnforceRefs) break;
                }
                if (bl2) {
                    return arrayListIdentity;
                }
                if ((session.database.sqlSyntaxOra || session.database.sqlSyntaxDb2) && bl && this.tableName != null) {
                    NumberSequence numberSequence;
                    if ("CURRVAL".equals(this.columnName) || "PREVVAL".equals(this.columnName)) {
                        NumberSequence numberSequence2 = session.database.schemaManager.findSequence(session, this.tableName, this.schema);
                        if (numberSequence2 != null) {
                            this.opType = 13;
                            this.dataType = numberSequence2.getDataType();
                            this.sequence = numberSequence2;
                            this.schema = null;
                            this.tableName = null;
                            this.columnName = null;
                            bl2 = true;
                        }
                    } else if ("NEXTVAL".equals(this.columnName) && (numberSequence = session.database.schemaManager.findSequence(session, this.tableName, this.schema)) != null) {
                        this.opType = 12;
                        this.dataType = numberSequence.getDataType();
                        this.sequence = numberSequence;
                        this.schema = null;
                        this.tableName = null;
                        this.columnName = null;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    return arrayListIdentity;
                }
                if (this.resolveCorrelated(rangeGroup, rangeGroupArray)) {
                    return arrayListIdentity;
                }
                if (arrayListIdentity == null) {
                    arrayListIdentity = new ArrayListIdentity();
                }
                arrayListIdentity.add(this);
                break;
            }
        }
        return arrayListIdentity;
    }

    private boolean resolveCorrelated(RangeGroup rangeGroup, RangeGroup[] rangeGroupArray) {
        for (int i2 = rangeGroupArray.length - 1; i2 >= 0; --i2) {
            RangeVariable[] rangeVariableArray = rangeGroupArray[i2].getRangeVariables();
            for (int i3 = 0; i3 < rangeVariableArray.length; ++i3) {
                RangeVariable rangeVariable = rangeVariableArray[i3];
                if (rangeVariable == null || !this.resolveColumnReference(rangeVariable, true)) continue;
                switch (this.opType) {
                    case 2: 
                    case 3: {
                        rangeGroup.setCorrelated();
                        for (int i4 = rangeGroupArray.length - 1; i4 > i2; --i4) {
                            rangeGroupArray[i4].setCorrelated();
                        }
                        break;
                    }
                }
                return true;
            }
        }
        return false;
    }

    boolean resolveColumnReference(RangeVariable rangeVariable, boolean bl) {
        ExpressionColumn expressionColumn;
        if (this.tableName == null && (expressionColumn = rangeVariable.getColumnExpression(this.columnName)) != null) {
            this.opType = expressionColumn.opType;
            this.nodes = expressionColumn.nodes;
            this.dataType = expressionColumn.dataType;
            return true;
        }
        int n2 = rangeVariable.findColumn(this.schema, this.tableName, this.columnName);
        if (n2 == -1) {
            return false;
        }
        switch (rangeVariable.rangeType) {
            case 3: 
            case 4: {
                if (this.tableName != null) {
                    return false;
                }
                ColumnSchema columnSchema = rangeVariable.getColumn(n2);
                if (columnSchema.getParameterMode() == 4) {
                    return false;
                }
                this.opType = rangeVariable.rangeType == 4 ? 6 : 7;
                break;
            }
            case 2: {
                if (this.tableName == null) {
                    return false;
                }
                if (this.schema != null) {
                    return false;
                }
                this.opType = 9;
                break;
            }
        }
        this.setAttributesAsColumn(rangeVariable, n2);
        return true;
    }

    boolean resolvesDuplicateColumnReference(RangeVariable rangeVariable) {
        ExpressionColumn expressionColumn;
        if (this.tableName == null && (expressionColumn = rangeVariable.getColumnExpression(this.columnName)) != null) {
            return false;
        }
        switch (rangeVariable.rangeType) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        int n2 = rangeVariable.findColumn(this.schema, this.tableName, this.columnName);
        return n2 != -1;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        switch (this.opType) {
            case 4: {
                if (expression == null || expression.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                this.nullability = 0;
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    type = Type.getAggregateType(this.nodes[i2].dataType, type);
                }
                this.dataType = type;
                break;
            }
            case 2: {
                if (this.dataType != null) break;
                this.dataType = this.column.getDataType();
            }
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 105: {
                if (session.sessionContext.groupSet == null) {
                    return 0;
                }
                return session.sessionContext.groupSet.isGrouped(session.sessionContext.currentGroup, this);
            }
            case 4: {
                return null;
            }
            case 10: {
                return this.getDiagnosticsVariable(session);
            }
            case 6: {
                return session.sessionContext.routineVariables[this.columnIndex];
            }
            case 7: {
                return session.sessionContext.routineArguments[this.columnIndex];
            }
            case 9: {
                return session.sessionContext.triggerArguments[this.rangeVariable.rangePosition][this.columnIndex];
            }
            case 2: {
                RangeIterator[] rangeIteratorArray = session.sessionContext.rangeIterators;
                Object object = rangeIteratorArray[this.rangeVariable.rangePosition].getField(this.columnIndex);
                if (this.dataType != this.column.dataType) {
                    object = this.dataType.convertToType(session, object, this.column.dataType);
                }
                return object;
            }
            case 5: {
                Object object = session.sessionContext.rangeIterators[this.rangePosition].getField(this.columnIndex);
                return object;
            }
            case 3: {
                Object object = null;
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    object = this.nodes[i2].getValue(session, this.dataType);
                    if (object == null) continue;
                    return object;
                }
                return object;
            }
            case 8: {
                return session.sessionContext.dynamicArguments[this.parameterIndex];
            }
            case 12: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
            case 13: {
                return session.sessionData.getSequenceCurrent(this.sequence);
            }
            case 14: {
                return ValuePool.getInt(session.sessionContext.rownum);
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    private Object getDiagnosticsVariable(Session session) {
        return session.sessionContext.diagnosticsVariables[this.columnIndex];
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 11: {
                return "*";
            }
            case 3: {
                if (this.alias != null) {
                    return this.alias.getStatementName();
                }
                return "COALESCE";
            }
            case 6: 
            case 7: 
            case 10: {
                return this.column.getName().statementName;
            }
            case 14: {
                StringBuilder stringBuilder = new StringBuilder("ROWNUM");
                stringBuilder.append('(').append(')');
                return stringBuilder.toString();
            }
            case 2: {
                if (this.column == null) {
                    if (this.alias != null) {
                        return this.alias.getStatementName();
                    }
                    if (this.tableName == null) {
                        return this.columnName;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.tableName);
                    stringBuilder.append('.');
                    stringBuilder.append(this.columnName);
                    return stringBuilder.toString();
                }
                if (this.rangeVariable.tableAlias == null) {
                    return this.column.getName().getSchemaQualifiedStatementName();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.rangeVariable.tableAlias.getStatementName());
                stringBuilder.append('.');
                stringBuilder.append(this.column.getName().statementName);
                return stringBuilder.toString();
            }
            case 5: {
                if (this.alias != null) {
                    return this.alias.getStatementName();
                }
                return "COLUMN_NAME";
            }
            case 99: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    Expression expression = this.nodes[i2];
                    if (i2 > 0) {
                        stringBuilder.append(',');
                    }
                    String string = expression.getSQL();
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            case 105: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("GROUPING(");
                for (int i3 = 0; i3 < this.nodes.length; ++i3) {
                    Expression expression = this.nodes[i3];
                    if (i3 > 0) {
                        stringBuffer.append(',');
                    }
                    String string = expression.getSQL();
                    stringBuffer.append(string);
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    @Override
    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 4: {
                stringBuilder.append("DEFAULT");
                break;
            }
            case 11: {
                stringBuilder.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                stringBuilder.append("VARIABLE: ");
                stringBuilder.append(this.column.getName().name);
                break;
            }
            case 7: {
                stringBuilder.append("PARAMETER").append(": ");
                stringBuilder.append(this.column.getName().name);
                break;
            }
            case 3: {
                stringBuilder.append("COLUMN").append(": ");
                stringBuilder.append(this.columnName);
                if (this.alias == null) break;
                stringBuilder.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                stringBuilder.append("COLUMN").append(": ");
                stringBuilder.append(this.column.getName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                stringBuilder.append(" AS ").append(this.alias.name);
                break;
            }
            case 8: {
                stringBuilder.append("DYNAMIC PARAM: ");
                stringBuilder.append(", TYPE = ").append(this.dataType.getDefinition());
                break;
            }
            case 12: {
                stringBuilder.append("SEQUENCE").append(": ");
                stringBuilder.append(this.sequence.getName().name);
                break;
            }
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    String getTableName() {
        if (this.opType == 99) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getName().name;
        }
        return "";
    }

    public static void checkColumnsResolved(List list) {
        if (list != null && !list.isEmpty()) {
            Expression expression = (Expression)list.get(0);
            if (expression instanceof ExpressionColumn) {
                StringBuilder stringBuilder = new StringBuilder();
                ExpressionColumn expressionColumn = (ExpressionColumn)expression;
                if (expressionColumn.schema != null) {
                    stringBuilder.append(expressionColumn.schema).append('.');
                }
                if (expressionColumn.tableName != null) {
                    stringBuilder.append(expressionColumn.tableName).append('.');
                }
                stringBuilder.append(expressionColumn.getColumnName());
                throw Error.error(5501, stringBuilder.toString());
            }
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            expression.collectAllExpressions(orderedHashSet, OpTypes.columnExpressionSet, OpTypes.emptyExpressionSet);
            ExpressionColumn.checkColumnsResolved(orderedHashSet);
            throw Error.error(5501);
        }
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            orderedHashSet = this.nodes[i2].getUnkeyedColumns(orderedHashSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet<ExpressionColumn>();
            }
            orderedHashSet.add(this);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            orderedHashSet = this.nodes[i2].collectRangeVariables(orderedHashSet);
        }
        if (this.rangeVariable != null) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this.rangeVariable);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            orderedHashSet = this.nodes[n2].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.rangeVariable != null) {
            for (n2 = 0; n2 < rangeVariableArray.length; ++n2) {
                if (rangeVariableArray[n2] != this.rangeVariable) continue;
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet<RangeVariable>();
                }
                orderedHashSet.add(this.rangeVariable);
                break;
            }
        }
        return orderedHashSet;
    }

    @Override
    Expression replaceAliasInOrderBy(Session session, Expression[] expressionArray, int n2) {
        int n3;
        for (n3 = 0; n3 < this.nodes.length; ++n3) {
            if (this.nodes[n3] == null) continue;
            this.nodes[n3] = this.nodes[n3].replaceAliasInOrderBy(session, expressionArray, n2);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                String string;
                Object object;
                int n4;
                n3 = -1;
                for (n4 = 0; n4 < n2; ++n4) {
                    object = expressionArray[n4].alias;
                    String string2 = string = object == null ? null : ((HsqlNameManager.SimpleName)object).name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(string)) continue;
                    if (n3 < 0) {
                        n3 = n4;
                        continue;
                    }
                    if (!session.database.sqlEnforceRefs) continue;
                    String string3 = this.getColumnName();
                    throw Error.error(5580, string3);
                }
                if (n3 >= 0) {
                    return expressionArray[n3];
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    object = expressionArray[n4];
                    if (!(object instanceof ExpressionColumn)) continue;
                    if (this.equals((Expression)object)) {
                        if (n3 < 0) {
                            n3 = n4;
                        } else if (session.database.sqlEnforceRefs) {
                            string = this.getColumnName();
                            throw Error.error(5580, string);
                        }
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)object).columnName)) continue;
                    if (n3 < 0) {
                        n3 = n4;
                        continue;
                    }
                    if (!session.database.sqlEnforceRefs) continue;
                    string = this.getColumnName();
                    throw Error.error(5580, string);
                }
                if (n3 < 0) break;
                return expressionArray[n3];
            }
        }
        return this;
    }

    @Override
    Expression replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        if (this.opType == 2 && this.rangeVariable == rangeVariable) {
            Expression expression = expressionArray[this.columnIndex];
            if (this.dataType == null || this.dataType.equals(expression.dataType)) {
                return expression;
            }
            expression = expression.duplicate();
            expression.setDataType(session, this.dataType);
            return expression;
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2] = this.nodes[i2].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        return this;
    }

    @Override
    boolean hasReference(RangeVariable rangeVariable) {
        if (rangeVariable == this.rangeVariable) {
            return true;
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null || !this.nodes[i2].hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == expression.columnIndex && this.rangeVariable == ((ExpressionColumn)expression).rangeVariable;
            }
            case 3: {
                return this.nodes == expression.nodes;
            }
            case 8: {
                return this.parameterIndex == expression.parameterIndex;
            }
            case 2: 
            case 6: 
            case 7: {
                return this.column == expression.getColumn() && this.rangeVariable == expression.getRangeVariable();
            }
        }
        return false;
    }

    @Override
    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            this.nodes[n2].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        for (n2 = 0; n2 < rangeVariableArray.length; ++n2) {
            if (this.rangeVariable != rangeVariableArray[n2]) continue;
            this.rangeVariable = rangeVariableArray2[n2];
            break;
        }
    }

    @Override
    void resetColumnReferences() {
        this.rangeVariable = null;
        this.columnIndex = -1;
    }

    @Override
    public boolean isIndexable(RangeVariable rangeVariable) {
        if (this.opType == 2) {
            return this.rangeVariable == rangeVariable;
        }
        return false;
    }

    @Override
    public boolean isUnresolvedParam() {
        return this.isParam && this.dataType == null;
    }

    @Override
    boolean isDynamicParam() {
        return this.isParam;
    }

    @Override
    void getJoinRangeVariables(RangeVariable[] rangeVariableArray, List list) {
        if (this.opType == 2) {
            for (int i2 = 0; i2 < rangeVariableArray.length; ++i2) {
                if (rangeVariableArray[i2] != this.rangeVariable) continue;
                list.add(this.rangeVariable);
                return;
            }
        }
    }

    @Override
    double costFactor(Session session, RangeVariable rangeVariable, int n2) {
        double d2;
        if (rangeVariable.rangeTable instanceof TableDerived) {
            return 1024.0;
        }
        PersistentStore persistentStore = rangeVariable.rangeTable.getRowStore(session);
        int n3 = rangeVariable.rangeTable.indexTypeForColumn(session, this.columnIndex);
        switch (n3) {
            case 2: {
                if (n2 == 40) {
                    d2 = 1.0;
                    break;
                }
                d2 = (double)persistentStore.elementCount() / 2.0;
                break;
            }
            case 1: {
                if (n2 == 40) {
                    d2 = (double)persistentStore.elementCount() / 8.0;
                    if (!(d2 > 1024.0)) break;
                    d2 = 1024.0;
                    break;
                }
                d2 = (double)persistentStore.elementCount() / 2.0;
                break;
            }
            default: {
                d2 = persistentStore.elementCount();
            }
        }
        return d2 < 16.0 ? 16.0 : d2;
    }

    @Override
    public Expression duplicate() {
        if (this.opType == 7) {
            return this;
        }
        return super.duplicate();
    }

    static {
        for (int i2 = 0; i2 < diagnosticsVariableTokens.length; ++i2) {
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newSystemObjectName(diagnosticsVariableTokens[i2], 22);
            Type type = Type.SQL_INTEGER;
            if ("MORE".equals(diagnosticsVariableTokens[i2])) {
                type = Type.SQL_CHAR;
            }
            ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, false, false, null);
            diagnosticsList.add(diagnosticsVariableTokens[i2], columnSchema);
        }
    }
}

