/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueAggregate;
import org.hsqldb.SetFunctionValueArray;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionArrayAggregate
extends Expression {
    SortAndSlice sort;
    SortAndSlice distinctSort;
    String separator = ",";
    ArrayType arrayDataType;
    Type exprDataType;
    int exprOpType;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionArrayAggregate(int n2, boolean bl, Expression expression, SortAndSlice sortAndSlice, String string) {
        super(n2);
        this.isDistinctAggregate = bl;
        this.sort = sortAndSlice;
        this.exprOpType = expression.opType;
        if (string != null) {
            this.separator = string;
        }
        if (sortAndSlice == null) {
            this.nodes = new Expression[]{expression};
        } else {
            HsqlArrayList hsqlArrayList = sortAndSlice.getExpressionList();
            this.nodes = new Expression[hsqlArrayList.size() + 1];
            hsqlArrayList.toArray(this.nodes);
            this.nodes[hsqlArrayList.size()] = expression;
            sortAndSlice.prepareExtraColumn(1);
        }
        if (this.isDistinctAggregate) {
            this.distinctSort = new SortAndSlice();
            this.distinctSort.prepareSingleColumn(this.nodes.length - 1);
        }
    }

    @Override
    public boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionArrayAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 85: {
                stringBuilder.append(' ').append("ARRAY_AGG").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 86: {
                stringBuilder.append(' ').append("GROUP_CONCAT").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 89: {
                stringBuilder.append(' ').append("MEDIAN").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 85: {
                stringBuilder.append("ARRAY_AGG").append(' ');
                break;
            }
            case 86: {
                stringBuilder.append("GROUP_CONCAT").append(' ');
                break;
            }
            case 89: {
                stringBuilder.append("MEDIAN").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg=[");
            stringBuilder.append(this.nodes[0].describe(session, n2 + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n2, RangeGroup[] rangeGroupArray, List arrayListIdentity, boolean bl) {
        List list = this.condition.resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, null, false);
        if (list != null) {
            ExpressionColumn.checkColumnsResolved(list);
        }
        if (arrayListIdentity == null) {
            arrayListIdentity = new ArrayListIdentity<ExpressionArrayAggregate>();
        }
        arrayListIdentity.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroupArray;
            this.rangeGroup = rangeGroup;
        }
        return arrayListIdentity;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        this.nodeDataTypes = new Type[this.nodes.length];
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].resolveTypes(session, this);
            if (this.nodes[i2].isUnresolvedParam()) {
                throw Error.error(5567);
            }
            if (this.nodes[i2].dataType == null) {
                throw Error.error(5567);
            }
            this.nodeDataTypes[i2] = this.nodes[i2].dataType;
        }
        this.exprDataType = this.nodes[this.nodes.length - 1].dataType;
        if (this.exprDataType.isLobType()) {
            throw Error.error(5534);
        }
        if (this.exprDataType.isArrayType()) {
            throw Error.error(5534);
        }
        RowType rowType = new RowType(this.nodeDataTypes);
        switch (this.opType) {
            case 85: {
                this.arrayDataType = new ArrayType(rowType, Integer.MAX_VALUE);
                this.dataType = new ArrayType(this.exprDataType, 0x100000);
                break;
            }
            case 86: {
                this.arrayDataType = new ArrayType(rowType, Integer.MAX_VALUE);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 89: {
                this.arrayDataType = new ArrayType(this.nodeDataTypes[0], Integer.MAX_VALUE);
                this.dataType = ExpressionAggregate.getType(session, 89, this.exprDataType);
            }
        }
        this.condition.resolveTypes(session, null);
    }

    @Override
    boolean equals(Expression expression) {
        if (expression instanceof ExpressionArrayAggregate) {
            ExpressionArrayAggregate expressionArrayAggregate = (ExpressionArrayAggregate)expression;
            return super.equals(expression) && this.opType == expression.opType && this.exprSubType == expression.exprSubType && this.isDistinctAggregate == expressionArrayAggregate.isDistinctAggregate && this.separator.equals(expressionArrayAggregate.separator) && this.condition.equals(expressionArrayAggregate.condition);
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        if (!this.condition.testCondition(session)) {
            return setFunction;
        }
        Object[] objectArray = null;
        switch (this.opType) {
            case 85: {
                Object[] objectArray2 = new Object[this.nodes.length];
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    objectArray2[i2] = this.nodes[i2].getValue(session);
                }
                objectArray = objectArray2;
                break;
            }
            case 86: {
                Object[] objectArray3 = new Object[this.nodes.length];
                for (int i3 = 0; i3 < this.nodes.length; ++i3) {
                    objectArray3[i3] = this.nodes[i3].getValue(session);
                }
                if (objectArray3[objectArray3.length - 1] == null) {
                    return setFunction;
                }
                objectArray = objectArray3;
                break;
            }
            case 89: {
                objectArray = this.nodes[0].getValue(session);
                if (objectArray != null) break;
                return setFunction;
            }
        }
        if (setFunction == null) {
            setFunction = new SetFunctionValueArray();
        }
        setFunction.add(objectArray);
        return setFunction;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction, SetFunction setFunction2) {
        if (setFunction == null) {
            setFunction = new SetFunctionValueArray();
        }
        setFunction.addGroup(setFunction2);
        return setFunction;
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        if (setFunction == null) {
            return null;
        }
        Object[] objectArray = (Object[])setFunction.getValue();
        if (this.isDistinctAggregate) {
            this.arrayDataType.sort(session, objectArray, this.distinctSort);
            int n2 = this.arrayDataType.deDuplicate(session, objectArray, this.distinctSort);
            objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, n2);
        }
        if (this.sort != null) {
            this.arrayDataType.sort(session, objectArray, this.sort);
        }
        switch (this.opType) {
            case 85: {
                Object[] objectArray2 = new Object[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Object[] objectArray3 = (Object[])objectArray[i2];
                    objectArray2[i2] = objectArray3[objectArray3.length - 1];
                }
                return objectArray2;
            }
            case 86: {
                StringBuilder stringBuilder = new StringBuilder(16 * objectArray.length);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    if (i3 > 0) {
                        stringBuilder.append(this.separator);
                    }
                    Object[] objectArray4 = (Object[])objectArray[i3];
                    Object object = objectArray4[objectArray4.length - 1];
                    String string = (String)Type.SQL_VARCHAR.convertToType(session, object, this.exprDataType);
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            case 89: {
                Object object;
                boolean bl;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                this.arrayDataType.sort(session, objectArray, sortAndSlice);
                boolean bl2 = bl = objectArray.length % 2 == 0;
                if (bl) {
                    SetFunctionValueAggregate setFunctionValueAggregate = new SetFunctionValueAggregate(session, 78, this.nodes[0].dataType, this.dataType, false);
                    setFunctionValueAggregate.add(objectArray[objectArray.length / 2 - 1]);
                    setFunctionValueAggregate.add(objectArray[objectArray.length / 2]);
                    object = setFunctionValueAggregate.getValue();
                } else {
                    object = objectArray[objectArray.length / 2];
                }
                if (this.dataType.isDateTimeTypeWithZone()) {
                    object = ((DateTimeType)this.dataType).changeZoneToUTC(object);
                }
                return this.dataType.convertToType(session, object, this.exprDataType);
            }
        }
        return null;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return !this.condition.isTrue();
    }

    @Override
    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    @Override
    public Expression duplicate() {
        ExpressionArrayAggregate expressionArrayAggregate = (ExpressionArrayAggregate)super.duplicate();
        expressionArrayAggregate.condition = this.condition.duplicate();
        return expressionArrayAggregate;
    }
}

