/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionBoolean;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.OpTypes;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.NullType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Expression
implements Cloneable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int THIRD = 2;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int TERNARY = 3;
    static final Expression[] emptyArray = new Expression[0];
    public static final Expression EXPR_TRUE = new ExpressionBoolean(true);
    public static final Expression EXPR_FALSE = new ExpressionBoolean(false);
    protected int opType;
    protected int exprSubType;
    HsqlNameManager.SimpleName alias;
    private boolean hasAggregate;
    boolean isDistinctAggregate;
    protected Object valueData;
    protected Expression[] nodes;
    Type[] nodeDataTypes;
    TableDerived table;
    boolean isCorrelated;
    boolean noOptimisation;
    int columnIndex = -1;
    protected Type dataType;
    protected int groupingType;
    int resultTableColumnIndex = -1;
    int parameterIndex = -1;
    boolean isColumnCondition;
    boolean isColumnEqual;
    boolean isSingleColumnCondition;
    boolean isSingleColumnEqual;
    boolean isSingleColumnNull;
    boolean isSingleColumnNotNull;
    byte nullability = (byte)2;
    Collation collation;
    RangeGroup[] rangeGroups;
    RangeGroup rangeGroup;

    Expression(int n2) {
        this.opType = n2;
        this.nodes = emptyArray;
    }

    Expression(int n2, TableDerived tableDerived) {
        switch (n2) {
            case 19: {
                this.opType = 19;
                break;
            }
            case 102: {
                this.opType = 102;
                break;
            }
            case 23: {
                this.opType = 23;
                break;
            }
            case 21: 
            case 22: {
                this.opType = 22;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        this.nodes = emptyArray;
        this.table = tableDerived;
    }

    Expression(int n2, Expression[] expressionArray) {
        this(n2);
        this.nodes = expressionArray;
    }

    static String getContextSQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        String string = expression.getSQL();
        switch (expression.opType) {
            case 1: 
            case 2: 
            case 25: 
            case 27: 
            case 28: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                return string;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        string = stringBuilder.append('(').append(string).append(')').toString();
        return string;
    }

    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 25: {
                stringBuilder.append('(');
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    if (i2 > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.nodes[i2].getSQL());
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 26: {
                for (int i3 = 0; i3 < this.nodes.length; ++i3) {
                    if (i3 > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.nodes[i3].getSQL());
                }
                return stringBuilder.toString();
            }
        }
        switch (this.opType) {
            case 19: {
                stringBuilder.append("ARRAY").append('[');
                for (int i4 = 0; i4 < this.nodes.length; ++i4) {
                    if (i4 > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.nodes[i4].getSQL());
                }
                stringBuilder.append(']');
                break;
            }
            case 22: 
            case 23: 
            case 102: {
                stringBuilder.append('(');
                stringBuilder.append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return stringBuilder.toString();
    }

    protected String describe(Session session, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuilder.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuilder.toString();
            }
            case 19: {
                stringBuilder.append("ARRAY ");
                return stringBuilder.toString();
            }
            case 102: {
                stringBuilder.append("ARRAY SUBQUERY");
                return stringBuilder.toString();
            }
            case 22: 
            case 23: {
                stringBuilder.append("QUERY ");
                stringBuilder.append(this.table.queryExpression.describe(session, n2));
                return stringBuilder.toString();
            }
            case 25: {
                stringBuilder.append("ROW = ");
                for (n3 = 0; n3 < this.nodes.length; ++n3) {
                    stringBuilder.append(this.nodes[n3].describe(session, n2 + 1));
                    stringBuilder.append(' ');
                }
                break;
            }
            case 26: {
                stringBuilder.append("VALUELIST ");
                for (n3 = 0; n3 < this.nodes.length; ++n3) {
                    stringBuilder.append(this.nodes[n3].describe(session, n2 + 1));
                    stringBuilder.append(' ');
                }
                break;
            }
        }
        return stringBuilder.toString();
    }

    public void setDataType(Session session, Type type) {
        if (this.opType == 1) {
            this.valueData = type.convertToType(session, this.valueData, this.dataType);
        }
        this.dataType = type;
    }

    boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType || this.exprSubType != expression.exprSubType || !Expression.equals(this.dataType, expression.dataType)) {
            return false;
        }
        switch (this.opType) {
            case 1: {
                return Expression.equals(this.valueData, expression.valueData);
            }
            case 22: 
            case 23: 
            case 102: {
                return this.table.queryExpression.isEquivalent(expression.table.queryExpression);
            }
        }
        return Expression.equals(this.nodes, expression.nodes);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Expression) {
            return this.equals((Expression)object);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.opType + this.exprSubType;
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            n2 += this.nodes[i2].hashCode();
        }
        return n2;
    }

    static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return object == null ? false : object.equals(object2);
    }

    static boolean equals(Expression[] expressionArray, Expression[] expressionArray2) {
        if (expressionArray == expressionArray2) {
            return true;
        }
        if (expressionArray.length != expressionArray2.length) {
            return false;
        }
        int n2 = expressionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            Expression expression = expressionArray[i2];
            Expression expression2 = expressionArray2[i2];
            boolean bl2 = expression == null ? expression2 == null : (bl = expression.equals(expression2));
            if (bl) continue;
            return false;
        }
        return true;
    }

    boolean isComposedOf(Expression[] expressionArray, int n2, int n3, OrderedIntHashSet orderedIntHashSet) {
        int n4;
        switch (this.opType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (orderedIntHashSet.contains(this.opType)) {
            return true;
        }
        for (n4 = n2; n4 < n3; n4 += 1) {
            if (!this.equals(expressionArray[n4])) continue;
            return true;
        }
        switch (this.opType) {
            case 2: {
                return false;
            }
            case 19: 
            case 23: 
            case 53: 
            case 55: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 102: {
                return false;
            }
            case 22: {
                if (this.table == null) break;
                if (!(this.table.getQueryExpression() instanceof QuerySpecification)) {
                    return false;
                }
                QuerySpecification querySpecification = (QuerySpecification)this.table.getQueryExpression();
                OrderedHashSet<Expression> orderedHashSet = new OrderedHashSet<Expression>();
                for (int i2 = n2; i2 < n3; ++i2) {
                    if (expressionArray[i2].opType != 2) continue;
                    orderedHashSet.add(expressionArray[i2]);
                }
                return querySpecification.collectOuterColumnExpressions(null, orderedHashSet) == null;
            }
        }
        if (this.isSelfAggregate()) {
            return false;
        }
        if (this.nodes.length == 0) {
            return true;
        }
        n4 = 1;
        for (int i3 = 0; i3 < this.nodes.length; ++i3) {
            n4 &= this.nodes[i3] == null || this.nodes[i3].isComposedOf(expressionArray, n2, n3, orderedIntHashSet);
        }
        return n4 != 0;
    }

    boolean isComposedOf(OrderedHashSet orderedHashSet, RangeGroup[] rangeGroupArray, OrderedIntHashSet orderedIntHashSet) {
        int n2;
        switch (this.opType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (orderedIntHashSet.contains(this.opType)) {
            return true;
        }
        for (n2 = 0; n2 < orderedHashSet.size(); n2 += 1) {
            if (!this.equals(orderedHashSet.get(n2))) continue;
            return true;
        }
        if (this.opType == 2) {
            for (n2 = 0; n2 < rangeGroupArray.length; n2 += 1) {
                RangeVariable[] rangeVariableArray = rangeGroupArray[n2].getRangeVariables();
                for (int i2 = 0; i2 < rangeVariableArray.length; ++i2) {
                    if (rangeVariableArray[i2] != this.getRangeVariable()) continue;
                    return true;
                }
            }
        }
        switch (this.opType) {
            case 27: 
            case 28: {
                if (this.nodes.length != 0) break;
                return true;
            }
        }
        if (this.isSelfAggregate()) {
            return false;
        }
        if (this.nodes.length == 0) {
            return false;
        }
        n2 = 1;
        for (int i3 = 0; i3 < this.nodes.length; ++i3) {
            n2 &= this.nodes[i3] == null || this.nodes[i3].isComposedOf(orderedHashSet, rangeGroupArray, orderedIntHashSet);
        }
        return n2 != 0;
    }

    Expression replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2] = this.nodes[i2].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        return this;
    }

    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
    }

    void resetColumnReferences() {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].resetColumnReferences();
        }
    }

    Expression replaceExpressions(OrderedHashSet orderedHashSet, int n2) {
        if (this.opType == 1) {
            return this;
        }
        if (this.opType == 5) {
            return this;
        }
        Expression expression = orderedHashSet.get(this);
        if (expression != null) {
            ExpressionColumn expressionColumn = new ExpressionColumn(this, expression.resultTableColumnIndex, n2);
            return expressionColumn;
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2] = this.nodes[i2].replaceExpressions(orderedHashSet, n2);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceExpressions(orderedHashSet, n2);
        }
        return this;
    }

    boolean hasAggregate() {
        return this.hasAggregate;
    }

    boolean isDistinctAggregate() {
        return this.isDistinctAggregate;
    }

    public void setAggregate() {
        this.hasAggregate = true;
    }

    public boolean isSelfAggregate() {
        return false;
    }

    void setAlias(HsqlNameManager.SimpleName simpleName) {
        this.alias = simpleName;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        return "";
    }

    HsqlNameManager.SimpleName getSimpleName() {
        return this.alias;
    }

    public int getType() {
        return this.opType;
    }

    public Expression getLeftNode() {
        return this.nodes.length > 0 ? this.nodes[0] : null;
    }

    public Expression getRightNode() {
        return this.nodes.length > 1 ? this.nodes[1] : null;
    }

    void setLeftNode(Expression expression) {
        this.nodes[0] = expression;
    }

    public void setRightNode(Expression expression) {
        this.nodes[1] = expression;
    }

    int getSubType() {
        return this.exprSubType;
    }

    void setSubType(int n2) {
        this.exprSubType = n2;
    }

    RangeVariable getRangeVariable() {
        return null;
    }

    Expression replaceAliasInOrderBy(Session session, Expression[] expressionArray, int n2) {
        if (this.isSelfAggregate()) {
            return this;
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2] = this.nodes[i2].replaceAliasInOrderBy(session, expressionArray, n2);
        }
        return this;
    }

    OrderedHashSet collectRangeVariables(OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            orderedHashSet = this.nodes[i2].collectRangeVariables(orderedHashSet);
        }
        if (this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectRangeVariables(orderedHashSet);
        }
        return orderedHashSet;
    }

    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            orderedHashSet = this.nodes[i2].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    void collectObjectNames(Set set) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].collectObjectNames(set);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.collectObjectNames(set);
        }
    }

    boolean hasReference(RangeVariable rangeVariable) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null || !this.nodes[i2].hasReference(rangeVariable)) continue;
            return true;
        }
        return this.table != null && this.table.queryExpression != null && this.table.queryExpression.hasReference(rangeVariable);
    }

    boolean hasReference(RangeVariable[] rangeVariableArray, int n2) {
        OrderedHashSet orderedHashSet = this.collectRangeVariables(rangeVariableArray, null);
        if (orderedHashSet == null) {
            return false;
        }
        for (int i2 = 0; i2 < orderedHashSet.size(); ++i2) {
            if (orderedHashSet.get(i2) == rangeVariableArray[n2]) continue;
            return true;
        }
        return false;
    }

    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroupArray, List list) {
        return this.resolveColumnReferences(session, rangeGroup, rangeGroup.getRangeVariables().length, rangeGroupArray, list, true);
    }

    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n2, RangeGroup[] rangeGroupArray, List list, boolean bl) {
        if (this.opType == 1) {
            return list;
        }
        switch (this.opType) {
            case 26: 
            case 30: {
                if (this.table != null) {
                    if (rangeGroup.getRangeVariables().length > n2) {
                        RangeVariable[] rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(rangeGroup.getRangeVariables(), n2);
                        rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, rangeGroup);
                    }
                    rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
                    rangeGroup = new RangeGroup.RangeGroupSimple(this.table);
                    n2 = 0;
                }
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    if (this.nodes[i2] == null) continue;
                    list = this.nodes[i2].resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, list, bl);
                }
                return list;
            }
        }
        for (int i3 = 0; i3 < this.nodes.length; ++i3) {
            if (this.nodes[i3] == null) continue;
            list = this.nodes[i3].resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, list, bl);
        }
        switch (this.opType) {
            case 19: {
                break;
            }
            case 22: 
            case 23: 
            case 102: {
                Expression expression;
                RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
                if (rangeVariableArray.length > n2) {
                    rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(rangeVariableArray, n2);
                    rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, rangeGroup);
                }
                rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveReferences(session, rangeGroupArray);
                    if (!queryExpression.areColumnsResolved()) {
                        if (list == null) {
                            list = new ArrayListIdentity();
                        }
                        list.addAll(queryExpression.getUnresolvedExpressions());
                    }
                }
                if ((expression = this.table.dataExpression) == null) break;
                list = expression.resolveColumnReferences(session, rangeGroup, n2, rangeGroupArray, list, bl);
                break;
            }
        }
        return list;
    }

    public void setCorrelatedReferences(RangeGroup rangeGroup) {
        if (this.rangeGroups == null) {
            for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                if (this.nodes[i2] == null) continue;
                this.nodes[i2].setCorrelatedReferences(rangeGroup);
            }
        } else if (ArrayUtil.find(this.rangeGroups, rangeGroup) > -1) {
            for (int i3 = this.rangeGroups.length - 1; i3 >= 0 && this.rangeGroups[i3] != rangeGroup; --i3) {
                this.rangeGroups[i3].setCorrelated();
            }
            this.rangeGroup.setCorrelated();
        }
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        if (this.opType == 1) {
            return orderedHashSet;
        }
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            orderedHashSet = this.nodes[i2].getUnkeyedColumns(orderedHashSet);
        }
        switch (this.opType) {
            case 19: 
            case 22: 
            case 23: 
            case 102: {
                if (this.table == null) break;
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet<Expression>();
                }
                orderedHashSet.add(this);
                break;
            }
        }
        return orderedHashSet;
    }

    public void resolveTypes(Session session, Expression expression) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            this.nodes[n2].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 26: {
                break;
            }
            case 25: {
                this.nodeDataTypes = new Type[this.nodes.length];
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    if (this.nodes[n2] == null) continue;
                    this.nodeDataTypes[n2] = this.nodes[n2].dataType;
                }
                this.dataType = new RowType(this.nodeDataTypes);
                break;
            }
            case 19: {
                int n3;
                Type type = null;
                for (n3 = 0; n3 < this.nodes.length; ++n3) {
                    type = Type.getAggregateType(type, this.nodes[n3].dataType);
                }
                if (type != null) {
                    for (n3 = 0; n3 < this.nodes.length; ++n3) {
                        this.nodes[n3].valueData = this.nodes[n3].dataType == null ? type.convertToDefaultType(session, this.nodes[n3].valueData) : type.convertToType(session, this.nodes[n3].valueData, this.nodes[n3].dataType);
                    }
                }
                for (n3 = 0; n3 < this.nodes.length; ++n3) {
                    this.nodes[n3].dataType = type;
                }
                this.dataType = new ArrayType(type, 0x100000);
                return;
            }
            case 102: {
                QueryExpression queryExpression = this.table.queryExpression;
                queryExpression.resolveTypes(session);
                this.table.prepareTable(session);
                this.nodeDataTypes = queryExpression.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                if (this.nodeDataTypes.length > 1) {
                    throw Error.error(5564);
                }
                this.dataType = new ArrayType(this.dataType, Integer.MAX_VALUE);
                break;
            }
            case 22: 
            case 23: {
                Expression expression2;
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveTypes(session);
                }
                if ((expression2 = this.table.dataExpression) != null) {
                    expression2.resolveTypes(session, null);
                }
                this.table.prepareTable(session);
                this.nodeDataTypes = this.table.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    void setAsConstantValue(Session session, Expression expression) {
        this.valueData = this.getValue(session);
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void setAsConstantValue(Object object, Expression expression) {
        this.valueData = object;
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void prepareTable(Session session, Expression expression, int n2) {
        Cloneable cloneable;
        int n3;
        if (this.nodeDataTypes != null) {
            return;
        }
        for (n3 = 0; n3 < this.nodes.length; ++n3) {
            cloneable = this.nodes[n3];
            if (((Expression)cloneable).opType == 25) {
                if (n2 == ((Expression)cloneable).nodes.length) continue;
                throw Error.error(5564);
            }
            if (n2 == 1) {
                this.nodes[n3] = new Expression(25);
                this.nodes[n3].nodes = new Expression[]{cloneable};
                continue;
            }
            throw Error.error(5564);
        }
        this.nodeDataTypes = new Type[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            int n4;
            cloneable = expression == null ? null : expression.nodes[n3].dataType;
            boolean bl = expression == null ? false : expression.nodes[n3].isUnresolvedParam();
            for (n4 = 0; n4 < this.nodes.length; ++n4) {
                cloneable = Type.getAggregateType(this.nodes[n4].nodes[n3].dataType, (Type)cloneable);
                bl |= this.nodes[n4].nodes[n3].isUnresolvedParam();
            }
            if (cloneable == null) {
                cloneable = Type.SQL_VARCHAR_DEFAULT;
            }
            n4 = ((Type)cloneable).typeCode;
            if (bl && ((Type)cloneable).isCharacterType() && (n4 == 1 || ((Type)cloneable).precision < Type.SQL_VARCHAR_DEFAULT.precision)) {
                if (n4 == 1) {
                    n4 = 12;
                }
                long l2 = Math.max(Type.SQL_VARCHAR_DEFAULT.precision, ((Type)cloneable).precision);
                cloneable = CharacterType.getCharacterType(n4, l2, ((Type)cloneable).getCollation());
            }
            this.nodeDataTypes[n3] = cloneable;
            if (expression != null && expression.nodes[n3].isUnresolvedParam()) {
                expression.nodes[n3].dataType = cloneable;
            }
            for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                Expression expression2 = this.nodes[i2];
                if (expression2.nodes[n3].isUnresolvedParam()) {
                    expression2.nodeDataTypes[n3] = expression2.nodes[n3].dataType = this.nodeDataTypes[n3];
                    continue;
                }
                if (expression2.nodes[n3].opType != 1 || expression2.nodes[n3].valueData != null) continue;
                expression2.nodeDataTypes[n3] = expression2.nodes[n3].dataType = this.nodeDataTypes[n3];
            }
        }
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            Object[] objectArray = this.nodes[i2].getRowValue(session);
            Object[] objectArray2 = persistentStore.getTable().getEmptyRowData();
            for (int i3 = 0; i3 < this.nodeDataTypes.length; ++i3) {
                objectArray2[i3] = this.nodeDataTypes[i3].convertToType(session, objectArray[i3], this.nodes[i2].nodes[i3].dataType);
            }
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray2, false);
            try {
                persistentStore.indexRow(session, row);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    String getColumnName() {
        return this.getAlias();
    }

    public ColumnSchema getColumn() {
        return null;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Type getDataType() {
        return this.dataType;
    }

    byte getNullability() {
        return this.nullability;
    }

    Type getNodeDataType(int n2) {
        if (this.nodeDataTypes == null) {
            if (n2 > 0) {
                throw Error.runtimeError(201, "Expression");
            }
            return this.dataType;
        }
        return this.nodeDataTypes[n2];
    }

    Type[] getNodeDataTypes() {
        if (this.nodeDataTypes == null) {
            return new Type[]{this.dataType};
        }
        return this.nodeDataTypes;
    }

    int getDegree() {
        switch (this.opType) {
            case 25: {
                return this.nodes.length;
            }
            case 22: 
            case 23: 
            case 30: {
                if (this.table == null) {
                    return this.nodeDataTypes.length;
                }
                return this.table.queryExpression.getColumnCount();
            }
        }
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void materialise(Session session) {
        if (this.table == null) {
            return;
        }
        if (this.table.isCorrelated()) {
            this.table.materialiseCorrelated(session);
        } else {
            this.table.materialise(session);
        }
    }

    public Object getValue(Session session, Type type) {
        Object object = this.getValue(session);
        if (object == null || this.dataType == type) {
            return object;
        }
        return type.convertToType(session, object, this.dataType);
    }

    public Object getConstantValueNoCheck(Session session) {
        try {
            return this.getValue(session);
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 25: {
                Object[] objectArray = new Object[this.nodes.length];
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    objectArray[i2] = this.nodes[i2].getValue(session);
                }
                return objectArray;
            }
            case 22: 
            case 23: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 25: {
                if (this.nodes.length == 1) {
                    return this.nodes[0].getValue(session);
                }
                Object[] objectArray = new Object[this.nodes.length];
                for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                    objectArray[i2] = this.nodes[i2].getValue(session);
                }
                return objectArray;
            }
            case 19: {
                Object[] objectArray = new Object[this.nodes.length];
                for (int i3 = 0; i3 < this.nodes.length; ++i3) {
                    objectArray[i3] = this.nodes[i3].getValue(session);
                }
                return objectArray;
            }
            case 102: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                int n2 = rowSetNavigatorData.getSize();
                Object[] objectArray = new Object[n2];
                rowSetNavigatorData.beforeFirst();
                int n3 = 0;
                while (rowSetNavigatorData.next()) {
                    Object[] objectArray2 = rowSetNavigatorData.getCurrent();
                    objectArray[n3] = objectArray2[0];
                    ++n3;
                }
                return objectArray;
            }
            case 22: 
            case 23: {
                this.table.materialiseCorrelated(session);
                Object[] objectArray = this.table.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Result getResult(Session session) {
        switch (this.opType) {
            case 19: {
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Object[] objectArray = new Object[rowSetNavigatorData.getSize()];
                rowSetNavigatorData.beforeFirst();
                int n2 = 0;
                while (rowSetNavigatorData.next()) {
                    Object[] objectArray2 = rowSetNavigatorData.getCurrent();
                    objectArray[n2] = objectArray2[0];
                    ++n2;
                }
                return Result.newPSMResult(objectArray);
            }
            case 23: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.table.queryExpression == null ? ResultMetaData.newResultMetaData(this.table.getColumnTypes(), this.table.getColumnLabels()) : this.table.queryExpression.getMetaData();
                return result;
            }
        }
        Object object = this.getValue(session);
        return Result.newPSMResult(object);
    }

    public boolean testCondition(Session session) {
        return Boolean.TRUE.equals(this.getValue(session));
    }

    static int countNulls(Object[] objectArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isTrue() {
        return this.opType == 1 && this.valueData instanceof Boolean && (Boolean)this.valueData != false;
    }

    public boolean isFalse() {
        return this.opType == 1 && this.valueData instanceof Boolean && (Boolean)this.valueData == false;
    }

    public boolean isIndexable(RangeVariable rangeVariable) {
        return false;
    }

    static void convertToType(Session session, Object[] objectArray, Type[] typeArray, Type[] typeArray2) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (typeArray[i2].canConvertFrom(typeArray2[i2])) continue;
            objectArray[i2] = typeArray2[i2].convertToType(session, objectArray[i2], typeArray[i2]);
        }
    }

    static QuerySpecification getCheckSelect(Session session, Table table, Expression expression) {
        ParserDQL.CompileContext compileContext = new ParserDQL.CompileContext(session);
        compileContext.setNextRangeVarIndex(0);
        QuerySpecification querySpecification = new QuerySpecification(compileContext);
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        RangeVariable[] rangeVariableArray = new RangeVariable[]{rangeVariable};
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(rangeVariableArray, false);
        expression.resolveCheckOrGenExpression(session, rangeGroupSimple, true);
        if (Type.SQL_BOOLEAN != expression.getDataType()) {
            throw Error.error(5568);
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(48, expression);
        querySpecification.addSelectColumnExpression(EXPR_TRUE);
        querySpecification.addRangeVariable(session, rangeVariable);
        querySpecification.addQueryCondition(expressionLogical);
        querySpecification.resolve(session);
        return querySpecification;
    }

    public void resolveCheckOrGenExpression(Session session, RangeGroup rangeGroup, boolean bl) {
        int n2;
        Object object;
        boolean bl2 = false;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        List list = this.resolveColumnReferences(session, rangeGroup, RangeGroup.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(list);
        this.resolveTypes(session, null);
        this.collectAllExpressions(orderedHashSet, OpTypes.subqueryAggregateExpressionSet, OpTypes.emptyExpressionSet);
        if (!orderedHashSet.isEmpty()) {
            throw Error.error(5512);
        }
        this.collectAllExpressions(orderedHashSet, OpTypes.functionExpressionSet, OpTypes.emptyExpressionSet);
        for (int i2 = 0; i2 < orderedHashSet.size(); ++i2) {
            Expression expression = (Expression)orderedHashSet.get(i2);
            if (expression.opType == 27 && !((FunctionSQLInvoked)expression).isDeterministic()) {
                throw Error.error(5512);
            }
            if (expression.opType != 28 || ((FunctionSQL)expression).isDeterministic()) continue;
            if (bl) {
                bl2 = true;
                continue;
            }
            throw Error.error(5512);
        }
        if (bl && bl2) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            RangeVariableResolver.decomposeAndConditions(session, this, hsqlArrayList);
            block9: for (int i3 = 0; i3 < hsqlArrayList.size(); ++i3) {
                bl2 = true;
                object = (Expression)hsqlArrayList.get(i3);
                if (!(object instanceof ExpressionLogical) || (n2 = ((ExpressionLogical)object).convertToSmaller()) == 0) break;
                Expression expression = ((Expression)object).getRightNode();
                object = ((Expression)object).getLeftNode();
                if (!((Expression)object).dataType.isDateTimeType()) {
                    bl2 = true;
                    break;
                }
                if (((Expression)object).hasNonDeterministicFunction()) {
                    bl2 = true;
                    break;
                }
                if (expression instanceof ExpressionArithmetic) {
                    if (this.opType == 32) {
                        if (expression.getRightNode().hasNonDeterministicFunction()) {
                            expression.swapLeftAndRightNodes();
                        }
                    } else if (this.opType != 33) break;
                    if (expression.getRightNode().hasNonDeterministicFunction()) break;
                    expression = expression.getLeftNode();
                }
                if (expression.opType != 28) break;
                FunctionSQL functionSQL = (FunctionSQL)expression;
                switch (functionSQL.funcType) {
                    case 43: 
                    case 50: 
                    case 52: {
                        bl2 = false;
                        continue block9;
                    }
                }
            }
            if (bl2) {
                throw Error.error(5512);
            }
        }
        orderedHashSet.clear();
        this.collectObjectNames(orderedHashSet);
        RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
        block10: for (int i4 = 0; i4 < orderedHashSet.size(); ++i4) {
            object = (HsqlNameManager.HsqlName)orderedHashSet.get(i4);
            switch (((HsqlNameManager.HsqlName)object).type) {
                case 9: {
                    int n3;
                    ColumnSchema columnSchema;
                    if (bl || !(columnSchema = rangeVariableArray[0].rangeTable.getColumn(n3 = rangeVariableArray[0].rangeTable.findColumn(((HsqlNameManager.HsqlName)object).name))).isGenerated()) continue block10;
                    throw Error.error(5512);
                }
                case 7: {
                    throw Error.error(5512);
                }
                case 24: {
                    Routine routine = (Routine)session.database.schemaManager.getSchemaObject((HsqlNameManager.HsqlName)object);
                    if (!routine.isDeterministic()) {
                        throw Error.error(5512);
                    }
                    n2 = routine.getDataImpact();
                    if (n2 != 3 && n2 != 4) continue block10;
                    throw Error.error(5512);
                }
            }
        }
        orderedHashSet.clear();
    }

    boolean isUnresolvedParam() {
        return false;
    }

    boolean isDynamicParam() {
        return false;
    }

    boolean hasNonDeterministicFunction() {
        OrderedHashSet orderedHashSet = null;
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, OpTypes.functionExpressionSet, OpTypes.emptyExpressionSet)) == null) {
            return false;
        }
        for (int i2 = 0; i2 < orderedHashSet.size(); ++i2) {
            Expression expression = (Expression)orderedHashSet.get(i2);
            if (!(expression.opType == 27 ? !((FunctionSQLInvoked)expression).isDeterministic() : expression.opType == 28 && !((FunctionSQL)expression).isDeterministic())) continue;
            return true;
        }
        return false;
    }

    void swapLeftAndRightNodes() {
        Expression expression = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = expression;
    }

    void setAttributesAsColumn(ColumnSchema columnSchema) {
        throw Error.runtimeError(201, "Expression");
    }

    String getValueClassName() {
        Type type = this.dataType == null ? NullType.getNullType() : this.dataType;
        return type.getJDBCClassName();
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        int n2;
        if (orderedIntHashSet2.contains(this.opType)) {
            return orderedHashSet;
        }
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            if (this.nodes[n2] == null) continue;
            orderedHashSet = this.nodes[n2].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        n2 = 0;
        if (orderedIntHashSet.contains(this.opType)) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this);
            n2 = 1;
        }
        if (n2 == 0 && this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    public void setNoOptimisation() {
        this.noOptimisation = true;
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.nodes[i2].setNoOptimisation();
        }
    }

    public OrderedHashSet getSubqueries() {
        return this.collectAllSubqueries(null);
    }

    OrderedHashSet collectAllSubqueries(OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] == null) continue;
            orderedHashSet = this.nodes[i2].collectAllSubqueries(orderedHashSet);
        }
        if (this.table != null) {
            OrderedHashSet orderedHashSet2 = null;
            if (this.table.queryExpression != null) {
                orderedHashSet2 = this.table.queryExpression.getSubqueries();
                orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
            }
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet<TableDerived>();
            }
            orderedHashSet.add(this.table);
        }
        return orderedHashSet;
    }

    public boolean isCorrelated() {
        if (this.table == null) {
            return false;
        }
        return this.table.isCorrelated();
    }

    public void checkValidCheckConstraint() {
        OrderedHashSet orderedHashSet = null;
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, OpTypes.subqueryAggregateExpressionSet, OpTypes.emptyExpressionSet)) != null && !orderedHashSet.isEmpty()) {
            throw Error.error(1500, "subquery in check constraint");
        }
    }

    public void resolveGrantFilter(Session session, Table table) {
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(table.getDefaultRanges(), false);
        List list = this.resolveColumnReferences(session, rangeGroupSimple, RangeGroup.emptyArray, null);
        if (list != null && !list.isEmpty()) {
            Expression expression = (Expression)list.get(0);
            expression.getColumnName();
            throw Error.error(5501, expression.getColumnName());
        }
        list = this.collectAllSubqueries(null);
        if (list != null && list.size() > 0) {
            TableDerived tableDerived;
            if (list.size() > 1) {
                // empty if block
            }
            if ((tableDerived = (TableDerived)list.get(0)).isCorrelated()) {
                throw Error.error(5501);
            }
        }
    }

    static List resolveColumnSet(Session session, RangeVariable[] rangeVariableArray, RangeGroup[] rangeGroupArray, List list) {
        return Expression.resolveColumnSet(session, rangeVariableArray, rangeVariableArray.length, rangeGroupArray, list, null);
    }

    static List resolveColumnSet(Session session, RangeVariable[] rangeVariableArray, int n2, RangeGroup[] rangeGroupArray, List list, List list2) {
        if (list == null) {
            return list2;
        }
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(rangeVariableArray, false);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Expression expression = (Expression)list.get(i2);
            list2 = expression.resolveColumnReferences(session, rangeGroupSimple, n2, rangeGroupArray, list2, false);
        }
        return list2;
    }

    boolean isConditionRangeVariable(RangeVariable rangeVariable) {
        return false;
    }

    void getJoinRangeVariables(RangeVariable[] rangeVariableArray, List list) {
    }

    double costFactor(Session session, RangeVariable rangeVariable, int n2) {
        return 16.0;
    }

    Expression getIndexableExpression(RangeVariable rangeVariable) {
        return null;
    }

    public Expression duplicate() {
        Expression expression = null;
        try {
            expression = (Expression)super.clone();
            expression.nodes = (Expression[])this.nodes.clone();
            for (int i2 = 0; i2 < this.nodes.length; ++i2) {
                if (this.nodes[i2] == null) continue;
                expression.nodes[i2] = this.nodes[i2].duplicate();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
        return expression;
    }

    void replaceNode(Expression expression, Expression expression2) {
        for (int i2 = 0; i2 < this.nodes.length; ++i2) {
            if (this.nodes[i2] != expression) continue;
            expression2.alias = this.nodes[i2].alias;
            this.nodes[i2] = expression2;
            return;
        }
        throw Error.runtimeError(201, "Expression");
    }

    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        throw Error.runtimeError(201, "Expression");
    }

    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction, SetFunction setFunction2) {
        throw Error.runtimeError(201, "Expression");
    }

    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        throw Error.runtimeError(201, "Expression");
    }

    public Expression getCondition() {
        return null;
    }

    public boolean hasCondition() {
        return false;
    }

    public void setCondition(Expression expression) {
        throw Error.runtimeError(201, "Expression");
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }
}

