/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol;

import com.mysql.cj.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReadAheadInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private InputStream underlyingStream;
    private byte[] buf;
    protected int endOfCurrentData;
    protected int currentPosition;
    protected boolean doDebug = false;
    protected Log log;
    private final Lock lock = new ReentrantLock();

    private void fill(int readAtLeastTheseManyBytes) throws IOException {
        int n2;
        this.checkClosed();
        this.endOfCurrentData = this.currentPosition = 0;
        int bytesToRead = Math.min(this.buf.length - this.currentPosition, readAtLeastTheseManyBytes);
        int bytesAvailable = this.underlyingStream.available();
        if (bytesAvailable > bytesToRead) {
            bytesToRead = Math.min(this.buf.length - this.currentPosition, bytesAvailable);
        }
        if (this.doDebug) {
            StringBuilder debugBuf = new StringBuilder();
            debugBuf.append("  ReadAheadInputStream.fill(");
            debugBuf.append(readAtLeastTheseManyBytes);
            debugBuf.append("), buffer_size=");
            debugBuf.append(this.buf.length);
            debugBuf.append(", current_position=");
            debugBuf.append(this.currentPosition);
            debugBuf.append(", need to read ");
            debugBuf.append(Math.min(this.buf.length - this.currentPosition, readAtLeastTheseManyBytes));
            debugBuf.append(" bytes to fill request,");
            if (bytesAvailable > 0) {
                debugBuf.append(" underlying InputStream reports ");
                debugBuf.append(bytesAvailable);
                debugBuf.append(" total bytes available,");
            }
            debugBuf.append(" attempting to read ");
            debugBuf.append(bytesToRead);
            debugBuf.append(" bytes.");
            if (this.log != null) {
                this.log.logTrace(debugBuf.toString());
            } else {
                System.err.println(debugBuf.toString());
            }
        }
        if ((n2 = this.underlyingStream.read(this.buf, this.currentPosition, bytesToRead)) > 0) {
            this.endOfCurrentData = n2 + this.currentPosition;
        }
    }

    private int readFromUnderlyingStreamIfNecessary(byte[] b2, int off, int len) throws IOException {
        this.checkClosed();
        int avail = this.endOfCurrentData - this.currentPosition;
        if (this.doDebug) {
            StringBuilder debugBuf = new StringBuilder();
            debugBuf.append("ReadAheadInputStream.readIfNecessary(");
            debugBuf.append(Arrays.toString(b2));
            debugBuf.append(",");
            debugBuf.append(off);
            debugBuf.append(",");
            debugBuf.append(len);
            debugBuf.append(")");
            if (avail <= 0) {
                debugBuf.append(" not all data available in buffer, must read from stream");
                if (len >= this.buf.length) {
                    debugBuf.append(", amount requested > buffer, returning direct read() from stream");
                }
            }
            if (this.log != null) {
                this.log.logTrace(debugBuf.toString());
            } else {
                System.err.println(debugBuf.toString());
            }
        }
        if (avail <= 0) {
            if (len >= this.buf.length) {
                return this.underlyingStream.read(b2, off, len);
            }
            this.fill(len);
            avail = this.endOfCurrentData - this.currentPosition;
            if (avail <= 0) {
                return -1;
            }
        }
        int bytesActuallyRead = avail < len ? avail : len;
        System.arraycopy(this.buf, this.currentPosition, b2, off, bytesActuallyRead);
        this.currentPosition += bytesActuallyRead;
        return bytesActuallyRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        this.lock.lock();
        try {
            int bytesReadThisRound;
            this.checkClosed();
            if ((off | len | off + len | b2.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                int n2 = 0;
                return n2;
            }
            int totalBytesRead = 0;
            do {
                if ((bytesReadThisRound = this.readFromUnderlyingStreamIfNecessary(b2, off + totalBytesRead, len - totalBytesRead)) > 0) continue;
                if (totalBytesRead == 0) {
                    totalBytesRead = bytesReadThisRound;
                }
                break;
            } while ((totalBytesRead += bytesReadThisRound) < len && this.underlyingStream.available() > 0);
            int n3 = totalBytesRead;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.endOfCurrentData) {
            this.fill(1);
            if (this.currentPosition >= this.endOfCurrentData) {
                return -1;
            }
        }
        return this.buf[this.currentPosition++] & 0xFF;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.underlyingStream.available() + this.endOfCurrentData - this.currentPosition;
    }

    private void checkClosed() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public ReadAheadInputStream(InputStream toBuffer, boolean debug, Log logTo) {
        this(toBuffer, 4096, debug, logTo);
    }

    public ReadAheadInputStream(InputStream toBuffer, int bufferSize, boolean debug, Log logTo) {
        this.underlyingStream = toBuffer;
        this.buf = new byte[bufferSize];
        this.doDebug = debug;
        this.log = logTo;
    }

    @Override
    public void close() throws IOException {
        if (this.underlyingStream != null) {
            try {
                this.underlyingStream.close();
            }
            finally {
                this.underlyingStream = null;
                this.buf = null;
                this.log = null;
            }
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n2) throws IOException {
        this.checkClosed();
        if (n2 <= 0L) {
            return 0L;
        }
        long bytesAvailInBuffer = this.endOfCurrentData - this.currentPosition;
        if (bytesAvailInBuffer <= 0L) {
            this.fill((int)n2);
            bytesAvailInBuffer = this.endOfCurrentData - this.currentPosition;
            if (bytesAvailInBuffer <= 0L) {
                return 0L;
            }
        }
        long bytesSkipped = bytesAvailInBuffer < n2 ? bytesAvailInBuffer : n2;
        this.currentPosition = (int)((long)this.currentPosition + bytesSkipped);
        return bytesSkipped;
    }
}

