/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.ha;

import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.ha.BalanceStrategy;
import com.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import java.lang.reflect.InvocationHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BestResponseTimeBalanceStrategy
implements BalanceStrategy {
    @Override
    public ConnectionImpl pickConnection(InvocationHandler proxy, List<String> configuredHosts, Map<String, JdbcConnection> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        ArrayList<String> allowList = new ArrayList<String>(configuredHosts.size());
        allowList.addAll(configuredHosts);
        Map<String, Long> blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
        allowList.removeAll(blockList.keySet());
        SQLException ex = null;
        int attempts = 0;
        while (attempts < numRetries) {
            String bestHost;
            ConnectionImpl conn;
            long minResponseTime = Long.MAX_VALUE;
            int bestHostIndex = 0;
            if (blockList.size() == configuredHosts.size()) {
                blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
            }
            for (int i2 = 0; i2 < responseTimes.length; ++i2) {
                long candidateResponseTime = responseTimes[i2];
                if (candidateResponseTime >= minResponseTime || blockList.containsKey(allowList.get(i2))) continue;
                if (candidateResponseTime == 0L) {
                    bestHostIndex = i2;
                    break;
                }
                bestHostIndex = i2;
                minResponseTime = candidateResponseTime;
            }
            if ((conn = (ConnectionImpl)liveConnections.get(bestHost = (String)allowList.get(bestHostIndex))) == null) {
                try {
                    conn = ((LoadBalancedConnectionProxy)proxy).createConnectionForHost(bestHost);
                }
                catch (SQLException sqlEx) {
                    ex = sqlEx;
                    if (((LoadBalancedConnectionProxy)proxy).shouldExceptionTriggerConnectionSwitch(sqlEx)) {
                        ((LoadBalancedConnectionProxy)proxy).addToGlobalBlocklist(bestHost);
                        blockList.put(bestHost, null);
                        if (blockList.size() != configuredHosts.size()) continue;
                        ++attempts;
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
                        continue;
                    }
                    throw sqlEx;
                }
            }
            return conn;
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }
}

