/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.CancelQueryTask;
import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeSession;
import com.mysql.cj.PingTarget;
import com.mysql.cj.Query;
import com.mysql.cj.QueryAttributesBindings;
import com.mysql.cj.QueryInfo;
import com.mysql.cj.QueryReturnType;
import com.mysql.cj.Session;
import com.mysql.cj.SimpleQuery;
import com.mysql.cj.TransactionEventHandler;
import com.mysql.cj.conf.HostInfo;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.exceptions.AssertionFailedException;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.CJOperationNotSupportedException;
import com.mysql.cj.exceptions.CJTimeoutException;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.exceptions.OperationCancelledException;
import com.mysql.cj.exceptions.StatementIsClosedException;
import com.mysql.cj.jdbc.CloseOption;
import com.mysql.cj.jdbc.EscapeProcessor;
import com.mysql.cj.jdbc.EscapeProcessorResult;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.JdbcPreparedStatement;
import com.mysql.cj.jdbc.JdbcPropertySet;
import com.mysql.cj.jdbc.JdbcStatement;
import com.mysql.cj.jdbc.exceptions.MySQLStatementCancelledException;
import com.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.CachedResultSetMetaData;
import com.mysql.cj.jdbc.result.ResultSetFactory;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.protocol.Message;
import com.mysql.cj.protocol.ProtocolEntityFactory;
import com.mysql.cj.protocol.Resultset;
import com.mysql.cj.protocol.a.NativeMessageBuilder;
import com.mysql.cj.protocol.a.result.ByteArrayRow;
import com.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import com.mysql.cj.result.DefaultColumnDefinition;
import com.mysql.cj.result.Field;
import com.mysql.cj.result.Row;
import com.mysql.cj.telemetry.TelemetryAttribute;
import com.mysql.cj.telemetry.TelemetryScope;
import com.mysql.cj.telemetry.TelemetrySpan;
import com.mysql.cj.telemetry.TelemetrySpanName;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public class StatementImpl
implements JdbcStatement {
    protected static final String PING_MARKER = "/* ping */";
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected NativeMessageBuilder commandBuilder = null;
    protected String charEncoding = null;
    protected volatile JdbcConnection connection = null;
    protected boolean doEscapeProcessing = true;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = (Integer)PropertyDefinitions.getPropertyDefinition(PropertyKey.maxAllowedPacket).getDefaultValue();
    public int maxRows = -1;
    private Set<ResultSetInternalMethods> openResultSets = new HashSet<ResultSetInternalMethods>();
    protected boolean pedantic = false;
    protected boolean profileSQL = false;
    protected ResultSetInternalMethods results = null;
    protected ResultSetInternalMethods generatedKeysResults = null;
    protected int resultSetConcurrency = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    protected SQLWarning warningChain = null;
    protected boolean holdResultsOpenOverClose = false;
    protected ArrayList<Row> batchedGeneratedKeys = null;
    protected boolean retrieveGeneratedKeys = false;
    protected boolean continueBatchOnError = false;
    protected PingTarget pingTarget = null;
    protected ExceptionInterceptor exceptionInterceptor;
    protected boolean lastQueryIsOnDupKeyUpdate = false;
    protected RuntimeProperty<Boolean> dontTrackOpenResources;
    protected RuntimeProperty<Boolean> dumpQueriesOnException;
    protected boolean logSlowQueries = false;
    protected RuntimeProperty<Boolean> rewriteBatchedStatements;
    protected RuntimeProperty<Integer> maxAllowedPacket;
    protected boolean dontCheckOnDuplicateKeyUpdateInSQL;
    protected ResultSetFactory resultSetFactory;
    protected Query query;
    protected NativeSession session = null;
    private Resultset.Type originalResultSetType = Resultset.Type.FORWARD_ONLY;
    private int originalFetchSize = 0;
    private boolean isPoolable = false;
    private boolean closeOnCompletion = false;

    public StatementImpl(JdbcConnection c2, String db) throws SQLException {
        int maxRowsConn;
        int defaultFetchSize;
        if (c2 == null || c2.isClosed()) {
            throw SQLError.createSQLException(Messages.getString("Statement.0"), "08003", null);
        }
        this.connection = c2;
        this.session = (NativeSession)c2.getSession();
        this.exceptionInterceptor = c2.getExceptionInterceptor();
        this.commandBuilder = new NativeMessageBuilder(this.session.getServerSession().supportsQueryAttributes());
        try {
            this.initQuery();
        }
        catch (CJException e2) {
            throw SQLExceptionsMapping.translateException(e2, this.getExceptionInterceptor());
        }
        this.query.setCurrentDatabase(db);
        JdbcPropertySet pset = c2.getPropertySet();
        this.dontTrackOpenResources = pset.getBooleanProperty(PropertyKey.dontTrackOpenResources);
        this.dumpQueriesOnException = pset.getBooleanProperty(PropertyKey.dumpQueriesOnException);
        this.continueBatchOnError = pset.getBooleanProperty(PropertyKey.continueBatchOnError).getValue();
        this.pedantic = pset.getBooleanProperty(PropertyKey.pedantic).getValue();
        this.rewriteBatchedStatements = pset.getBooleanProperty(PropertyKey.rewriteBatchedStatements);
        this.charEncoding = pset.getStringProperty(PropertyKey.characterEncoding).getValue();
        this.profileSQL = pset.getBooleanProperty(PropertyKey.profileSQL).getValue();
        this.useUsageAdvisor = pset.getBooleanProperty(PropertyKey.useUsageAdvisor).getValue();
        this.logSlowQueries = pset.getBooleanProperty(PropertyKey.logSlowQueries).getValue();
        this.maxAllowedPacket = pset.getIntegerProperty(PropertyKey.maxAllowedPacket);
        this.dontCheckOnDuplicateKeyUpdateInSQL = pset.getBooleanProperty(PropertyKey.dontCheckOnDuplicateKeyUpdateInSQL).getValue();
        this.doEscapeProcessing = pset.getBooleanProperty(PropertyKey.enableEscapeProcessing).getValue();
        this.maxFieldSize = this.maxAllowedPacket.getValue();
        if (!this.dontTrackOpenResources.getValue().booleanValue()) {
            c2.registerStatement(this);
        }
        if ((defaultFetchSize = pset.getIntegerProperty(PropertyKey.defaultFetchSize).getValue().intValue()) != 0) {
            this.setFetchSize(defaultFetchSize);
        }
        if ((maxRowsConn = pset.getIntegerProperty(PropertyKey.maxRows).getValue().intValue()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
        this.holdResultsOpenOverClose = pset.getBooleanProperty(PropertyKey.holdResultsOpenOverStatementClose).getValue();
        this.resultSetFactory = new ResultSetFactory(this.connection, this);
    }

    protected void initQuery() {
        this.query = new SimpleQuery(this.session);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (sql != null) {
                    this.query.addBatch(sql);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void addBatch(Object batch) {
        this.query.addBatch(batch);
    }

    @Override
    public List<Object> getBatchedArgs() {
        return this.query.getBatchedArgs();
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (!this.query.getStatementExecuting().get()) {
                return;
            }
            if (!this.isClosed && this.connection != null) {
                NativeSession newSession = null;
                try {
                    HostInfo hostInfo = this.session.getHostInfo();
                    String database = hostInfo.getDatabase();
                    String user = hostInfo.getUser();
                    String password = hostInfo.getPassword();
                    newSession = new NativeSession(this.session.getHostInfo(), this.session.getPropertySet());
                    TelemetrySpan span = newSession.getTelemetryHandler().startSpan(TelemetrySpanName.CANCEL_QUERY, new Object[0]);
                    try (TelemetryScope scope = span.makeCurrent();){
                        span.setAttribute(TelemetryAttribute.DB_NAME, database);
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, "KILL");
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, "KILL (...)");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, user);
                        span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                        newSession.connect(hostInfo, user, password, database, 30000, new TransactionEventHandler(){

                            @Override
                            public void transactionCompleted() {
                            }

                            @Override
                            public void transactionBegun() {
                            }
                        });
                        newSession.getProtocol().sendCommand(new NativeMessageBuilder(newSession.getServerSession().supportsQueryAttributes()).buildComQuery(newSession.getSharedSendPacket(), (Session)newSession, "KILL QUERY " + this.session.getThreadId()), false, 0);
                        this.setCancelStatus(Query.CancelStatus.CANCELED_BY_USER);
                    }
                    catch (Throwable t2) {
                        span.setError(t2);
                        throw t2;
                    }
                    finally {
                        span.end();
                    }
                }
                catch (IOException e2) {
                    throw SQLExceptionsMapping.translateException(e2, this.exceptionInterceptor);
                }
                finally {
                    if (newSession != null) {
                        newSession.forceClose();
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected JdbcConnection checkClosed() {
        JdbcConnection c2 = this.connection;
        if (c2 == null) {
            throw ExceptionFactory.createException(StatementIsClosedException.class, Messages.getString("Statement.AlreadyClosed"), this.getExceptionInterceptor());
        }
        return c2;
    }

    protected boolean isResultSetProducingQuery(String sql) {
        QueryReturnType queryReturnType = QueryInfo.getQueryReturnType(sql, this.session.getServerSession().isNoBackslashEscapesSet());
        return queryReturnType == QueryReturnType.PRODUCES_RESULT_SET || queryReturnType == QueryReturnType.MAY_PRODUCE_RESULT_SET;
    }

    protected boolean isNonResultSetProducingQuery(String sql) {
        QueryReturnType queryReturnType = QueryInfo.getQueryReturnType(sql, this.session.getServerSession().isNoBackslashEscapesSet());
        return queryReturnType == QueryReturnType.DOES_NOT_PRODUCE_RESULT_SET || queryReturnType == QueryReturnType.MAY_PRODUCE_RESULT_SET || queryReturnType == QueryReturnType.NONE;
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw SQLError.createSQLException(Messages.getString("Statement.59"), "S1009", this.getExceptionInterceptor());
        }
        if (sql.length() == 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.61"), "S1009", this.getExceptionInterceptor());
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.query.clearBatchedArgs();
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void clearBatchedArgs() {
        this.query.clearBatchedArgs();
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.setClearWarningsCalled(true);
                this.warningChain = null;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.doClose(CloseOption.PROPAGATE);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void closeAllOpenResults() throws SQLException {
        JdbcConnection locallyScopedConn = this.connection;
        if (locallyScopedConn == null) {
            return;
        }
        Lock connectionLock = locallyScopedConn.getConnectionLock();
        connectionLock.lock();
        try {
            if (this.openResultSets != null) {
                this.openResultSets.forEach(rs -> {
                    try {
                        rs.doClose(CloseOption.IMPLICIT);
                    }
                    catch (SQLException e2) {
                        throw AssertionFailedException.shouldNotHappen(e2);
                    }
                });
                this.openResultSets.clear();
            }
        }
        finally {
            connectionLock.unlock();
        }
    }

    protected void implicitlyCloseAllOpenResults() throws SQLException {
        if (!this.holdResultsOpenOverClose && !this.dontTrackOpenResources.getValue().booleanValue()) {
            if (this.results != null) {
                this.results.doClose(CloseOption.IMPLICIT);
            }
            if (this.generatedKeysResults != null) {
                this.generatedKeysResults.doClose(CloseOption.IMPLICIT);
            }
            this.closeAllOpenResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyResultSetClose(ResultSetInternalMethods rs) {
        try {
            try {
                Lock connectionLock = this.checkClosed().getConnectionLock();
                connectionLock.lock();
                try {
                    boolean hasMoreResults;
                    if (this.openResultSets != null) {
                        this.openResultSets.remove(rs);
                    }
                    boolean bl = hasMoreResults = rs.getNextResultset() != null;
                    if (this.results == rs && !hasMoreResults) {
                        this.results = null;
                    }
                    if (this.generatedKeysResults == rs) {
                        this.generatedKeysResults = null;
                    }
                    if (!hasMoreResults) {
                        this.checkAndPerformCloseOnCompletionAction();
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            catch (StatementIsClosedException statementIsClosedException) {
                // empty catch block
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getOpenResultSetCount() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int n2 = this.openResultSets != null ? this.openResultSets.size() : 0;
                connectionLock.unlock();
                return n2;
            }
            catch (Throwable throwable) {
                try {
                    connectionLock.unlock();
                    throw throwable;
                }
                catch (StatementIsClosedException e2) {
                    return 0;
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void checkAndPerformCloseOnCompletionAction() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (!(!this.isCloseOnCompletion() || this.dontTrackOpenResources.getValue().booleanValue() || this.getOpenResultSetCount() != 0 || this.results != null && this.results.hasRows() && !this.results.isClosed() || this.generatedKeysResults != null && this.generatedKeysResults.hasRows() && !this.generatedKeysResults.isClosed())) {
                    this.doClose(CloseOption.IMPLICIT);
                }
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetInternalMethods createResultSetUsingServerFetch(String sql) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                PreparedStatement pStmt = this.connection.prepareStatement(sql, this.query.getResultType().getIntValue(), this.resultSetConcurrency);
                pStmt.setFetchSize(this.query.getResultFetchSize());
                if (this.getQueryTimeout() > 0) {
                    pStmt.setQueryTimeout(this.getQueryTimeout());
                }
                if (this.maxRows > -1) {
                    pStmt.setMaxRows(this.maxRows);
                }
                this.statementBegins();
                pStmt.execute();
                ResultSetInternalMethods rs = ((JdbcStatement)((Object)pStmt)).getResultSetInternal();
                rs.setStatementUsedForFetchingRows((JdbcPreparedStatement)pStmt);
                this.results = rs;
                ResultSetInternalMethods resultSetInternalMethods = rs;
                return resultSetInternalMethods;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected boolean meetsConditionsForStreamingResultSet() {
        return this.query.getResultType() == Resultset.Type.FORWARD_ONLY && this.resultSetConcurrency == 1007 && this.query.getResultFetchSize() == Integer.MIN_VALUE;
    }

    @Override
    public void enableStreamingResults() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.originalResultSetType = this.query.getResultType();
                this.originalFetchSize = this.query.getResultFetchSize();
                this.setFetchSize(Integer.MIN_VALUE);
                this.setResultSetType(Resultset.Type.FORWARD_ONLY);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void disableStreamingResults() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.query.getResultFetchSize() == Integer.MIN_VALUE && this.query.getResultType() == Resultset.Type.FORWARD_ONLY) {
                    this.setFetchSize(this.originalFetchSize);
                    this.setResultSetType(this.originalResultSetType);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void setupStreamingTimeout(JdbcConnection con) throws SQLException {
        int netTimeoutForStreamingResults = this.session.getPropertySet().getIntegerProperty(PropertyKey.netTimeoutForStreamingResults).getValue();
        if (this.meetsConditionsForStreamingResultSet() && netTimeoutForStreamingResults > 0) {
            TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.SET_VARIABLE, "net_write_timeout");
            try (TelemetryScope scope = span.makeCurrent();){
                span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                span.setAttribute(TelemetryAttribute.DB_OPERATION, "SET");
                span.setAttribute(TelemetryAttribute.DB_STATEMENT, "SET (...)");
                span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                span.setAttribute(TelemetryAttribute.DB_USER, () -> this.connection.getUser());
                span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                this.executeSimpleNonQuery(con, "SET net_write_timeout=" + netTimeoutForStreamingResults);
            }
            catch (Throwable t2) {
                span.setError(t2);
                throw t2;
            }
            finally {
                span.end();
            }
        }
    }

    @Override
    public CancelQueryTask startQueryTimer(Query stmtToCancel, long timeout) {
        return this.query.startQueryTimer(stmtToCancel, timeout);
    }

    @Override
    public void stopQueryTimer(CancelQueryTask timeoutTask, boolean rethrowCancelReason, boolean checkCancelTimeout) {
        this.query.stopQueryTimer(timeoutTask, rethrowCancelReason, checkCancelTimeout);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.executeInternal(sql, false);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        try {
            return this.executeInternal(sql, returnGeneratedKeys == 1);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        try {
            return this.executeInternal(sql, generatedKeyIndices != null && generatedKeyIndices.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        try {
            return this.executeInternal(sql, generatedKeyNames != null && generatedKeyNames.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    private boolean executeInternal(String sql, boolean returnGeneratedKeys) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void statementBegins() {
        this.query.statementBegins();
    }

    @Override
    public void resetCancelledState() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.query.resetCancelledState();
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeBatchInternal());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    protected long[] executeBatchInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final boolean hasDeadlockOrTimeoutRolledBackTx(SQLException ex) {
        int vendorCode = ex.getErrorCode();
        switch (vendorCode) {
            case 1206: 
            case 1213: {
                return true;
            }
            case 1205: {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] executeBatchUsingMultiQueries(boolean multiQueriesEnabled, int nbrCommands, long individualStatementTimeout) throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.checkClosed();
            Lock connectionLock = locallyScopedConn.getConnectionLock();
            connectionLock.lock();
            try {
                long[] lArray;
                if (!multiQueriesEnabled) {
                    this.session.enableMultiQueries();
                }
                Statement batchStmt = null;
                CancelQueryTask timeoutTask = null;
                try {
                    long[] updateCounts = new long[nbrCommands];
                    for (int i2 = 0; i2 < nbrCommands; ++i2) {
                        updateCounts[i2] = -3L;
                    }
                    int commandIndex = 0;
                    StringBuilder queryBuf = new StringBuilder();
                    batchStmt = locallyScopedConn.createStatement();
                    JdbcStatement jdbcBatchedStmt = (JdbcStatement)batchStmt;
                    this.getQueryAttributesBindings().runThroughAll(a2 -> jdbcBatchedStmt.setAttribute(a2.getName(), a2.getValue()));
                    timeoutTask = this.startQueryTimer((StatementImpl)batchStmt, individualStatementTimeout);
                    int counter = 0;
                    String connectionEncoding = locallyScopedConn.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
                    int numberOfBytesPerChar = StringUtils.startsWithIgnoreCase(connectionEncoding, "utf") ? 3 : (this.session.getServerSession().getCharsetSettings().isMultibyteCharset(connectionEncoding) ? 2 : 1);
                    int escapeAdjust = 1;
                    batchStmt.setEscapeProcessing(this.doEscapeProcessing);
                    if (this.doEscapeProcessing) {
                        escapeAdjust = 2;
                    }
                    SQLException sqlEx = null;
                    int argumentSetsInBatchSoFar = 0;
                    for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                        String nextQuery = (String)this.query.getBatchedArgs().get(commandIndex);
                        if (queryBuf.length() > 0 && ((queryBuf.length() + nextQuery.length()) * numberOfBytesPerChar + 1 + 4) * escapeAdjust + 32 > this.maxAllowedPacket.getValue()) {
                            try {
                                batchStmt.execute(queryBuf.toString(), 1);
                            }
                            catch (SQLException ex) {
                                sqlEx = this.handleExceptionForBatch(commandIndex, argumentSetsInBatchSoFar, updateCounts, ex);
                            }
                            counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                            queryBuf = new StringBuilder();
                            argumentSetsInBatchSoFar = 0;
                        }
                        queryBuf.append(nextQuery);
                        queryBuf.append(";");
                        ++argumentSetsInBatchSoFar;
                    }
                    if (queryBuf.length() > 0) {
                        try {
                            batchStmt.execute(queryBuf.toString(), 1);
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(commandIndex - 1, argumentSetsInBatchSoFar, updateCounts, ex);
                        }
                        counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                    }
                    if (timeoutTask != null) {
                        this.stopQueryTimer(timeoutTask, true, true);
                        timeoutTask = null;
                    }
                    if (sqlEx != null) {
                        throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.getExceptionInterceptor());
                    }
                    lArray = updateCounts != null ? updateCounts : new long[]{};
                    this.stopQueryTimer(timeoutTask, false, false);
                    this.resetCancelledState();
                }
                catch (Throwable throwable) {
                    this.stopQueryTimer(timeoutTask, false, false);
                    this.resetCancelledState();
                    try {
                        if (batchStmt != null) {
                            batchStmt.close();
                        }
                    }
                    finally {
                        if (!multiQueriesEnabled) {
                            this.session.disableMultiQueries();
                        }
                    }
                    throw throwable;
                }
                try {
                    if (batchStmt != null) {
                        batchStmt.close();
                    }
                }
                finally {
                    if (!multiQueriesEnabled) {
                        this.session.disableMultiQueries();
                    }
                }
                return lArray;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processMultiCountsAndKeys(StatementImpl batchedStatement, int updateCountCounter, long[] updateCounts) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                long generatedKey;
                updateCounts[updateCountCounter++] = batchedStatement.getLargeUpdateCount();
                boolean doGenKeys = this.batchedGeneratedKeys != null;
                Object row = null;
                if (doGenKeys) {
                    generatedKey = batchedStatement.getLastInsertID();
                    row = new byte[1][];
                    row[0] = StringUtils.getBytes(Long.toString(generatedKey));
                    this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
                }
                while (batchedStatement.getMoreResults() || batchedStatement.getLargeUpdateCount() != -1L) {
                    updateCounts[updateCountCounter++] = batchedStatement.getLargeUpdateCount();
                    if (!doGenKeys) continue;
                    generatedKey = batchedStatement.getLastInsertID();
                    row = new byte[1][];
                    row[0] = StringUtils.getBytes(Long.toString(generatedKey));
                    this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
                }
                int n2 = updateCountCounter;
                return n2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected SQLException handleExceptionForBatch(int endOfBatchIndex, int numValuesPerBatch, long[] updateCounts, SQLException ex) throws BatchUpdateException, SQLException {
        for (int j2 = endOfBatchIndex; j2 > endOfBatchIndex - numValuesPerBatch; --j2) {
            updateCounts[j2] = -3L;
        }
        if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
            return ex;
        }
        long[] newUpdateCounts = new long[endOfBatchIndex];
        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, endOfBatchIndex);
        throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.getExceptionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                block48: {
                    TelemetrySpan span = this.getSession().getTelemetryHandler().startSpan(TelemetrySpanName.STMT_EXECUTE, new Object[0]);
                    try (TelemetryScope scope = span.makeCurrent();){
                        String dbOperation = QueryInfo.getStatementKeyword(sql, this.session.getServerSession().isNoBackslashEscapesSet());
                        span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, dbOperation);
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, dbOperation + " (...)");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, () -> this.connection.getUser());
                        span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                        JdbcConnection locallyScopedConn = this.connection;
                        this.retrieveGeneratedKeys = false;
                        this.checkNullOrEmptyQuery(sql);
                        this.resetCancelledState();
                        this.implicitlyCloseAllOpenResults();
                        this.clearWarnings();
                        if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                            this.doPingInstead();
                            ResultSetInternalMethods resultSetInternalMethods = this.results;
                            return resultSetInternalMethods;
                        }
                        this.setupStreamingTimeout(locallyScopedConn);
                        if (this.doEscapeProcessing) {
                            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.session.getServerSession().getSessionTimeZone(), this.session.getServerSession().getCapabilities().serverSupportsFracSecs(), this.session.getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
                            String string = sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                        }
                        if (!this.isResultSetProducingQuery(sql)) {
                            throw SQLError.createSQLException(Messages.getString("Statement.57"), "S1009", this.getExceptionInterceptor());
                        }
                        CachedResultSetMetaData cachedMetaData = null;
                        if (this.useServerFetch()) {
                            ResultSetInternalMethods resultSetInternalMethods = this.results = this.createResultSetUsingServerFetch(sql);
                            return resultSetInternalMethods;
                        }
                        CancelQueryTask timeoutTask = null;
                        String oldDb = null;
                        try {
                            timeoutTask = this.startQueryTimer(this, this.getTimeoutInMillis());
                            if (!locallyScopedConn.getDatabase().equals(this.getCurrentDatabase())) {
                                oldDb = locallyScopedConn.getDatabase();
                                locallyScopedConn.setDatabase(this.getCurrentDatabase());
                            }
                            if (locallyScopedConn.getPropertySet().getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                                cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                            }
                            locallyScopedConn.setSessionMaxRows(this.maxRows);
                            this.statementBegins();
                            this.results = (ResultSetInternalMethods)((NativeSession)locallyScopedConn.getSession()).execSQL(this, sql, this.maxRows, null, this.meetsConditionsForStreamingResultSet(), this.getResultSetFactory(), cachedMetaData, false);
                            if (timeoutTask != null) {
                                this.stopQueryTimer(timeoutTask, true, true);
                                timeoutTask = null;
                            }
                        }
                        catch (CJTimeoutException | OperationCancelledException e2) {
                            throw SQLExceptionsMapping.translateException(e2, this.exceptionInterceptor);
                        }
                        finally {
                            this.query.getStatementExecuting().set(false);
                            this.stopQueryTimer(timeoutTask, false, false);
                            if (oldDb != null) {
                                locallyScopedConn.setDatabase(oldDb);
                            }
                        }
                        this.lastInsertId = this.results.getUpdateID();
                        if (cachedMetaData != null) {
                            locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                            break block48;
                        }
                        if (this.connection.getPropertySet().getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                            locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                        }
                    }
                    catch (Throwable t2) {
                        span.setError(t2);
                        throw t2;
                    }
                    finally {
                        span.end();
                    }
                }
                ResultSetInternalMethods resultSetInternalMethods = this.results;
                return resultSetInternalMethods;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void doPingInstead() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ResultSetInternalMethods fakeSelectOneResultSet;
                if (this.pingTarget != null) {
                    try {
                        this.pingTarget.doPing();
                    }
                    catch (SQLException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        throw SQLError.createSQLException(e3.getMessage(), "08S01", e3, this.getExceptionInterceptor());
                    }
                } else {
                    this.connection.ping();
                }
                this.results = fakeSelectOneResultSet = this.generatePingResultSet();
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetInternalMethods generatePingResultSet() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                String encoding = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
                int collationIndex = this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex();
                Field[] fields = new Field[]{new Field(null, "1", collationIndex, encoding, MysqlType.BIGINT, 1)};
                ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
                byte[] colVal = new byte[]{49};
                rows.add(new ByteArrayRow(new byte[][]{colVal}, this.getExceptionInterceptor()));
                ResultSetImpl resultSetImpl = this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
                return resultSetImpl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSimpleNonQuery(JdbcConnection c2, String nonQuery) throws SQLException {
        try {
            Lock connectionLock = c2.getConnectionLock();
            connectionLock.lock();
            try {
                ((ResultSetImpl)((NativeSession)c2.getSession()).execSQL(this, nonQuery, -1, null, false, this.getResultSetFactory(), null, false)).doClose(new CloseOption[0]);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, autoGeneratedKeys));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, columnIndexes));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, columnNames));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long executeUpdateInternal(String sql, boolean isBatch, boolean returnGeneratedKeys) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                TelemetrySpan span = this.getSession().getTelemetryHandler().startSpan(TelemetrySpanName.STMT_EXECUTE, new Object[0]);
                try (TelemetryScope scope = span.makeCurrent();){
                    String oldDb;
                    CancelQueryTask timeoutTask;
                    ResultSetInternalMethods rs;
                    char firstStatementChar;
                    JdbcConnection locallyScopedConn;
                    block35: {
                        String dbOperation = QueryInfo.getStatementKeyword(sql, this.session.getServerSession().isNoBackslashEscapesSet());
                        span.setAttribute(TelemetryAttribute.DB_NAME, this::getCurrentDatabase);
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, dbOperation);
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, dbOperation + " (...)");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, () -> this.connection.getUser());
                        span.setAttribute(TelemetryAttribute.THREAD_ID, () -> Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, () -> Thread.currentThread().getName());
                        locallyScopedConn = this.connection;
                        this.checkNullOrEmptyQuery(sql);
                        this.resetCancelledState();
                        this.clearWarnings();
                        firstStatementChar = QueryInfo.firstCharOfStatementUc(sql, this.session.getServerSession().isNoBackslashEscapesSet());
                        if (!this.isNonResultSetProducingQuery(sql)) {
                            throw SQLError.createSQLException(Messages.getString("Statement.46"), "01S03", this.getExceptionInterceptor());
                        }
                        this.retrieveGeneratedKeys = returnGeneratedKeys;
                        this.lastQueryIsOnDupKeyUpdate = returnGeneratedKeys && firstStatementChar == 'I' && this.containsOnDuplicateKeyInString(sql);
                        rs = null;
                        if (!isBatch) {
                            this.batchedGeneratedKeys = null;
                        }
                        if (this.doEscapeProcessing) {
                            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.session.getServerSession().getSessionTimeZone(), this.session.getServerSession().getCapabilities().serverSupportsFracSecs(), this.session.getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
                            String string = sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                        }
                        if (locallyScopedConn.isReadOnly(false)) {
                            throw SQLError.createSQLException(Messages.getString("Statement.42") + Messages.getString("Statement.43"), "S1009", this.getExceptionInterceptor());
                        }
                        this.implicitlyCloseAllOpenResults();
                        timeoutTask = null;
                        oldDb = null;
                        try {
                            timeoutTask = this.startQueryTimer(this, this.getTimeoutInMillis());
                            if (!locallyScopedConn.getDatabase().equals(this.getCurrentDatabase())) {
                                oldDb = locallyScopedConn.getDatabase();
                                locallyScopedConn.setDatabase(this.getCurrentDatabase());
                            }
                            locallyScopedConn.setSessionMaxRows(-1);
                            this.statementBegins();
                            rs = (ResultSetInternalMethods)((NativeSession)locallyScopedConn.getSession()).execSQL(this, sql, -1, null, false, this.getResultSetFactory(), null, isBatch);
                            if (timeoutTask == null) break block35;
                            this.stopQueryTimer(timeoutTask, true, true);
                            timeoutTask = null;
                        }
                        catch (CJTimeoutException | OperationCancelledException e2) {
                            try {
                                throw SQLExceptionsMapping.translateException(e2, this.exceptionInterceptor);
                            }
                            catch (Throwable throwable) {
                                this.stopQueryTimer(timeoutTask, false, false);
                                if (oldDb != null) {
                                    locallyScopedConn.setDatabase(oldDb);
                                }
                                if (!isBatch) {
                                    this.query.getStatementExecuting().set(false);
                                }
                                throw throwable;
                            }
                        }
                    }
                    this.stopQueryTimer(timeoutTask, false, false);
                    if (oldDb != null) {
                        locallyScopedConn.setDatabase(oldDb);
                    }
                    if (!isBatch) {
                        this.query.getStatementExecuting().set(false);
                    }
                    this.results = rs;
                    rs.setFirstCharOfQuery(firstStatementChar);
                    this.updateCount = rs.getUpdateCount();
                    this.lastInsertId = rs.getUpdateID();
                }
                catch (Throwable t2) {
                    span.setError(t2);
                    throw t2;
                }
                finally {
                    span.end();
                }
                long l2 = this.updateCount;
                return l2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                JdbcConnection jdbcConnection = this.connection;
                return jdbcConnection;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return 1000;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int n2 = this.query.getResultFetchSize();
                return n2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (!this.retrieveGeneratedKeys) {
                    throw SQLError.createSQLException(Messages.getString("Statement.GeneratedKeysNotRequested"), "S1009", this.getExceptionInterceptor());
                }
                if (this.batchedGeneratedKeys == null) {
                    if (this.lastQueryIsOnDupKeyUpdate) {
                        ResultSetInternalMethods resultSetInternalMethods = this.generatedKeysResults = this.getGeneratedKeysInternal(1L);
                        return resultSetInternalMethods;
                    }
                    ResultSetInternalMethods resultSetInternalMethods = this.generatedKeysResults = this.getGeneratedKeysInternal();
                    return resultSetInternalMethods;
                }
                String encoding = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
                int collationIndex = this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex();
                Field[] fields = new Field[]{new Field("", "GENERATED_KEY", collationIndex, encoding, MysqlType.BIGINT_UNSIGNED, 20)};
                ResultSetInternalMethods resultSetInternalMethods = this.generatedKeysResults = this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(this.batchedGeneratedKeys, new DefaultColumnDefinition(fields)));
                return resultSetInternalMethods;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected ResultSetInternalMethods getGeneratedKeysInternal() throws SQLException {
        long numKeys = this.getLargeUpdateCount();
        return this.getGeneratedKeysInternal(numKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetInternalMethods getGeneratedKeysInternal(long numKeys) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ResultSetImpl gkRs;
                String encoding = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
                int collationIndex = this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex();
                Field[] fields = new Field[]{new Field("", "GENERATED_KEY", collationIndex, encoding, MysqlType.BIGINT_UNSIGNED, 20)};
                ArrayList<ByteArrayRow> rowSet = new ArrayList<ByteArrayRow>();
                long beginAt = this.getLastInsertID();
                if (this.results != null) {
                    String serverInfo = this.results.getServerInfo();
                    if (numKeys > 0L && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
                        numKeys = this.getRecordCountFromInfo(serverInfo);
                    }
                    if (beginAt != 0L && numKeys > 0L) {
                        int i2 = 0;
                        while ((long)i2 < numKeys) {
                            byte[][] row = new byte[1][];
                            if (beginAt > 0L) {
                                row[0] = StringUtils.getBytes(Long.toString(beginAt));
                            } else {
                                byte[] asBytes = new byte[8];
                                asBytes[7] = (byte)(beginAt & 0xFFL);
                                asBytes[6] = (byte)(beginAt >>> 8);
                                asBytes[5] = (byte)(beginAt >>> 16);
                                asBytes[4] = (byte)(beginAt >>> 24);
                                asBytes[3] = (byte)(beginAt >>> 32);
                                asBytes[2] = (byte)(beginAt >>> 40);
                                asBytes[1] = (byte)(beginAt >>> 48);
                                asBytes[0] = (byte)(beginAt >>> 56);
                                BigInteger val = new BigInteger(1, asBytes);
                                row[0] = val.toString().getBytes();
                            }
                            rowSet.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                            beginAt += (long)this.connection.getAutoIncrementIncrement();
                            ++i2;
                        }
                    }
                }
                ResultSetImpl resultSetImpl = gkRs = this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rowSet, new DefaultColumnDefinition(fields)));
                return resultSetImpl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastInsertID() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                long l2 = this.lastInsertId;
                return l2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongUpdateCount() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.results == null || this.results.hasRows()) {
                    long l2 = -1L;
                    return l2;
                }
                long l3 = this.updateCount;
                return l3;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int n2 = this.maxFieldSize;
                return n2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.maxRows <= 0) {
                    int n2 = 0;
                    return n2;
                }
                int n3 = this.maxRows;
                return n3;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.getMoreResults(1);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                boolean moreResults;
                if (this.results == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean streamingMode = this.meetsConditionsForStreamingResultSet();
                if (streamingMode && this.results.hasRows()) {
                    while (this.results.next()) {
                    }
                }
                ResultSetInternalMethods nextResultSet = (ResultSetInternalMethods)this.results.getNextResultset();
                switch (current) {
                    case 1: {
                        if (this.results == null) break;
                        if (!streamingMode && !this.dontTrackOpenResources.getValue().booleanValue()) {
                            this.results.doClose(CloseOption.IMPLICIT);
                        }
                        if (this.results == null) break;
                        this.results.clearNextResultset();
                        break;
                    }
                    case 3: {
                        if (this.results != null) {
                            if (!streamingMode && !this.dontTrackOpenResources.getValue().booleanValue()) {
                                this.results.doClose(CloseOption.IMPLICIT);
                            }
                            if (this.results != null) {
                                this.results.clearNextResultset();
                            }
                        }
                        this.closeAllOpenResults();
                        break;
                    }
                    case 2: {
                        if (!this.dontTrackOpenResources.getValue().booleanValue()) {
                            this.openResultSets.add(this.results);
                        }
                        this.results.clearNextResultset();
                        break;
                    }
                    default: {
                        throw SQLError.createSQLException(Messages.getString("Statement.19"), "S1009", this.getExceptionInterceptor());
                    }
                }
                this.results = nextResultSet;
                if (this.results == null) {
                    this.updateCount = -1L;
                    this.lastInsertId = -1L;
                } else if (this.results.hasRows()) {
                    this.updateCount = -1L;
                    this.lastInsertId = -1L;
                } else {
                    this.updateCount = this.results.getUpdateCount();
                    this.lastInsertId = this.results.getUpdateID();
                }
                boolean bl = moreResults = this.results != null && this.results.hasRows();
                if (!moreResults) {
                    this.checkAndPerformCloseOnCompletionAction();
                }
                boolean bl2 = moreResults;
                return bl2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int n2 = Math.toIntExact(this.getTimeoutInMillis() / 1000L);
                return n2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private long getRecordCountFromInfo(String serverInfo) {
        int i2;
        StringBuilder recordsBuf = new StringBuilder();
        long recordsCount = 0L;
        long duplicatesCount = 0L;
        char c2 = '\u0000';
        int length = serverInfo.length();
        for (i2 = 0; i2 < length && !Character.isDigit(c2 = serverInfo.charAt(i2)); ++i2) {
        }
        recordsBuf.append(c2);
        ++i2;
        while (i2 < length && Character.isDigit(c2 = serverInfo.charAt(i2))) {
            recordsBuf.append(c2);
            ++i2;
        }
        recordsCount = Long.parseLong(recordsBuf.toString());
        StringBuilder duplicatesBuf = new StringBuilder();
        while (i2 < length && !Character.isDigit(c2 = serverInfo.charAt(i2))) {
            ++i2;
        }
        duplicatesBuf.append(c2);
        ++i2;
        while (i2 < length && Character.isDigit(c2 = serverInfo.charAt(i2))) {
            duplicatesBuf.append(c2);
            ++i2;
        }
        duplicatesCount = Long.parseLong(duplicatesBuf.toString());
        return recordsCount - duplicatesCount;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ResultSetInternalMethods resultSetInternalMethods = this.results != null && this.results.hasRows() ? this.results : null;
                return resultSetInternalMethods;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int n2 = this.resultSetConcurrency;
                return n2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return 1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSetInternalMethods getResultSetInternal() {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                ResultSetInternalMethods resultSetInternalMethods = this.results;
                connectionLock.unlock();
                return resultSetInternalMethods;
            }
            catch (Throwable throwable) {
                try {
                    connectionLock.unlock();
                    throw throwable;
                }
                catch (StatementIsClosedException e2) {
                    return this.results;
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                int n2 = this.query.getResultType().getIntValue();
                return n2;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.getLargeUpdateCount());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.isClearWarningsCalled()) {
                    SQLWarning sQLWarning = null;
                    return sQLWarning;
                }
                SQLWarning pendingWarningsFromServer = this.session.getProtocol().convertShowWarningsToSQLWarnings(false);
                if (this.warningChain != null) {
                    this.warningChain.setNextWarning(pendingWarningsFromServer);
                } else {
                    this.warningChain = pendingWarningsFromServer;
                }
                SQLWarning sQLWarning = this.warningChain;
                return sQLWarning;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void doClose(CloseOption ... options) throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn == null || this.isClosed) {
                return;
            }
            if (!this.dontTrackOpenResources.getValue().booleanValue()) {
                locallyScopedConn.unregisterStatement(this);
            }
            if (this.useUsageAdvisor && CloseOption.IMPLICIT.in(options)) {
                this.session.getProfilerEventHandler().processEvent((byte)0, this.session, this, null, 0L, new Throwable(), Messages.getString("Statement.63"));
            }
            if (CloseOption.PROPAGATE.in(options) && !this.holdResultsOpenOverClose && !this.dontTrackOpenResources.getValue().booleanValue()) {
                if (this.results != null) {
                    try {
                        this.results.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.generatedKeysResults != null) {
                    try {
                        this.generatedKeysResults.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.closeAllOpenResults();
            }
            this.clearAttributes();
            this.isClosed = true;
            this.closeQuery();
            this.results = null;
            this.generatedKeysResults = null;
            this.connection = null;
            this.session = null;
            this.warningChain = null;
            this.openResultSets = null;
            this.batchedGeneratedKeys = null;
            this.pingTarget = null;
            this.resultSetFactory = null;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.doEscapeProcessing = enable;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            switch (direction) {
                case 1000: 
                case 1001: 
                case 1002: {
                    break;
                }
                default: {
                    throw SQLError.createSQLException(Messages.getString("Statement.5"), "S1009", this.getExceptionInterceptor());
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows > 0 && rows > this.getMaxRows()) {
                    throw SQLError.createSQLException(Messages.getString("Statement.7"), "S1009", this.getExceptionInterceptor());
                }
                this.query.setResultFetchSize(rows);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setHoldResultsOpenOverClose(boolean holdResultsOpenOverClose) {
        try {
            try {
                Lock connectionLock = this.checkClosed().getConnectionLock();
                connectionLock.lock();
                try {
                    this.holdResultsOpenOverClose = holdResultsOpenOverClose;
                }
                finally {
                    connectionLock.unlock();
                }
            }
            catch (StatementIsClosedException statementIsClosedException) {
                // empty catch block
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (max < 0) {
                    throw SQLError.createSQLException(Messages.getString("Statement.11"), "S1009", this.getExceptionInterceptor());
                }
                int maxBuf = this.maxAllowedPacket.getValue();
                if (max > maxBuf) {
                    throw SQLError.createSQLException(Messages.getString("Statement.13", new Object[]{(long)maxBuf}), "S1009", this.getExceptionInterceptor());
                }
                this.maxFieldSize = max;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.setLargeMaxRows(max);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (seconds < 0) {
                    throw SQLError.createSQLException(Messages.getString("Statement.21"), "S1009", this.getExceptionInterceptor());
                }
                this.setTimeoutInMillis(seconds * 1000);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    void setResultSetConcurrency(int concurrencyFlag) throws SQLException {
        try {
            try {
                Lock connectionLock = this.checkClosed().getConnectionLock();
                connectionLock.lock();
                try {
                    this.resultSetConcurrency = concurrencyFlag;
                    this.resultSetFactory = new ResultSetFactory(this.connection, this);
                }
                finally {
                    connectionLock.unlock();
                }
            }
            catch (StatementIsClosedException statementIsClosedException) {
                // empty catch block
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    void setResultSetType(Resultset.Type typeFlag) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.query.setResultType(typeFlag);
                this.resultSetFactory = new ResultSetFactory(this.connection, this);
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (StatementIsClosedException statementIsClosedException) {
            // empty catch block
        }
    }

    void setResultSetType(int typeFlag) throws SQLException {
        this.query.setResultType(Resultset.Type.fromValue(typeFlag, Resultset.Type.FORWARD_ONLY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBatchedGeneratedKeys(Statement batchedStatement) throws SQLException {
        try {
            block10: {
                Lock connectionLock = this.checkClosed().getConnectionLock();
                connectionLock.lock();
                try {
                    if (!this.retrieveGeneratedKeys) break block10;
                    try (ResultSet rs = null;){
                        rs = batchedStatement.getGeneratedKeys();
                        while (rs.next()) {
                            this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
                        }
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBatchedGeneratedKeys(int maxKeys) throws SQLException {
        try {
            block10: {
                Lock connectionLock = this.checkClosed().getConnectionLock();
                connectionLock.lock();
                try {
                    if (!this.retrieveGeneratedKeys) break block10;
                    ResultSetInternalMethods rs = null;
                    try {
                        ResultSetInternalMethods resultSetInternalMethods = rs = maxKeys == 0 ? this.getGeneratedKeysInternal() : this.getGeneratedKeysInternal(maxKeys);
                        while (rs.next()) {
                            this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.doClose(new CloseOption[0]);
                        }
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private boolean useServerFetch() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = this.session.getPropertySet().getBooleanProperty(PropertyKey.useCursorFetch).getValue() != false && this.query.getResultFetchSize() > 0 && this.query.getResultType() == Resultset.Type.FORWARD_ONLY;
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn == null) {
                return true;
            }
            Lock connectionLock = locallyScopedConn.getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = this.isClosed;
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            this.checkClosed();
            return this.isPoolable;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            this.checkClosed();
            this.isPoolable = poolable;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkClosed();
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException(Messages.getString("Common.UnableToUnwrap", new Object[]{iface.toString()}), "S1009", this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.session.getLocalInfileInputStream();
    }

    @Override
    public void setLocalInfileInputStream(InputStream stream) {
        this.session.setLocalInfileInputStream(stream);
    }

    @Override
    public void setPingTarget(PingTarget pingTarget) {
        this.pingTarget = pingTarget;
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    protected boolean containsOnDuplicateKeyInString(String sql) {
        return (!this.dontCheckOnDuplicateKeyUpdateInSQL || this.rewriteBatchedStatements.getValue() != false) && QueryInfo.containsOnDuplicateKeyUpdateClause(sql, this.session.getServerSession().isNoBackslashEscapesSet());
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                this.closeOnCompletion = true;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = this.closeOnCompletion;
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            return this.executeBatchInternal();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, false);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, autoGeneratedKeys == 1);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, columnIndexes != null && columnIndexes.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, columnNames != null && columnNames.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this.getMaxRows();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (this.results == null || this.results.hasRows()) {
                    long l2 = -1L;
                    return l2;
                }
                long l3 = this.results.getUpdateCount();
                return l3;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            Lock connectionLock = this.checkClosed().getConnectionLock();
            connectionLock.lock();
            try {
                if (max > 50000000L || max < 0L) {
                    throw SQLError.createSQLException(Messages.getString("Statement.15") + max + " > " + 50000000 + ".", "S1009", this.getExceptionInterceptor());
                }
                if (max == 0L) {
                    max = -1L;
                }
                this.maxRows = (int)max;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCurrentDatabase() {
        return this.query.getCurrentDatabase();
    }

    public long getServerStatementId() {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, Messages.getString("Statement.65"));
    }

    @Override
    public <T extends Resultset, M extends Message> ProtocolEntityFactory<T, M> getResultSetFactory() {
        return this.resultSetFactory;
    }

    @Override
    public int getId() {
        return this.query.getId();
    }

    @Override
    public void setCancelStatus(Query.CancelStatus cs) {
        this.query.setCancelStatus(cs);
    }

    @Override
    public void checkCancelTimeout() {
        try {
            this.query.checkCancelTimeout();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Lock getCancelTimeoutLock() {
        return this.query.getCancelTimeoutLock();
    }

    @Override
    public void closeQuery() {
        if (this.query != null) {
            this.query.closeQuery();
        }
    }

    @Override
    public int getResultFetchSize() {
        return this.query.getResultFetchSize();
    }

    @Override
    public void setResultFetchSize(int fetchSize) {
        this.query.setResultFetchSize(fetchSize);
    }

    @Override
    public Resultset.Type getResultType() {
        return this.query.getResultType();
    }

    @Override
    public void setResultType(Resultset.Type resultSetType) {
        this.query.setResultType(resultSetType);
    }

    @Override
    public long getTimeoutInMillis() {
        return this.query.getTimeoutInMillis();
    }

    @Override
    public void setTimeoutInMillis(long timeoutInMillis) {
        this.query.setTimeoutInMillis(timeoutInMillis);
    }

    @Override
    public long getExecuteTime() {
        return this.query.getExecuteTime();
    }

    @Override
    public void setExecuteTime(long executeTime) {
        this.query.setExecuteTime(executeTime);
    }

    @Override
    public AtomicBoolean getStatementExecuting() {
        return this.query.getStatementExecuting();
    }

    @Override
    public void setCurrentDatabase(String currentDb) {
        this.query.setCurrentDatabase(currentDb);
    }

    @Override
    public boolean isClearWarningsCalled() {
        return this.query.isClearWarningsCalled();
    }

    @Override
    public void setClearWarningsCalled(boolean clearWarningsCalled) {
        this.query.setClearWarningsCalled(clearWarningsCalled);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public QueryAttributesBindings getQueryAttributesBindings() {
        return this.query.getQueryAttributesBindings();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.getQueryAttributesBindings().setAttribute(name, value);
    }

    @Override
    public void clearAttributes() {
        QueryAttributesBindings qab = this.getQueryAttributesBindings();
        if (qab != null) {
            qab.clearAttributes();
        }
    }

    private static /* synthetic */ String lambda$executeBatchInternal$11() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$executeBatchInternal$10() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$executeBatchInternal$9() {
        return this.connection.getUser();
    }

    private static /* synthetic */ String lambda$executeInternal$8() {
        return Thread.currentThread().getName();
    }

    private static /* synthetic */ Long lambda$executeInternal$7() {
        return Thread.currentThread().getId();
    }

    private /* synthetic */ String lambda$executeInternal$6() {
        return this.connection.getUser();
    }
}

