/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.jdbc.ClientInfoProvider;
import com.mysql.cj.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class CommentClientInfoProvider
implements ClientInfoProvider {
    private Properties clientInfo;

    @Override
    public synchronized void initialize(Connection conn, Properties configurationProps) throws SQLException {
        this.clientInfo = new Properties();
    }

    @Override
    public synchronized void destroy() throws SQLException {
        this.clientInfo = null;
    }

    @Override
    public synchronized Properties getClientInfo(Connection conn) throws SQLException {
        Properties clientInfoOut = new Properties();
        clientInfoOut.putAll((Map<?, ?>)this.clientInfo);
        return clientInfoOut;
    }

    @Override
    public synchronized String getClientInfo(Connection conn, String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public synchronized void setClientInfo(Connection conn, Properties properties) throws SQLClientInfoException {
        this.clientInfo = new Properties();
        if (properties != null) {
            this.clientInfo.putAll((Map<?, ?>)properties);
        }
        this.setComment(conn);
    }

    @Override
    public synchronized void setClientInfo(Connection conn, String name, String value) throws SQLClientInfoException {
        if (value == null) {
            this.clientInfo.remove(name);
        } else {
            this.clientInfo.setProperty(name, value);
        }
        this.setComment(conn);
    }

    private synchronized void setComment(Connection conn) throws SQLClientInfoException {
        String clientInfoComment = this.clientInfo.entrySet().stream().map(e2 -> e2.getKey() + "=" + e2.getValue()).collect(Collectors.joining(", "));
        try {
            conn.unwrap(JdbcConnection.class).setStatementComment(clientInfoComment);
        }
        catch (SQLException e3) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(e3);
        }
    }
}

