/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Constants;
import com.mysql.cj.Messages;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.protocol.OutputStreamWatcher;
import com.mysql.cj.protocol.WatchableOutputStream;
import com.mysql.cj.protocol.WatchableStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Blob
implements java.sql.Blob,
OutputStreamWatcher {
    private byte[] binaryData = null;
    private boolean isClosed = false;
    private ExceptionInterceptor exceptionInterceptor;
    private final Lock lock = new ReentrantLock();

    Blob(ExceptionInterceptor exceptionInterceptor) {
        this.setBinaryData(Constants.EMPTY_BYTE_ARRAY);
        this.exceptionInterceptor = exceptionInterceptor;
    }

    public Blob(byte[] data, ExceptionInterceptor exceptionInterceptor) {
        this.setBinaryData(data);
        this.exceptionInterceptor = exceptionInterceptor;
    }

    Blob(byte[] data, ResultSetInternalMethods creatorResultSetToSet, int columnIndexToSet) {
        this.setBinaryData(data);
    }

    private byte[] getBinaryData() {
        this.lock.lock();
        try {
            byte[] byArray = this.binaryData;
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getBinaryData());
                return byteArrayInputStream;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                if (pos < 1L) {
                    throw SQLError.createSQLException(Messages.getString("Blob.2"), "S1009", this.exceptionInterceptor);
                }
                if (--pos > (long)this.binaryData.length) {
                    throw SQLError.createSQLException(Messages.getString("Blob.3"), "S1009", this.exceptionInterceptor);
                }
                if (pos + (long)length > (long)this.binaryData.length) {
                    throw SQLError.createSQLException(Messages.getString("Blob.4"), "S1009", this.exceptionInterceptor);
                }
                byte[] newData = new byte[length];
                System.arraycopy(this.getBinaryData(), (int)pos, newData, 0, length);
                byte[] byArray = newData;
                return byArray;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    @Override
    public long length() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                long l2 = this.getBinaryData().length;
                return l2;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        try {
            this.lock.lock();
            try {
                throw SQLError.createSQLFeatureNotSupportedException();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                long l2 = this.position(pattern.getBytes(0L, (int)pattern.length()), start);
                return l2;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private void setBinaryData(byte[] newBinaryData) {
        this.lock.lock();
        try {
            this.binaryData = newBinaryData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long indexToWriteAt) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                if (indexToWriteAt < 1L) {
                    throw SQLError.createSQLException(Messages.getString("Blob.0"), "S1009", this.exceptionInterceptor);
                }
                WatchableOutputStream bytesOut = new WatchableOutputStream();
                bytesOut.setWatcher(this);
                if (indexToWriteAt > 0L) {
                    bytesOut.write(this.binaryData, 0, (int)(indexToWriteAt - 1L));
                }
                WatchableOutputStream watchableOutputStream = bytesOut;
                return watchableOutputStream;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long writeAt, byte[] bytes) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                int n2 = this.setBytes(writeAt, bytes, 0, bytes.length);
                return n2;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                OutputStream bytesOut = this.setBinaryStream(writeAt);
                try {
                    bytesOut.write(bytes, offset, length);
                }
                catch (IOException ioEx) {
                    SQLException sqlEx = SQLError.createSQLException(Messages.getString("Blob.1"), "S1000", this.exceptionInterceptor);
                    sqlEx.initCause(ioEx);
                    throw sqlEx;
                }
                finally {
                    try {
                        bytesOut.close();
                    }
                    catch (IOException iOException) {}
                }
                int n2 = length;
                return n2;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    public void streamClosed(byte[] byteData) {
        this.lock.lock();
        try {
            this.binaryData = byteData;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void streamClosed(WatchableStream out) {
        this.lock.lock();
        try {
            int streamSize = out.size();
            if (streamSize < this.binaryData.length) {
                out.write(this.binaryData, streamSize, this.binaryData.length - streamSize);
            }
            this.binaryData = out.toByteArray();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long len) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                if (len < 0L) {
                    throw SQLError.createSQLException(Messages.getString("Blob.5"), "S1009", this.exceptionInterceptor);
                }
                if (len > (long)this.binaryData.length) {
                    throw SQLError.createSQLException(Messages.getString("Blob.6"), "S1009", this.exceptionInterceptor);
                }
                byte[] newData = new byte[(int)len];
                System.arraycopy(this.getBinaryData(), 0, newData, 0, (int)len);
                this.binaryData = newData;
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    @Override
    public void free() throws SQLException {
        try {
            this.lock.lock();
            try {
                this.binaryData = null;
                this.isClosed = true;
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            this.lock.lock();
            try {
                this.checkClosed();
                if (pos < 1L) {
                    throw SQLError.createSQLException(Messages.getString("Blob.2"), "S1009", this.exceptionInterceptor);
                }
                if (--pos > (long)this.binaryData.length) {
                    throw SQLError.createSQLException(Messages.getString("Blob.6"), "S1009", this.exceptionInterceptor);
                }
                if (pos + length > (long)this.binaryData.length) {
                    throw SQLError.createSQLException(Messages.getString("Blob.4"), "S1009", this.exceptionInterceptor);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getBinaryData(), (int)pos, (int)length);
                return byteArrayInputStream;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    private void checkClosed() throws SQLException {
        this.lock.lock();
        try {
            if (this.isClosed) {
                throw SQLError.createSQLException(Messages.getString("Blob.7"), "S1009", this.exceptionInterceptor);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

