/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.callback;

import com.mysql.cj.Messages;
import com.mysql.cj.callback.MysqlCallback;
import com.mysql.cj.callback.MysqlCallbackHandler;
import com.mysql.cj.callback.OpenidConnectAuthenticationCallback;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class OpenidConnectIdTokenFromFileCallbackHandler
implements MysqlCallbackHandler {
    private static final int ID_TOKEN_SIZE_LIMIT = 10240;

    @Override
    public void handle(MysqlCallback cb) {
        if (!OpenidConnectAuthenticationCallback.class.isAssignableFrom(cb.getClass())) {
            return;
        }
        OpenidConnectAuthenticationCallback openidConnectAuthCallback = (OpenidConnectAuthenticationCallback)cb;
        String idTokenFileName = openidConnectAuthCallback.getConnProperty(PropertyKey.idTokenFile);
        if (StringUtils.isNullOrEmpty(idTokenFileName)) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("AuthenticationOpenidConnect.MissingIdTokenFileOption"));
        }
        File idTokenFile = new File(idTokenFileName);
        if (!idTokenFile.exists() || !idTokenFile.isFile()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("AuthenticationOpenidConnect.FailReadIdTokenFile"));
        }
        if (idTokenFile.length() > 10240L) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("AuthenticationOpenidConnect.InvalidIdTokenFile"));
        }
        try {
            byte[] idToken = Files.readAllBytes(idTokenFile.toPath());
            openidConnectAuthCallback.setIdentityToken(idToken);
        }
        catch (IOException e2) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("AuthenticationOpenidConnect.FailReadIdTokenFile"));
        }
    }
}

