/*
 * Decompiled with CFR 0.152.
 */
package com.logicalobjects.jlicense.util.security;

import com.logicalobjects.jlicense.util.security.EncryptionException;
import java.nio.charset.StandardCharsets;
import java.security.spec.KeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class CryptUtil {
    private static final String DES_ENCRYPTION_SCHEME = "DES";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;
    private static final String UNICODE_FORMAT = "UTF8";

    public CryptUtil(String encryptionKey) throws EncryptionException {
        if (encryptionKey == null) {
            throw new IllegalArgumentException("encryption key was null");
        }
        try {
            String key = encryptionKey;
            byte[] keyAsBytes = key.getBytes(UNICODE_FORMAT);
            this.keySpec = new DESKeySpec(keyAsBytes);
            this.keyFactory = SecretKeyFactory.getInstance(DES_ENCRYPTION_SCHEME);
            this.cipher = Cipher.getInstance(DES_ENCRYPTION_SCHEME);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new EncryptionException(e2);
        }
    }

    public String encrypt(String unencryptedString) throws EncryptionException {
        if (unencryptedString == null || unencryptedString.trim().length() == 0) {
            throw new IllegalArgumentException("unencrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(1, key);
            byte[] cleartext = unencryptedString.getBytes(UNICODE_FORMAT);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return new String(Base64.getMimeEncoder().encode(ciphertext), StandardCharsets.UTF_8);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new EncryptionException(e2);
        }
    }

    public String decrypt(String encryptedString) throws EncryptionException {
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("encrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, key);
            byte[] cleartext = Base64.getMimeDecoder().decode(encryptedString);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return CryptUtil.bytes2String(ciphertext);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new EncryptionException(e2);
        }
    }

    private static String bytes2String(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            stringBuffer.append((char)bytes[i2]);
        }
        return stringBuffer.toString();
    }
}

