/*
 * Decompiled with CFR 0.152.
 */
package com.logicalobjects.jlicense.util;

import com.logicalobjects.jlicense.license.SystemInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class PrintSysinfo
extends Properties {
    private static final long serialVersionUID = 1L;

    public PrintSysinfo() {
        this.put("os.name", System.getProperty("os.name"));
        try {
            this.put("network.ip", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        this.put("network.mac", SystemInfo.getMAC());
        this.put("computerName", SystemInfo.getComputerName());
        this.put("mb.serial", SystemInfo.getBaseboardSerialNumber());
        this.put("cpu.id", SystemInfo.getCpuID());
        this.put("system.serial", SystemInfo.getComputerSerialNumber());
        try {
            this.put("sid", SystemInfo.getSID());
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuffer sb = new StringBuffer("\n\n");
        sb.append(df.format(new Date()));
        sb.append(":\n");
        sb.append("sid: " + SystemInfo.getSID());
        sb.append("\nCPU id: " + SystemInfo.getCpuID());
        sb.append("\ncomputer serial: " + SystemInfo.getComputerSerialNumber());
        sb.append("\nbaseboard serial: " + SystemInfo.getBaseboardSerialNumber());
        System.out.println(sb.toString());
    }
}

