/*
 * Decompiled with CFR 0.152.
 */
package com.logicalobjects.jlicense.license;

import com.logicalobjects.jlicense.util.security.CryptUtil;
import java.util.Map;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class SystemInfo {
    private static oshi.SystemInfo si = new oshi.SystemInfo();
    private static HardwareAbstractionLayer hal = si.getHardware();
    private static CryptUtil crypt;

    static String getCpuInfo() {
        try {
            CentralProcessor cpu = hal.getProcessor();
            return cpu.getProcessorIdentifier().getIdentifier();
        }
        catch (Exception t2) {
            return null;
        }
    }

    public static String getCpuID() {
        try {
            CentralProcessor cpu = hal.getProcessor();
            return cpu.getProcessorIdentifier().getProcessorID();
        }
        catch (Exception t2) {
            return null;
        }
    }

    public static String getComputerSerialNumber() {
        try {
            return hal.getComputerSystem().getSerialNumber();
        }
        catch (Exception t2) {
            return null;
        }
    }

    public static String getComputerName() {
        try {
            Map<String, String> env = System.getenv();
            if (env.containsKey("COMPUTERNAME")) {
                return env.get("COMPUTERNAME");
            }
            if (env.containsKey("HOSTNAME")) {
                return env.get("HOSTNAME");
            }
            return "Unknown Computer";
        }
        catch (Exception t2) {
            return null;
        }
    }

    public static String getBaseboardSerialNumber() {
        return hal.getComputerSystem().getBaseboard().getSerialNumber();
    }

    public static String getMAC() {
        try {
            if (hal.getNetworkIFs() != null && !hal.getNetworkIFs().isEmpty()) {
                return hal.getNetworkIFs().get(0).getMacaddr();
            }
            return null;
        }
        catch (Exception t2) {
            return null;
        }
    }

    public static String getSID() {
        StringBuffer sb = new StringBuffer(SystemInfo.getCpuID() != null ? SystemInfo.getCpuID() : "");
        sb.append("|");
        sb.append(SystemInfo.getComputerSerialNumber() != null ? SystemInfo.getComputerSerialNumber() : "");
        sb.append("|");
        sb.append(SystemInfo.getBaseboardSerialNumber() != null ? SystemInfo.getBaseboardSerialNumber() : "");
        try {
            if (crypt != null) {
                return crypt.encrypt(sb.toString());
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("SID: " + SystemInfo.getSID());
        System.out.println("Computer Name: " + SystemInfo.getComputerName());
    }

    static {
        try {
            crypt = new CryptUtil("8GXJT9b2K4YRZTFfw^*ZHmwdKjj-QL*265!7ewYzQ=shmb+9utNa7w_Y8rgF%HL4*K=*+85z6sC8tPzE7V$Xg7gMm5cx?*hdpRfEreaYuy_kg-%72G29dg5^+_jFTd8A*x%dUgNqG4Mbt?AFPrt&SdZMFJfnm?8S#m4Y!&J9jNcw#DshUHPfHv!$JCrJDvrrp7BFk#wC8e3k9pHcJqRn_%Uc+@tWyn!LMpKWh4#%q%meDje$3p$$k+XFwQYWycJz");
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }
}

