/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class TimeDiff {
    private TimeDiff() {
        throw new IllegalStateException("Utility class");
    }

    public static long getTimeDifference(Date d1, Date d2, TimeField field) {
        return TimeDiff.getTimeDifference(d1, d2)[field.ordinal()];
    }

    public static long[] getTimeDifference(long t1, long t2) {
        long[] result = new long[5];
        long diff = t2 - t1;
        int ONE_DAY = 86400000;
        int ONE_HOUR = 3600000;
        int ONE_MINUTE = 60000;
        int ONE_SECOND = 1000;
        long d2 = diff / 86400000L;
        long h2 = (diff %= 86400000L) / 3600000L;
        long m2 = (diff %= 3600000L) / 60000L;
        long s2 = (diff %= 60000L) / 1000L;
        long ms = diff % 1000L;
        result[0] = d2;
        result[1] = h2;
        result[2] = m2;
        result[3] = s2;
        result[4] = ms;
        return result;
    }

    public static long[] getTimeDifference(Date d1, Date d2) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(d1);
        long t1 = cal.getTimeInMillis();
        cal.setTime(d2);
        long t2 = cal.getTimeInMillis();
        return TimeDiff.getTimeDifference(t1, t2);
    }

    public static String printDuration(Date start, Date stop) {
        return TimeDiff.printDuration(Math.abs(start.getTime() - stop.getTime()));
    }

    public static String printDuration(long diffMillis) {
        Duration duration = Duration.of(diffMillis, ChronoUnit.MILLIS);
        long millis = duration.toMillis() % 1000L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.toMillis() / 1000L % 60L;
        long hours = duration.toMinutes() / 60L;
        StringBuilder out = new StringBuilder();
        if (hours > 0L) {
            out.append(StringUtils.leftPad(Long.toString(hours), 2, '0'));
            out.append(":");
        }
        if (minutes > 0L || hours > 0L) {
            out.append(StringUtils.leftPad(Long.toString(minutes), 2, '0'));
            out.append(":");
        }
        out.append(StringUtils.leftPad(Long.toString(seconds), 2, '0'));
        out.append(".");
        out.append(StringUtils.leftPad(Long.toString(millis), 3, '0'));
        return out.toString();
    }

    public static enum TimeField {
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }
}

