/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    protected static Logger log = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        return df.format(date);
    }

    public static String formatWithMillis(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        return df.format(date);
    }

    public static Date parse(String formattedDate) {
        String[] possibleFormats;
        Date date = null;
        String[] stringArray = possibleFormats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS Z", "yyyy-MM-dd HH:mm:ss.SS Z", "yyyy-MM-dd HH:mm:ss Z", YYYY_MM_DD};
        int n2 = possibleFormats.length;
        int n3 = 0;
        while (n3 < n2) {
            String format = stringArray[n3];
            try {
                SimpleDateFormat df = new SimpleDateFormat(format);
                date = df.parse(formattedDate);
                if (date != null) {
                    break;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            ++n3;
        }
        if (date == null) {
            log.error("Unparseable date {}", (Object)formattedDate);
        }
        return date;
    }

    public static Date truncateToDay(Date date) {
        Instant instant = date.toInstant();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        ZonedDateTime truncatedZonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS);
        Instant truncatedInstant = truncatedZonedDateTime.toInstant();
        return Date.from(truncatedInstant);
    }
}

