/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;

public class SqlUtil {
    private SqlUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String doubleQuotes(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("'", "''");
    }

    public static String doubleBackslashes(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\");
    }

    public static String doubleQuotesAndBackslashes(String input) {
        return SqlUtil.doubleBackslashes(SqlUtil.doubleQuotes(input));
    }

    public static Date getColumnDateValue(ResultSet resultSet, int column) throws SQLException {
        Date date;
        if (resultSet.getObject(column) instanceof Timestamp) {
            date = resultSet.getTimestamp(column);
        } else {
            Object object = resultSet.getObject(column);
            if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                date = Timestamp.valueOf(localDateTime);
            } else {
                date = resultSet.getDate(column);
            }
        }
        return date;
    }
}

