/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.servlet;

import com.logicaldoc.util.servlet.BytesServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;

public class MockServletRequest
implements HttpServletRequest {
    private static final String CONTENT_LENGTH = "Content-Length";
    private HttpSession session;
    private String code;
    private String pathInfo = "/";
    private String method = "GET";
    private String contextPath = "";
    private String requestURI;
    private String body;
    private InputStream payload;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public MockServletRequest() {
        this.setUserAgent("Mozilla");
    }

    public MockServletRequest(HttpSession session) {
        this();
        this.session = session;
    }

    public MockServletRequest(HttpSession session, String userAgent) {
        this.session = session;
        this.setUserAgent(userAgent);
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getUserAgent() {
        return this.headers.get("User-Agent");
    }

    public void setUserAgent(String userAgent) {
        this.headers.put("User-Agent", userAgent);
    }

    public void setContentType(String contentType) {
        this.headers.put("Content-Type", contentType);
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Object getAttribute(String arg0) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        return this.headers.get(CONTENT_LENGTH) != null ? Integer.parseInt(this.headers.get(CONTENT_LENGTH)) : 0;
    }

    public void setContentLength(int length) {
        this.headers.put(CONTENT_LENGTH, Integer.toString(length));
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body != null) {
            return new BytesServletInputStream(this.body.getBytes(StandardCharsets.UTF_8));
        }
        if (this.payload != null) {
            return new ServletInputStream(){

                public int read() throws IOException {
                    return MockServletRequest.this.payload.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener arg0) {
                }
            };
        }
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String param) {
        return this.parameters.get(param);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String param) {
        String[] values = new String[]{};
        if (StringUtils.isNotEmpty(this.parameters.get(param))) {
            values = this.parameters.get(param).split("\\,");
        }
        return values;
    }

    public String getProtocol() {
        return null;
    }

    public BufferedReader getReader() throws IOException {
        if (this.body != null) {
            return new BufferedReader(new StringReader(this.body));
        }
        return null;
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
    }

    public void setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public void setCharacterEncoding(String encofing) throws UnsupportedEncodingException {
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public Enumeration getHeaders(String arg0) {
        return null;
    }

    public int getIntHeader(String arg0) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean arg0) {
        return this.session;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
        this.setContentLength(body.getBytes(StandardCharsets.UTF_8).length);
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public InputStream getPayload() {
        return this.payload;
    }

    public void setPayload(InputStream payload) {
        this.payload = payload;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return null;
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return false;
    }

    public String changeSessionId() {
        return null;
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return new ArrayList<Part>();
    }

    public void login(String arg0, String arg1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return null;
    }
}

