/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.servlet;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class BytesServletInputStream
extends ServletInputStream {
    private byte[] myBytes;
    private int lastIndexRetrieved = -1;
    private ReadListener readListener = null;

    public BytesServletInputStream(byte[] bytes) {
        this.myBytes = bytes;
    }

    public int read() throws IOException {
        if (!this.isFinished()) {
            byte i2 = this.myBytes[this.lastIndexRetrieved + 1];
            ++this.lastIndexRetrieved;
            if (this.isFinished() && this.readListener != null) {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException ex) {
                    this.readListener.onError((Throwable)ex);
                    throw ex;
                }
            }
            return i2;
        }
        return -1;
    }

    public boolean isFinished() {
        return this.lastIndexRetrieved == this.myBytes.length - 1;
    }

    public boolean isReady() {
        return this.isFinished();
    }

    public void setReadListener(ReadListener readListener) {
        this.readListener = readListener;
        if (!this.isFinished()) {
            try {
                readListener.onDataAvailable();
            }
            catch (IOException e2) {
                readListener.onError((Throwable)e2);
            }
        } else {
            try {
                readListener.onAllDataRead();
            }
            catch (IOException e3) {
                readListener.onError((Throwable)e3);
            }
        }
    }
}

