/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.security;

import com.logicaldoc.util.security.PasswordCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.passay.CharacterData;
import org.passay.CharacterOccurrencesRule;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.EnglishSequenceData;
import org.passay.IllegalSequenceRule;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PropertiesMessageResolver;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.SequenceData;
import org.passay.WhitespaceRule;

public class PasswordValidator {
    private org.passay.PasswordValidator validator;

    public PasswordValidator(PasswordCriteria criteria, Properties messages) {
        PropertiesMessageResolver resolver;
        if (messages == null) {
            Properties standardMessages = new Properties();
            try {
                standardMessages.load(this.getClass().getClassLoader().getResourceAsStream("/passay.properties"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            resolver = new PropertiesMessageResolver(standardMessages);
        } else {
            resolver = new PropertiesMessageResolver(messages);
        }
        this.validator = new org.passay.PasswordValidator((MessageResolver)resolver, new Rule[]{new LengthRule(criteria.getMinLength(), 255), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, criteria.getMinUppercaseChars()), new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, criteria.getMinLowercaseChars()), new CharacterRule((CharacterData)EnglishCharacterData.Digit, criteria.getMinDigits()), new CharacterRule((CharacterData)EnglishCharacterData.Special, criteria.getMinSpecialChars()), new CharacterOccurrencesRule(criteria.getMaxOccurrences()), new IllegalSequenceRule((SequenceData)EnglishSequenceData.Alphabetical, criteria.getMaxSequenceSize(), false), new IllegalSequenceRule((SequenceData)EnglishSequenceData.Numerical, criteria.getMaxSequenceSize(), false), new IllegalSequenceRule((SequenceData)EnglishSequenceData.USQwerty, criteria.getMaxSequenceSize(), false), new WhitespaceRule()});
    }

    public List<String> validate(String password) {
        RuleResult result = this.validator.validate(new PasswordData(password));
        if (!result.isValid()) {
            return this.validator.getMessages(result);
        }
        return new ArrayList<String>();
    }
}

