/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.security;

import com.logicaldoc.util.security.PasswordCriteria;
import com.logicaldoc.util.security.PasswordValidator;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PasswordGenerator {
    private static final String CHAR_LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final String CHAR_UPPER = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String NUMBER = "0123456789";
    private static final String OTHER_CHAR = "!@#$%&*()_+-=[]?{}/;,.";
    private static final String PASSWORD_ALLOW_BASE = "abcdefghijklmnopqrstuvwxyz" + CHAR_UPPER + "0123456789!@#$%&*()_+-=[]?{}/;,.";
    private static final String PASSWORD_ALLOW_BASE_SHUFFLE;
    private static final String PASSWORD_ALLOW;
    private static SecureRandom random;

    static {
        PASSWORD_ALLOW = PASSWORD_ALLOW_BASE_SHUFFLE = PasswordGenerator.shuffleString(PASSWORD_ALLOW_BASE);
        random = new SecureRandom();
    }

    private PasswordGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static void main(String[] args) {
        System.out.format("String for password \t\t\t: %s%n", PASSWORD_ALLOW_BASE);
        System.out.format("String for password (shuffle) \t: %s%n%n", PASSWORD_ALLOW);
        int i2 = 0;
        while (i2 < 5) {
            System.out.println("password: " + PasswordGenerator.generate(16, 2, 2, 1, 1, 4, 2));
            System.out.println("\n");
            ++i2;
        }
    }

    private static String generate(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(length);
        int i2 = 0;
        while (i2 < length) {
            int rndCharAt = random.nextInt(PASSWORD_ALLOW.length());
            char rndChar = PASSWORD_ALLOW.charAt(rndCharAt);
            sb.append(rndChar);
            ++i2;
        }
        return sb.toString();
    }

    public static String shuffleString(String string) {
        List<String> letters = Arrays.asList(string.split(""));
        Collections.shuffle(letters);
        return letters.stream().collect(Collectors.joining());
    }

    public static String generate(int minLength, int uppercaseChars, int lowercaseChars, int digits, int specialChars, int maxSequenceSize, int maxOccurrences) {
        if (minLength < 5) {
            throw new IllegalArgumentException(String.format("Cannot generate password with less than %d chars", minLength));
        }
        PasswordCriteria criteria = new PasswordCriteria(minLength, uppercaseChars, lowercaseChars, digits, specialChars);
        criteria.setMaxSequenceSize(maxSequenceSize);
        criteria.setMaxOccurrences(maxOccurrences);
        PasswordValidator validator = new PasswordValidator(criteria, null);
        String pswd = "";
        boolean valid = false;
        int i2 = 0;
        while (!valid) {
            pswd = PasswordGenerator.generate(minLength);
            valid = validator.validate(pswd).isEmpty();
            if (++i2 <= 15) continue;
            i2 = 0;
            ++minLength;
        }
        return pswd;
    }
}

