/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.security;

import com.logicaldoc.util.security.EasyX509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasySSLSocketFactory
extends SSLSocketFactory {
    private static Logger log = LoggerFactory.getLogger(EasySSLSocketFactory.class);
    private SSLSocketFactory factory;

    public EasySSLSocketFactory() {
        try {
            SSLContext sslcontent = SSLContext.getInstance("TLS");
            sslcontent.init(null, new TrustManager[]{new EasyX509TrustManager()}, new SecureRandom());
            this.factory = sslcontent.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e2) {
            log.debug(e2.getMessage());
        }
    }

    public static SocketFactory getDefault() {
        return new EasySSLSocketFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String s2, int i2, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s2, i2, flag);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i2, InetAddress inaddr2, int j2) throws IOException {
        return this.factory.createSocket(inaddr, i2, inaddr2, j2);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i2) throws IOException {
        return this.factory.createSocket(inaddr, i2);
    }

    @Override
    public Socket createSocket(String s2, int i2, InetAddress inaddr, int j2) throws IOException {
        return this.factory.createSocket(s2, i2, inaddr, j2);
    }

    @Override
    public Socket createSocket(String s2, int i2) throws IOException {
        return this.factory.createSocket(s2, i2);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

