/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.plugin;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.http.UrlUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.DefaultPluginRegistry;
import com.logicaldoc.util.plugin.PluginException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.JpfException;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.util.ExtendedProperties;

public abstract class PluginRegistry {
    protected PluginManager manager = null;
    private static PluginRegistry instance;
    private boolean restartRequired = false;

    public static PluginRegistry getInstance() {
        if (instance == null) {
            String pluginregistry = null;
            try {
                ContextProperties config = new ContextProperties();
                pluginregistry = config.getProperty("plugin.registry");
            }
            catch (IOException e1) {
                System.err.println(e1.getMessage());
            }
            if (StringUtils.isEmpty(pluginregistry)) {
                pluginregistry = DefaultPluginRegistry.class.getName();
            }
            try {
                System.out.println("Instantiate concrete PluginRegistry: " + pluginregistry);
                instance = (PluginRegistry)Class.forName(pluginregistry).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
            }
        }
        return instance;
    }

    public void init(String pluginsDir) throws PluginException {
        List<PluginManager.PluginLocation> pluginLocations;
        ExtendedProperties properties = new ExtendedProperties();
        properties.put((Object)"com.logicaldoc.util.ShadingPathResolver.unpackMode", (Object)"smart");
        ObjectFactory pluginObjectFactory = ObjectFactory.newInstance((ExtendedProperties)properties);
        this.manager = pluginObjectFactory.createManager();
        try {
            pluginLocations = this.locatePlugins(pluginsDir);
        }
        catch (Exception e2) {
            throw new PluginException("Error locating plugins", e2);
        }
        if (!pluginLocations.isEmpty()) {
            Map plugins = null;
            try {
                PluginManager.PluginLocation[] pLocations = pluginLocations.toArray(new PluginManager.PluginLocation[0]);
                plugins = this.manager.publishPlugins(pLocations);
            }
            catch (JpfException e3) {
                throw new PluginException("Error publishing plugins", e3);
            }
            System.out.println("Succesfully registered " + plugins.size() + " plugins");
            this.initPlugins(plugins);
        }
    }

    protected abstract void initPlugins(Map<String, Identity> var1);

    protected List<PluginManager.PluginLocation> locatePlugins(String pluginsDirectoryPath) throws IOException {
        List<String> pluginsList;
        LinkedList<PluginManager.PluginLocation> pluginLocations = new LinkedList<PluginManager.PluginLocation>();
        File pluginDirectory = new File(pluginsDirectoryPath);
        System.out.println("Searching for plugins in " + pluginDirectory.getAbsolutePath());
        FilenameFilter filter = (dir, fileName) -> fileName.endsWith(".jar") && fileName.contains("-plugin");
        if (!pluginDirectory.isDirectory()) {
            System.out.println("No Plugins Found");
        }
        if (!(pluginsList = Arrays.asList(pluginDirectory.list(filter))).isEmpty()) {
            for (String pluginFilename : pluginsList) {
                File pluginZIPFile = new File(pluginDirectory.getPath() + "/" + pluginFilename);
                if (!pluginZIPFile.exists()) {
                    throw new IOException("file not Found:" + pluginZIPFile.getAbsolutePath());
                }
                try {
                    final URL manifestURL = UrlUtil.toURL("jar:file:" + pluginZIPFile.getAbsolutePath() + "!/plugin.xml");
                    final URL contextURL = pluginZIPFile.toURI().toURL();
                    System.out.println("Found plugin file: " + pluginZIPFile.getName());
                    pluginLocations.add(new PluginManager.PluginLocation(){

                        public URL getManifestLocation() {
                            return manifestURL;
                        }

                        public URL getContextLocation() {
                            return contextURL;
                        }
                    });
                }
                catch (MalformedURLException | URISyntaxException e2) {
                    System.err.println(e2.getMessage());
                }
            }
        } else {
            throw new IOException("Unable to access Plugins directory: " + pluginDirectory.getAbsolutePath());
        }
        return pluginLocations;
    }

    public PluginManager getManager() {
        return this.manager;
    }

    public Collection<Extension> getExtensions(String pluginId, String extensionPoint) {
        Collection<Object> exts = new ArrayList<Extension>();
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            if (registry != null) {
                PluginDescriptor descriptor = registry.getManager().getRegistry().getPluginDescriptor(pluginId);
                ExtensionPoint dbinitExtPoint = registry.getManager().getRegistry().getExtensionPoint(descriptor.getId(), extensionPoint);
                exts = dbinitExtPoint.getConnectedExtensions();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exts;
    }

    public List<Extension> getSortedExtensions(String pluginId, String extensionPoint, String sortingParameter) {
        Collection<Extension> exts = this.getExtensions(pluginId, extensionPoint);
        ArrayList<Extension> sortedExts = new ArrayList<Extension>();
        for (Extension extension : exts) {
            sortedExts.add(extension);
        }
        Collections.sort(sortedExts, (e1, e2) -> {
            int position2;
            int position1;
            String sortParam = "position";
            if (StringUtils.isNotEmpty(sortingParameter)) {
                sortParam = sortingParameter;
            }
            if ((position1 = Integer.parseInt(e1.getParameter(sortParam).valueAsString())) < (position2 = Integer.parseInt(e2.getParameter(sortParam).valueAsString()))) {
                return -1;
            }
            if (position1 > position2) {
                return 1;
            }
            return 0;
        });
        return sortedExts;
    }

    public Collection<PluginDescriptor> getPlugins() {
        PluginRegistry registry = PluginRegistry.getInstance();
        if (registry != null) {
            return registry.getManager().getRegistry().getPluginDescriptors();
        }
        return new ArrayList<PluginDescriptor>();
    }

    public PluginDescriptor getPlugin(String pluginId) {
        PluginRegistry registry = PluginRegistry.getInstance();
        if (registry != null) {
            return registry.getManager().getRegistry().getPluginDescriptor(pluginId);
        }
        return null;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired() {
        this.restartRequired = true;
    }

    public static File getPluginHome(String pluginName) {
        File root;
        File userDir = new File((root = PluginRegistry.getPluginsDir()) != null ? root : new File(""), pluginName);
        if (!FileUtil.isInsideFolder(root, userDir)) {
            throw new SecurityException(String.format("Plugin %s non inside plugin home %s", pluginName, root != null ? root.getPath() : ""));
        }
        if (!userDir.exists()) {
            try {
                FileUtils.forceMkdir(userDir);
            }
            catch (IOException e2) {
                return null;
            }
        }
        return userDir;
    }

    public static File getPluginsDir() {
        File pluginsPath = null;
        try {
            ContextProperties conf = new ContextProperties();
            pluginsPath = new File(conf.getProperty("conf.plugindir"));
        }
        catch (IOException conf) {
            // empty catch block
        }
        try {
            FileUtils.forceMkdir(pluginsPath);
        }
        catch (IOException e2) {
            return new File(".");
        }
        return pluginsPath;
    }

    public static File getPluginResource(String pluginName, String path) {
        File root;
        File resource = new File(((root = PluginRegistry.getPluginHome(pluginName)) != null ? root.getPath() : "") + "/" + path);
        if (!FileUtil.isInsideFolder(root, resource)) {
            throw new SecurityException(String.format("Resource %s non inside plugin home %s", resource.getPath(), root != null ? root.getPath() : ""));
        }
        if (!resource.exists() && !path.contains(".")) {
            try {
                FileUtils.forceMkdir(resource);
            }
            catch (IOException e2) {
                return null;
            }
        }
        return resource;
    }
}

