/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.plugin;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.LogConfigurator;
import com.logicaldoc.util.config.WebConfigurator;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.plugin.PluginRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Properties;
import org.java.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalDOCPlugin
extends Plugin {
    private static Logger logger = LoggerFactory.getLogger(LogicalDOCPlugin.class);
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private Properties data = new Properties();

    protected void doStart() throws PluginException {
        try {
            this.loadData();
            if (this.isInstallNeeded()) {
                this.install();
                boolean created = this.getInstallMark().createNewFile();
                if (created) {
                    logger.info("Plugin {} installed", (Object)this.getDescriptor().getId());
                } else {
                    logger.error("Cannot install plugin {}", (Object)this.getDescriptor().getId());
                }
            }
            this.onStart();
            this.saveData();
        }
        catch (IOException e2) {
            throw new PluginException(e2);
        }
    }

    private File getInstallMark() {
        String id = null;
        try {
            ContextProperties conf = new ContextProperties();
            id = conf.getProperty("id");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File(this.resolveDataPath("install-" + id).toString());
    }

    protected boolean isInstallNeeded() {
        return !this.getInstallMark().exists();
    }

    protected void loadData() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fis = new FileInputStream(this.resolveDataFile());){
            this.data.load(fis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void saveData() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream fos = new FileOutputStream(this.resolveDataFile());){
            this.data.store(fos, "");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getPluginPath() {
        String path = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    public File resolveDataPath(String relativePath) {
        return new File(this.getDataDirectory(), relativePath);
    }

    private File resolveDataFile() {
        File file = new File(this.getDataDirectory(), PLUGIN_PROPERTIES);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new IOException("Cannot create new file " + file.getAbsolutePath());
                }
            }
            catch (IOException e2) {
                logger.error(e2.getMessage());
            }
        }
        return file;
    }

    public File getDataDirectory() {
        String pluginName = this.getPluginName();
        return PluginRegistry.getPluginHome(pluginName);
    }

    protected String getPluginName() {
        return this.getDescriptor().getUniqueId().substring(0, this.getDescriptor().getUniqueId().lastIndexOf(64));
    }

    public void install() throws PluginException {
    }

    protected void onStart() throws PluginException {
    }

    protected void setRestartRequired() {
        if (this.getDescriptor() != null) {
            System.out.println("Plugin " + this.getDescriptor().getId() + " requires a restart");
        }
        PluginRegistry.getInstance().setRestartRequired();
    }

    protected void doStop() throws PluginException {
    }

    public Properties getData() {
        return this.data;
    }

    public String getProperty(String name) {
        return this.data.getProperty(name);
    }

    protected void addScheduling(String taskName) {
        try {
            ContextProperties pbean = new ContextProperties();
            pbean.setProperty("schedule.cron." + taskName, "00 00 00 1 * ?");
            pbean.setProperty("schedule.length." + taskName, "-1");
            pbean.setProperty("schedule.enabled." + taskName, "true");
            pbean.setProperty("schedule.mode." + taskName, "simple");
            pbean.setProperty("schedule.interval." + taskName, "1800000");
            pbean.setProperty("schedule.delay." + taskName, "1800000");
            pbean.write();
        }
        catch (IOException e2) {
            logger.warn("Cannot add task {} to the configuration", (Object)taskName);
        }
    }

    protected void addLogger(String logger, boolean additivity, String level, String appender) {
        LogConfigurator logging = new LogConfigurator();
        logging.addTextAppender(appender);
        logging.write();
        String appenderWeb = appender + "_WEB";
        logging.addHtmlAppender(appenderWeb);
        logging.write();
        logging.setLogger(logger, additivity, level, List.of(appender, appenderWeb));
        logging.write();
    }

    protected void addLogger(String logger, String appender) {
        LogConfigurator logging = new LogConfigurator();
        logging.addTextAppender(appender);
        logging.write();
        String appenderWeb = appender + "_WEB";
        logging.addHtmlAppender(appenderWeb);
        logging.write();
        logging.addLogger(logger, List.of(appender, appenderWeb));
        logging.write();
    }

    protected void addServlet(String name, String servletClass, String mapping) {
        this.addServlet(name, servletClass, mapping, null);
    }

    protected void addServlet(String name, String servletClass, String mapping, Integer loadOnStartup) {
        File dest = new File(this.getPluginPath());
        dest = dest.getParentFile().getParentFile();
        WebConfigurator config = new WebConfigurator(dest.getPath() + "/web.xml");
        if (loadOnStartup != null) {
            config.addServlet(name, servletClass, loadOnStartup);
        } else {
            config.addServlet(name, servletClass);
        }
        config.writeXMLDoc();
        if (mapping != null) {
            config.addServletMapping(name, mapping);
            config.writeXMLDoc();
        }
    }
}

