/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.junit;

import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.time.Pause;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.io.FilenameUtils;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.CollectionUtils;

public abstract class AbstractTestCase {
    private static Logger log = LoggerFactory.getLogger(AbstractTestCase.class);
    private static final String USER_HOME = "user.home";
    protected ApplicationContext context;
    protected File tempDir = new File("target/tmp");
    private String userHome = System.getProperty("user.home");

    @Before
    public void setUp() throws IOException, SQLException, PluginException {
        this.loadDevelSettings();
        this.updateUserHome();
        this.createTestDirs();
        this.initializePlugins();
        this.context = this.buildApplicationContext();
        this.createDatabase();
    }

    @After
    public void tearDown() throws SQLException {
        try {
            this.destroyDatabase();
            if (this.context != null) {
                ((AbstractApplicationContext)this.context).close();
            }
        }
        finally {
            this.restoreUserHome();
        }
    }

    private void updateUserHome() {
        System.setProperty(USER_HOME, this.tempDir.getPath());
    }

    protected ApplicationContext buildApplicationContext() {
        return new ClassPathXmlApplicationContext("/context.xml");
    }

    protected List<String> getPluginArchives() {
        return new ArrayList<String>();
    }

    protected void initializePlugins() throws IOException, PluginException {
        List<String> pluginArchives = this.getPluginArchives();
        if (CollectionUtils.isEmpty(pluginArchives)) {
            return;
        }
        File pluginsDir = new File("target/tests-plugins");
        pluginsDir.mkdir();
        for (String pluginArchive : pluginArchives) {
            File pluginFile = new File(pluginsDir, FilenameUtils.getName(pluginArchive));
            FileUtil.copyResource(pluginArchive, pluginFile);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        registry.init(pluginsDir.getAbsolutePath());
    }

    protected List<String> getDatabaseScripts() {
        return new ArrayList<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDatabase() throws SQLException, IOException {
        List<String> databaseScripts = this.getDatabaseScripts();
        if (CollectionUtils.isEmpty(databaseScripts)) {
            return;
        }
        for (String sqlScript : databaseScripts) {
            File sqlFile = File.createTempFile("sql", ".sql");
            FileUtil.copyResource(sqlScript, sqlFile);
            try {
                Throwable throwable = null;
                Object var6_10 = null;
                try (Connection con = this.getConnection();){
                    SqlFile sql = new SqlFile(sqlFile, "Cp1252", false);
                    sql.setConnection(con);
                    try {
                        log.info("Running script {}", (Object)sqlScript);
                        sql.execute();
                    }
                    catch (SqlToolError e2) {
                        throw new SQLException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                FileUtil.delete(sqlFile);
            }
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try {
            Connection con = this.getConnection();
            try {
                try (ResultSet rs = con.createStatement().executeQuery("CALL NOW()");){
                    rs.next();
                    Assert.assertNotNull((Object)rs.getObject(1));
                }
                if (con == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            con.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void loadDevelSettings() throws IOException {
        Properties devSettings = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(new File(this.userHome + "/logicaldoc-dev.properties"));){
            devSettings.load(reader);
            for (Map.Entry<Object, Object> entry : devSettings.entrySet()) {
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createTestDirs() {
        FileUtil.delete(this.tempDir);
        this.tempDir.mkdirs();
    }

    private void restoreUserHome() {
        System.setProperty(USER_HOME, this.userHome);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void destroyDatabase() throws SQLException {
        if (CollectionUtils.isEmpty(this.getDatabaseScripts())) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Connection con = this.getConnection();
            try {
                try (Statement statement = con.createStatement();){
                    statement.execute("shutdown");
                }
                if (con == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            con.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected Connection getConnection() throws SQLException {
        return ((DataSource)this.context.getBean(DataSource.class)).getConnection();
    }

    protected void waiting() throws InterruptedException {
        Pause.doPause(5000L);
    }
}

