/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.Context;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.IOUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil
implements Closeable {
    private static final String ZIP_FILE_S_LOOKS_LIKE_A_ZIP_BOMB_ENTRIES = "Zip file %s looks like a Zip Bomb Attack: can lead to inodes exhaustion of the system and is over the maximum allowed of %d";
    private static final String ZIP_FILE_S_LOOKS_LIKE_A_ZIP_BOMB_SIZE = "Zip file %s looks like a Zip Bomb Attack: the uncompressed data size is over the maximum allowed of %s";
    private String fileNameCharset = "UTF-8";
    protected static Logger log = LoggerFactory.getLogger(ZipUtil.class);
    private int maxEntries = 100000;
    private int maxSize = 0x40000000;
    private double maxCompressionRatio = 30.0;
    private ZipFile zFile;

    public ZipUtil() {
        try {
            this.maxEntries = Context.get().getProperties().getInt("zip.maxentries", 100000);
            this.maxSize = Context.get().getProperties().getInt("zip.maxsize", 1024) * 1024 * 1024;
            this.maxCompressionRatio = Context.get().getProperties().getDouble("zip.maxratio", 30.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ZipUtil(String charset) {
        this();
        this.fileNameCharset = charset;
    }

    public List<ZipEntry> listZipEntries(File zipFile) {
        ArrayList<ZipEntry> files = new ArrayList<ZipEntry>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (java.util.zip.ZipFile archiveFile = new java.util.zip.ZipFile(zipFile);){
                if (zipFile.length() > (long)this.maxSize) {
                    throw new IOException(String.format(ZIP_FILE_S_LOOKS_LIKE_A_ZIP_BOMB_SIZE, zipFile.length(), FileUtil.getDisplaySize(this.maxSize, "en")));
                }
                Enumeration<? extends ZipEntry> e2 = archiveFile.entries();
                while (e2.hasMoreElements()) {
                    ZipEntry zipEntry = e2.nextElement();
                    files.add(zipEntry);
                    if (files.size() <= this.maxEntries) continue;
                    throw new IOException(String.format(ZIP_FILE_S_LOOKS_LIKE_A_ZIP_BOMB_ENTRIES, zipFile.getName(), this.maxEntries));
                }
                files.sort((entry1, entry2) -> entry1.getName().compareTo(entry2.getName()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e3) {
            ZipUtil.logError(e3.getMessage());
        }
        return files;
    }

    public List<String> listEntries(File zipFile) {
        ArrayList<String> files = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile archiveFile = new ZipFile(zipFile);){
                this.setCharset(archiveFile);
                List fileHeaders = archiveFile.getFileHeaders();
                for (FileHeader fileHeader : fileHeaders) {
                    files.add(fileHeader.getFileName());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            ZipUtil.logError(e2.getMessage());
        }
        return files;
    }

    public int unzip(File zipFile, File target) throws IOException {
        return this.unzip(new FileInputStream(zipFile), target);
    }

    public int unzip(InputStream zipStream, File target) throws IOException {
        target.mkdirs();
        int totalSizeArchive = 0;
        int totalEntryArchive = 0;
        byte[] readBuffer = new byte[4096];
        Throwable throwable = null;
        Object var9_8 = null;
        try (net.lingala.zip4j.io.inputstream.ZipInputStream zipInputStream = new net.lingala.zip4j.io.inputstream.ZipInputStream(zipStream);){
            LocalFileHeader localFileHeader;
            while ((localFileHeader = zipInputStream.getNextEntry()) != null) {
                File extractedFile = new File(target, localFileHeader.getFileName());
                if (localFileHeader.isDirectory()) {
                    extractedFile.mkdirs();
                } else {
                    Throwable throwable2 = null;
                    Object var13_16 = null;
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(extractedFile));){
                        int readLen;
                        while ((readLen = zipInputStream.read(readBuffer)) != -1) {
                            ((OutputStream)outputStream).write(readBuffer, 0, readLen);
                            totalSizeArchive += readLen;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                ++totalEntryArchive;
                if (totalSizeArchive > this.maxSize) {
                    throw new IOException(String.format(ZIP_FILE_S_LOOKS_LIKE_A_ZIP_BOMB_SIZE, zipStream, FileUtil.getDisplaySize(this.maxSize, "en")));
                }
                if (totalEntryArchive <= this.maxEntries) continue;
                throw new IOException(String.format(ZIP_FILE_S_LOOKS_LIKE_A_ZIP_BOMB_ENTRIES, zipStream, this.maxEntries));
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return totalEntryArchive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long unzip(InputStream input, String entry, File target) throws IOException {
        int totalSizeEntry = 0;
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            ZipInputStream zis = new ZipInputStream(input);
            try {
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));){
                    ZipEntry ze = zis.getNextEntry();
                    while (ze != null) {
                        if (ze.getName().equals(entry)) {
                            int nBytes = -1;
                            byte[] buffer = new byte[4096];
                            while ((nBytes = zis.read(buffer)) > 0) {
                                bos.write(buffer, 0, nBytes);
                                double compressionRatio = (double)(totalSizeEntry += nBytes) / (double)ze.getCompressedSize();
                                if (compressionRatio > this.maxCompressionRatio) {
                                    throw new IOException(String.format("Zip file looks like a Zip Bomb Attack: ratio between compressed and uncompressed data %f is highly suspicious and is over the maximum allowed of %f", compressionRatio, this.maxCompressionRatio));
                                }
                                if (totalSizeEntry <= this.maxSize) continue;
                                throw new IOException(String.format("Zip file looks like a Zip Bomb Attack: the uncompressed data size is over the maximum allowed of %s", FileUtil.getDisplaySize(this.maxSize, "en")));
                            }
                            bos.flush();
                            break;
                        }
                        ze = zis.getNextEntry();
                    }
                }
                if (zis == null) return totalSizeEntry;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            zis.close();
            return totalSizeEntry;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public long unzip(File zipFile, String entry, File target) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public byte[] getEntryBytes(File zipFile, String entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCharset(ZipFile zipFile) {
        if (this.fileNameCharset != null && !"auto".equals(this.fileNameCharset)) {
            zipFile.setCharset(Charset.forName(this.fileNameCharset));
        }
    }

    public InputStream getEntryStream(File zipFile, String entry) {
        if (entry.startsWith("/")) {
            entry = entry.substring(1);
        }
        try {
            this.zFile = new ZipFile(zipFile);
            this.setCharset(this.zFile);
            FileHeader header = this.zFile.getFileHeader(entry);
            return this.zFile.getInputStream(header);
        }
        catch (Exception e2) {
            ZipUtil.logError(e2.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        if (this.zFile != null) {
            try {
                this.zFile.close();
                this.zFile = null;
            }
            catch (IOException e2) {
                log.error(e2.getMessage());
            }
        }
    }

    public String getEntryContent(File zip, String entry) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = this.getEntryStream(zip, entry);){
            return IOUtil.readStream(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void logError(String message) {
        Logger logger = LoggerFactory.getLogger(ZipUtil.class);
        logger.error(message);
    }

    public static void addEntry(File zip, String entry, InputStream content) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(zip);){
                ZipParameters parameters = new ZipParameters();
                parameters.setCompressionMethod(CompressionMethod.DEFLATE);
                parameters.setFileNameInZip(entry);
                zipFile.addStream(content, parameters);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            ZipUtil.logError(e2.getMessage());
        }
    }

    private void zipDir(File zipDir, ZipOutputStream zos, File startZipDir) {
        try {
            File[] dirList = zipDir.listFiles();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            int i2 = 0;
            while (i2 < dirList.length) {
                File f2 = dirList[i2];
                if (f2.isDirectory()) {
                    this.zipDir(f2, zos, startZipDir);
                } else {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (FileInputStream fis = new FileInputStream(f2);){
                        String path = f2.getPath();
                        if (!path.equals(startZipDir.getPath())) {
                            path = path.substring(startZipDir.getPath().length());
                        }
                        if (path.startsWith(File.separator)) {
                            path = path.substring(1);
                        }
                        ZipEntry anEntry = new ZipEntry(path);
                        zos.putNextEntry(anEntry);
                        while ((bytesIn = fis.read(readBuffer)) != -1) {
                            zos.write(readBuffer, 0, bytesIn);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            ZipUtil.logError(e2.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void zipFile(File src, File dest) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dest));
                try {
                    try (FileInputStream fis = new FileInputStream(src);){
                        ZipEntry anEntry = new ZipEntry(src.getName());
                        zos.putNextEntry(anEntry);
                        byte[] readBuffer = new byte[2156];
                        int bytesIn = 0;
                        while ((bytesIn = fis.read(readBuffer)) != -1) {
                            zos.write(readBuffer, 0, bytesIn);
                        }
                        zos.flush();
                    }
                    if (zos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (zos == null) throw throwable;
                    zos.close();
                    throw throwable;
                }
                zos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            ZipUtil.logError(e2.getMessage());
        }
    }

    public void zipFolder(File inFolder, File outFile) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
            this.zipDir(inFolder, zos, inFolder);
            zos.flush();
            zos.close();
        }
        catch (Exception e2) {
            ZipUtil.logError(e2.getMessage());
        }
    }

    public String getFileNameCharset() {
        return this.fileNameCharset;
    }

    public void setFileNameCharset(String fileNameCharset) {
        this.fileNameCharset = fileNameCharset;
    }

    /*
     * Exception decompiling
     */
    public void unGZipUnTar(File tarGzFile, File targetDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long unGZip(File gzFile, File targetFile) throws IOException {
        return this.unGZip(new FileInputStream(gzFile), targetFile);
    }

    /*
     * Exception decompiling
     */
    public long unGZip(InputStream is, File target) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

