/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.Context;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public class SevenZipUtil {
    private int maxSize = 0x40000000;

    public SevenZipUtil() {
        try {
            this.maxSize = Context.get().getProperties().getInt("zip.maxsize", 1024) * 1024 * 1024;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> listEntries(File sevenZipFile) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (SevenZFile archiveFile = new SevenZFile(sevenZipFile);){
                SevenZArchiveEntry entry;
                while ((entry = archiveFile.getNextEntry()) != null) {
                    entries.add(entry.getName());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            throw new IOException(e2.getMessage(), e2);
        }
        return entries;
    }

    public void extractEntry(File sevenZipFile, String entryName, File dest) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SevenZFile archiveFile = new SevenZFile(sevenZipFile);){
            SevenZArchiveEntry entry;
            while ((entry = archiveFile.getNextEntry()) != null) {
                if (!entry.getName().equals(entryName) || !entry.hasStream()) continue;
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(dest);){
                    int length = -1;
                    byte[] buffer = new byte[2048];
                    int totalSizeEntry = 0;
                    while ((length = archiveFile.read(buffer)) != -1) {
                        fileOutputStream.write(buffer, 0, length);
                        if ((totalSizeEntry += length) <= this.maxSize) continue;
                        throw new IOException(String.format("7Zip file looks like a Zip Bomb Attack: the uncompressed data size is over the maximum allowed of %s", FileUtil.getDisplaySize(this.maxSize, "en")));
                    }
                    break;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

