/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ResourceUtil {
    private ResourceUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] readAsBytes(String resourcePath) throws IOException {
        return ResourceUtil.class.getResourceAsStream(resourcePath).readAllBytes();
    }

    public static String readAsString(String resourcePath) throws IOException {
        StringBuilder resourceData = new StringBuilder(1000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceUtil.class.getResourceAsStream(resourcePath)));){
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                resourceData.append(buf, 0, numRead);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return resourceData.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyResource(String classpath, File out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(ResourceUtil.class.getResource(classpath).openStream());
            try {
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
                    int b2;
                    while ((b2 = ((InputStream)is).read()) != -1) {
                        ((OutputStream)os).write(b2);
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean existsResource(String resourceName) {
        boolean bl;
        InputStream is;
        block12: {
            is = null;
            is = ResourceUtil.getInputStream(resourceName);
            boolean bl2 = bl = is != null;
            if (is == null) break block12;
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e2) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private static InputStream getInputStream(String resourceName) throws IOException {
        BufferedInputStream is;
        try {
            is = new BufferedInputStream(FileUtil.class.getResource(resourceName).openStream());
        }
        catch (Exception e2) {
            is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResource(resourceName).openStream());
        }
        return is;
    }
}

