/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.logicaldoc.util.Context;
import com.logicaldoc.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class RarUtil {
    private int maxSize = 0x40000000;

    public RarUtil() {
        try {
            this.maxSize = Context.get().getProperties().getInt("zip.maxsize", 1024) * 1024 * 1024;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> listEntries(File rarFile) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Archive archive = new Archive(rarFile);){
                FileHeader fh = archive.nextFileHeader();
                while (fh != null) {
                    entries.add(fh.getFileName());
                    fh = archive.nextFileHeader();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RarException e2) {
            throw new IOException(e2.getMessage());
        }
        return entries;
    }

    public void extractEntry(File rarFile, String entryName, File dest) throws IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Archive archive = new Archive(rarFile);){
                FileHeader fh = archive.nextFileHeader();
                while (fh != null) {
                    if (entryName.equals(fh.getFileName())) {
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));){
                            int nBytes = -1;
                            byte[] buffer = new byte[4096];
                            int totalSizeEntry = 0;
                            Throwable throwable3 = null;
                            Object var15_21 = null;
                            try (InputStream is = archive.getInputStream(fh);){
                                while ((nBytes = is.read(buffer)) > 0) {
                                    bos.write(buffer, 0, nBytes);
                                    if ((totalSizeEntry += nBytes) <= this.maxSize) continue;
                                    throw new IOException(String.format("Rar file looks like a Zip Bomb Attack: the uncompressed data size is over the maximum allowed of %s", FileUtil.getDisplaySize(this.maxSize, "en")));
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                            bos.flush();
                            break;
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    fh = archive.nextFileHeader();
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (RarException e2) {
            throw new IOException(e2.getMessage());
        }
    }
}

