/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private long left;
    private long mark = -1L;

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        if (in == null) {
            throw new IllegalArgumentException("no input stream");
        }
        if (limit < 0L) {
            throw new IndexOutOfBoundsException("negative limit");
        }
        this.left = limit;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.left;
    }

    @Override
    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        }
        return result;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read(b2, off, len = (int)Math.min((long)len, this.left));
        if (result != -1) {
            this.left -= (long)result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    @Override
    public long skip(long n2) throws IOException {
        n2 = Math.min(n2, this.left);
        long skipped = this.in.skip(n2);
        this.left -= skipped;
        return skipped;
    }

    public static void readFully(InputStream in, byte[] b2) throws IOException {
        LimitedInputStream.readFully(in, b2, 0, b2.length);
    }

    public static void readFully(InputStream in, byte[] b2, int off, int len) throws IOException {
        int read = LimitedInputStream.read(in, b2, off, len);
        if (read != len) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + len + " bytes expected");
        }
    }

    public static void skipFully(InputStream in, long n2) throws IOException {
        long skipped = LimitedInputStream.skipUpTo(in, n2);
        if (skipped < n2) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n2 + " bytes expected");
        }
    }

    static long skipUpTo(InputStream in, long n2) throws IOException {
        long totalSkipped = 0L;
        byte[] buf = LimitedInputStream.createBuffer();
        while (totalSkipped < n2) {
            int skip;
            long remaining = n2 - totalSkipped;
            long skipped = LimitedInputStream.skipSafely(in, remaining);
            if (skipped == 0L && (skipped = (long)in.read(buf, 0, skip = (int)Math.min(remaining, (long)buf.length))) == -1L) break;
            totalSkipped += skipped;
        }
        return totalSkipped;
    }

    private static long skipSafely(InputStream in, long n2) throws IOException {
        int available = in.available();
        return available == 0 ? 0L : in.skip(Math.min((long)available, n2));
    }

    public static int read(InputStream in, byte[] b2, int off, int len) throws IOException {
        if (in == null) {
            throw new IndexOutOfBoundsException("no input stream has been specified");
        }
        if (b2 == null) {
            throw new IndexOutOfBoundsException("no bytes have been specified");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        int total = 0;
        while (total < len) {
            int result = in.read(b2, off + total, len - total);
            if (result == -1) break;
            total += result;
        }
        return total;
    }

    private static byte[] createBuffer() {
        return new byte[8192];
    }
}

