/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.time.TimeDiff;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FileUtil {
    private static final String CANNOT_CREATE_FILE = "Cannot create file ";
    static final int BUFF_SIZE = 8192;
    static final byte[] buffer = new byte[8192];
    protected static Logger log = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void writeFile(InputStream in, String filepath) throws IOException {
        var2_2 = null;
        var3_4 = null;
        try {
            os = new FileOutputStream(filepath);
            ** try [egrp 2[TRYBLOCK] [3 : 14->68)] { 
lbl7:
            // 1 sources

            ** GOTO lbl-1000
lbl8:
            // 1 sources

            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
                throw var2_2;
            }
            if (var2_2 == var3_5) throw var2_2;
            var2_2.addSuppressed(var3_5);
            throw var2_2;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                FileUtil.logError(e.getMessage());
            }
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                var5_7 = FileUtil.buffer;
                // MONITORENTER : com.logicaldoc.util.io.FileUtil.buffer
                amountRead = in.read(FileUtil.buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : var5_7
                    break;
                }
                os.write(FileUtil.buffer, 0, amountRead);
                // MONITOREXIT : var5_7
            }
            os.flush();
            return;
        }
    }

    public static void writeFile(byte[] in, String filepath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(in);){
            FileUtil.writeFile(inStream, filepath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeFile(String text, String filepath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(filepath);
                try {
                    try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                        bos.write(text.getBytes(StandardCharsets.UTF_8));
                        bos.flush();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            FileUtil.logError(e2.getLocalizedMessage());
        }
    }

    public static String readFile(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fisTargetFile = new FileInputStream(file);){
            return IOUtils.toString((InputStream)fisTargetFile, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readFile(String filePath) throws IOException {
        return FileUtil.readFile(new File(filePath));
    }

    public static void appendFile(String text, String filepath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream bos = new FileOutputStream(filepath, true);){
                ((OutputStream)bos).write(text.getBytes());
                bos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            FileUtil.logError(e2.getLocalizedMessage());
        }
    }

    private static void logError(String message) {
        Log logger = LogFactory.getLog(FileUtil.class);
        logger.error((Object)message);
    }

    public static String computeDigest(InputStream is) {
        if (is == null) {
            return null;
        }
        String digest = "";
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
            byte[] message = new byte[8192];
            int len = 0;
            while ((len = is.read(message)) != -1) {
                sha.update(message, 0, len);
            }
            byte[] messageDigest = sha.digest();
            int size = messageDigest.length;
            StringBuilder buf = new StringBuilder();
            int unsignedValue = 0;
            String strUnsignedValue = null;
            int i2 = 0;
            while (i2 < size) {
                unsignedValue = messageDigest[i2] & 0xFF;
                strUnsignedValue = Integer.toHexString(unsignedValue);
                if (strUnsignedValue.length() == 1) {
                    buf.append("0");
                }
                buf.append(strUnsignedValue);
                ++i2;
            }
            digest = buf.toString();
            log.debug("Computed Digest: {}", (Object)digest);
            String string = digest;
            return string;
        }
        catch (IOException io) {
            log.error("Error generating digest", io);
        }
        catch (Exception t2) {
            log.error("Error generating digest", t2);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static String computeDigest(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 8192);){
                return FileUtil.computeDigest(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            return null;
        }
    }

    public static String computeDigest(String src) {
        String digest = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = IOUtils.toInputStream(src, StandardCharsets.UTF_8);){
                digest = FileUtil.computeDigest(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            log.error(e2.getMessage());
            digest = null;
        }
        return digest;
    }

    /*
     * Unable to fully structure code
     */
    public static void copyResource(String resourceName, File out) throws IOException {
        out.getParentFile().mkdirs();
        resourceUrl = FileUtil.class.getResource(resourceName);
        if (resourceUrl == null) {
            resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        }
        if (resourceUrl == null) {
            throw new IOException("Resource cannot be found: " + resourceName);
        }
        var3_3 = null;
        var4_5 = null;
        try {
            is = resourceUrl.openStream();
            try {
                bis = new BufferedInputStream(is);
                try {
                    os = new FileOutputStream(out);
                    try {
                        bos = new BufferedOutputStream(os);
                        try {
                            while (true) {
                                if ((b = is.read()) == -1) {
                                    break;
                                }
                                os.write(b);
                            }
                        }
                        finally {
                            if (bos != null) {
                                bos.close();
                            }
                        }
                        ** if (os == null) goto lbl-1000
                    }
                    catch (Throwable var4_6) {
                        if (var3_3 == null) {
                            var3_3 = var4_6;
                        } else if (var3_3 != var4_6) {
                            var3_3.addSuppressed(var4_6);
                        }
                        if (os != null) {
                            os.close();
                        }
                        throw var3_3;
                    }
lbl-1000:
                    // 1 sources

                    {
                        os.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    ** if (bis == null) goto lbl-1000
                }
                catch (Throwable var4_7) {
                    if (var3_3 == null) {
                        var3_3 = var4_7;
                    } else if (var3_3 != var4_7) {
                        var3_3.addSuppressed(var4_7);
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    throw var3_3;
                }
lbl-1000:
                // 1 sources

                {
                    bis.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var4_8) {
                if (var3_3 == null) {
                    var3_3 = var4_8;
                } else if (var3_3 != var4_8) {
                    var3_3.addSuppressed(var4_8);
                }
                if (is != null) {
                    is.close();
                }
                throw var3_3;
            }
lbl-1000:
            // 1 sources

            {
                is.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var4_9) {
            if (var3_3 == null) {
                var3_3 = var4_9;
            } else if (var3_3 != var4_9) {
                var3_3.addSuppressed(var4_9);
            }
            throw var3_3;
        }
    }

    public static String getExtension(String fileName) {
        if (fileName != null && fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        return "";
    }

    public static String getBaseName(String fileName) {
        String name = FileUtil.getName(fileName);
        try {
            return FilenameUtils.getBaseName(name);
        }
        catch (Exception e2) {
            if (name != null && name.contains(".")) {
                return name.substring(0, name.indexOf(46));
            }
            return "";
        }
    }

    public static String getName(String fileName) {
        try {
            return FilenameUtils.getName(fileName);
        }
        catch (Exception e2) {
            if (fileName != null && fileName.contains("/")) {
                return fileName.substring(fileName.lastIndexOf(47) + 1);
            }
            if (fileName != null && fileName.contains("\\")) {
                return fileName.substring(fileName.lastIndexOf(92) + 1);
            }
            return fileName;
        }
    }

    public static String getPath(String fileName) {
        try {
            return FilenameUtils.getPath(fileName);
        }
        catch (Exception e2) {
            if (fileName != null && fileName.contains("/")) {
                return fileName.substring(0, fileName.lastIndexOf(47));
            }
            if (fileName != null && fileName.contains("\\")) {
                return fileName.substring(0, fileName.lastIndexOf(92));
            }
            return fileName;
        }
    }

    public static long getFolderSize(File folder) {
        long foldersize = 0L;
        File[] files = folder.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            foldersize = files[i2].isDirectory() ? (foldersize += FileUtil.getFolderSize(files[i2])) : (foldersize += files[i2].length());
            ++i2;
        }
        return foldersize;
    }

    public static String getDisplaySize(long size, String language) {
        Object displaySize = "";
        Locale locale = LocaleUtils.toLocale("en");
        if (StringUtils.isNotEmpty(language)) {
            locale = LocaleUtils.toLocale(language);
        }
        DecimalFormat nf = new DecimalFormat("###,###,###.0", new DecimalFormatSymbols(locale));
        displaySize = size > 1000000000L ? nf.format((double)size / 1024.0 / 1024.0 / 1024.0) + " GB" : (size > 1000000L ? nf.format((double)size / 1024.0 / 1024.0) + " MB" : (size > 1000L ? nf.format((double)size / 1024.0) + " KB" : size + " Bytes"));
        return displaySize;
    }

    public static String getDisplaySizeKB(long size, String language) {
        Object displaySize = "";
        Locale locale = LocaleUtils.toLocale("en");
        if (StringUtils.isNotEmpty(language)) {
            locale = LocaleUtils.toLocale(language);
        }
        DecimalFormat nf = new DecimalFormat("###,###,##0.0", new DecimalFormatSymbols(locale));
        displaySize = nf.format((double)size / 1024.0) + " KB";
        return displaySize;
    }

    public static boolean matches(String filename, Collection<String> includes, Collection<String> excludes) {
        boolean matchesExcludes = FileUtil.matchesFilters(filename, excludes);
        if (matchesExcludes) {
            return false;
        }
        boolean matchesIncludes = FileUtil.matchesFilters(filename, includes);
        if (matchesIncludes) {
            return true;
        }
        return CollectionUtils.isEmpty(includes);
    }

    private static boolean matchesFilters(String str, Collection<String> filters) {
        if (!CollectionUtils.isEmpty(filters)) {
            for (String s2 : filters) {
                if (!StringUtils.isNotEmpty(s2) || !SelectorUtils.match((String)s2, (String)str, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(String filename, String includes, String excludes) {
        StringTokenizer st;
        ArrayList<String> inc = new ArrayList<String>();
        ArrayList<String> exc = new ArrayList<String>();
        if (StringUtils.isNotEmpty(excludes)) {
            st = new StringTokenizer(excludes, ",", false);
            while (st.hasMoreTokens()) {
                exc.add(st.nextToken().trim());
            }
        }
        if (StringUtils.isNotEmpty(includes)) {
            st = new StringTokenizer(includes, ",", false);
            while (st.hasMoreTokens()) {
                inc.add(st.nextToken().trim());
            }
        }
        return FileUtil.matches(filename, inc, exc);
    }

    public static void writeUTF8(String content, File file, boolean append) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), StandardCharsets.UTF_8));){
                out.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
        }
    }

    public static byte[] toByteArray(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 2048);){
                return IOUtils.toByteArray(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            log.error(e2.getMessage());
            return new byte[0];
        }
    }

    public static byte[] toByteArray(RandomAccessFile input, long start, long length) throws IOException {
        try {
            byte[] byArray;
            block17: {
                Throwable throwable = null;
                Object var6_5 = null;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    FileUtil.copy(input, output, start, length);
                    output.flush();
                    byArray = output.toByteArray();
                    if (output == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                output.close();
            }
            return byArray;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] toByteArray(File file, long start, long length) throws IOException {
        return FileUtil.toByteArray(new RandomAccessFile(file, "r"), start, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File input, File output, long offset) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            RandomAccessFile inputRa = new RandomAccessFile(input, "r");
            try {
                block24: {
                    RandomAccessFile outputRa = new RandomAccessFile(output, "rw");
                    try {
                        block23: {
                            FileChannel sourceChannel = inputRa.getChannel();
                            try {
                                try (FileChannel targetChannel = outputRa.getChannel();){
                                    targetChannel.transferFrom(sourceChannel, offset, input.length());
                                }
                                if (sourceChannel == null) break block23;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (sourceChannel == null) throw throwable;
                                sourceChannel.close();
                                throw throwable;
                            }
                            sourceChannel.close();
                        }
                        if (outputRa == null) break block24;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (outputRa == null) throw throwable;
                        outputRa.close();
                        throw throwable;
                    }
                    outputRa.close();
                }
                if (inputRa == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (inputRa == null) throw throwable;
                inputRa.close();
                throw throwable;
            }
            inputRa.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private static void copy(RandomAccessFile input, OutputStream output, long start, long length) throws IOException {
        byte[] buffer = new byte[8192];
        if (input.length() == length) {
            int read;
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    public static void replaceInFile(String sourcePath, String token, String newValue) throws IOException {
        String content = FileUtil.readFile(sourcePath);
        FileUtil.writeFile(content.replace(token, newValue), sourcePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File source, File target) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(source);
                try {
                    block29: {
                        FileChannel in = fis.getChannel();
                        try {
                            block28: {
                                FileOutputStream fos = new FileOutputStream(target);
                                try {
                                    try (FileChannel out = fos.getChannel();){
                                        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
                                        block13: while (in.read(buffer) != -1) {
                                            ((Buffer)buffer).flip();
                                            while (true) {
                                                if (!buffer.hasRemaining()) {
                                                    ((Buffer)buffer).clear();
                                                    continue block13;
                                                }
                                                out.write(buffer);
                                            }
                                        }
                                    }
                                    if (fos == null) break block28;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (fos == null) throw throwable;
                                    fos.close();
                                    throw throwable;
                                }
                                fos.close();
                            }
                            if (in == null) break block29;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e2) {
            log.warn(e2.getMessage(), e2);
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return true;
        }
        Date start = new Date();
        try {
            boolean bl = FileUtils.deleteQuietly(file);
            return bl;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("Deleted path {} in {}", (Object)file.getAbsolutePath(), (Object)TimeDiff.printDuration(start, new Date()));
            }
        }
    }

    public static void moveQuitely(File source, File target) {
        block8: {
            Date start = new Date();
            try {
                try {
                    Files.move(source.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e2) {
                    log.warn("Cannot move {} into {}", (Object)source.getAbsolutePath(), (Object)target.getAbsolutePath());
                    log.warn(e2.getMessage(), e2);
                    if (log.isDebugEnabled()) {
                        log.debug("Moved path {} into {} in {}", source.getAbsolutePath(), target.getAbsolutePath(), TimeDiff.printDuration(start, new Date()));
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("Moved path {} into {} in {}", source.getAbsolutePath(), target.getAbsolutePath(), TimeDiff.printDuration(start, new Date()));
                }
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug("Moved path {} into {} in {}", source.getAbsolutePath(), target.getAbsolutePath(), TimeDiff.printDuration(start, new Date()));
            }
        }
    }

    public static boolean isDirEmpty(Path directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void merge(File f1, File f2, File merged) throws IOException {
        FileUtil.copyFile(f1, merged);
        Files.write(merged.toPath(), Files.readAllBytes(f2.toPath()), StandardOpenOption.APPEND);
    }

    public static void merge(List<File> files, File merged) throws IOException {
        boolean created = merged.createNewFile();
        if (!created) {
            throw new IOException(CANNOT_CREATE_FILE + merged.getAbsolutePath());
        }
        File tmp = new File(merged.getParentFile(), "merge.tmp");
        try {
            created = tmp.createNewFile();
            if (!created) {
                throw new IOException(CANNOT_CREATE_FILE + tmp.getAbsolutePath());
            }
            for (File chunk : files) {
                FileUtil.merge(merged, chunk, tmp);
                FileUtils.forceDelete(merged);
                boolean renamed = tmp.renameTo(merged);
                if (!renamed) {
                    throw new IOException("Cannot rename file to " + merged.getAbsolutePath());
                }
                created = tmp.createNewFile();
                if (created) continue;
                throw new IOException(CANNOT_CREATE_FILE + tmp.getAbsolutePath());
            }
        }
        finally {
            FileUtils.deleteQuietly(tmp);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> split(File file, long chunkSize, File destDir) throws IOException {
        ArrayList<File> chunks = new ArrayList<File>();
        Throwable throwable = null;
        Object var6_6 = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            File chunkFile;
            long numSplits = file.length() / chunkSize;
            long sourceSize = raf.length();
            long remainingBytes = sourceSize - numSplits * chunkSize;
            DecimalFormat nf = new DecimalFormat("00000000000000");
            int maxReadBufferSize = 8192;
            int destIx = 1;
            while (true) {
                block40: {
                    Throwable throwable2;
                    if ((long)destIx > numSplits) {
                        if (remainingBytes <= 0L) return chunks;
                        chunkFile = new File(destDir, nf.format(numSplits + 1L));
                        Throwable throwable3 = null;
                        throwable2 = null;
                        try {
                            FileOutputStream fos = new FileOutputStream(chunkFile);
                            try {
                                try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                                    FileUtil.readWrite(raf, bos, remainingBytes);
                                }
                                if (fos == null) break;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                if (fos == null) throw throwable3;
                                fos.close();
                                throw throwable3;
                            }
                            fos.close();
                            break;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                    }
                    File chunkFile2 = new File(destDir, nf.format(destIx));
                    throwable2 = null;
                    Object var19_22 = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(chunkFile2);
                        try {
                            try (BufferedOutputStream bw = new BufferedOutputStream(fos);){
                                block38: {
                                    if (chunkSize > (long)maxReadBufferSize) {
                                        long numReads = chunkSize / (long)maxReadBufferSize;
                                        long numRemainingRead = chunkSize % (long)maxReadBufferSize;
                                        int i2 = 0;
                                        while (true) {
                                            if ((long)i2 >= numReads) {
                                                if (numRemainingRead > 0L) {
                                                    FileUtil.readWrite(raf, bw, numRemainingRead);
                                                }
                                                break block38;
                                            }
                                            FileUtil.readWrite(raf, bw, maxReadBufferSize);
                                            ++i2;
                                        }
                                    }
                                    FileUtil.readWrite(raf, bw, chunkSize);
                                }
                                chunks.add(chunkFile2);
                            }
                            if (fos == null) break block40;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            if (fos == null) throw throwable2;
                            fos.close();
                            throw throwable2;
                        }
                        fos.close();
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                            throw throwable2;
                        }
                        if (throwable2 == throwable7) throw throwable2;
                        throwable2.addSuppressed(throwable7);
                        throw throwable2;
                    }
                }
                ++destIx;
            }
            chunks.add(chunkFile);
            return chunks;
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
                throw throwable;
            }
            if (throwable == throwable8) throw throwable;
            throwable.addSuppressed(throwable8);
            throw throwable;
        }
    }

    private static void readWrite(RandomAccessFile raf, BufferedOutputStream bw, long numBytes) throws IOException {
        byte[] buf = new byte[(int)numBytes];
        int val = raf.read(buf);
        if (val != -1) {
            bw.write(buf);
        }
    }

    public static long countLines(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            return stream.count();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isInsideFolder(File folder, File file) {
        try {
            return file.getCanonicalPath().startsWith(folder.getCanonicalPath());
        }
        catch (IOException e2) {
            log.error(e2.getMessage(), e2);
            return false;
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix);
    }

    public static File createTempDirectory(String prefix) throws IOException {
        Path path = Files.createTempDirectory(prefix, new FileAttribute[0]);
        return path.toFile();
    }
}

