/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.http;

import com.logicaldoc.util.http.BaseHttpClientResponseHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHttpClientResponseHandler
extends BaseHttpClientResponseHandler<String> {
    protected static Logger log = LoggerFactory.getLogger(FileHttpClientResponseHandler.class);
    private File file;

    public FileHttpClientResponseHandler(File file) {
        this.file = file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String handleEntity(HttpEntity entity) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(entity.getContent());
            try {
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));){
                    int inByte;
                    while ((inByte = bis.read()) != -1) {
                        bos.write(inByte);
                    }
                }
                if (bis == null) return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (bis == null) throw throwable;
                bis.close();
                throw throwable;
            }
            bis.close();
            return null;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

