/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.http;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpClientResponseHandler<T>
extends AbstractHttpClientResponseHandler<T> {
    protected static Logger log = LoggerFactory.getLogger(BaseHttpClientResponseHandler.class);
    private static final String UTF_8 = "UTF-8";

    public static String getResponseBody(ClassicHttpResponse response) throws IOException {
        return BaseHttpClientResponseHandler.getResponseBody(response, null);
    }

    public static String getResponseBody(ClassicHttpResponse response, Integer maxLength) throws IOException {
        String content;
        HttpEntity responseContent = response.getEntity();
        try {
            content = EntityUtils.toString((HttpEntity)responseContent, (String)UTF_8);
        }
        catch (ParseException e2) {
            throw new IOException(e2);
        }
        return maxLength != null ? StringUtils.abbreviate(content, 200) : content;
    }
}

