/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEater
implements Runnable {
    protected static Logger log = LoggerFactory.getLogger(StreamEater.class);
    private InputStream inputStream;
    private String prefix;
    private Writer output;
    private StringBuilder buffer;

    public StreamEater(String prefix, InputStream inputStream, StringBuilder buffer) {
        this.prefix = prefix;
        this.inputStream = inputStream;
        this.buffer = buffer;
    }

    public StreamEater(String prefix, InputStream inptutStream, Writer output) {
        this.prefix = prefix;
        this.inputStream = inptutStream;
        this.output = output;
    }

    public StreamEater(String prefix, InputStream stream) {
        this(prefix, stream, (Writer)null);
    }

    @Override
    public void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));){
                String line = br.readLine();
                while (line != null) {
                    this.writeLine(line);
                    if (this.buffer != null) {
                        if (!this.buffer.isEmpty()) {
                            this.buffer.append("\n");
                        }
                        this.buffer.append(line);
                    }
                    line = br.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeLine(String line) throws IOException {
        if (this.prefix != null) {
            log.debug("{}: {}", (Object)this.prefix, (Object)line);
        }
        if (this.output != null && line != null) {
            this.output.write(line);
            this.output.flush();
        }
    }
}

