/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrivilegedRunner {
    private static final String OS_NAME = "os.name";
    private static final Logger logger = Logger.getLogger(PrivilegedRunner.class.getName());

    public int executeWithElevatedRights(String command) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(this.getElevator(command));
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Relaunching: " + String.valueOf(builder.command()));
        }
        Process process = builder.start();
        return process.waitFor();
    }

    protected List<String> getElevator(String command) throws IOException {
        ArrayList<String> elevator = new ArrayList<String>();
        if (PrivilegedRunner.isMac()) {
            elevator.add(this.extractMacElevator().getCanonicalPath());
            elevator.add(command);
        } else if (PrivilegedRunner.isUnix()) {
            elevator.add("xterm");
            elevator.add("-title");
            elevator.add("LogicalDOC");
            elevator.add("-e");
            elevator.add("sudo");
            elevator.add(command);
        } else if (PrivilegedRunner.isWindows()) {
            elevator.add("wscript");
            elevator.add(this.extractVistaElevator().getCanonicalPath());
            elevator.add(command);
        }
        return elevator;
    }

    protected File extractVistaElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Elevator.js";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/logicaldoc/util/exec/windows/elevate.js");
        this.copyStream(out, in);
        in.close();
        out.close();
        elevator.deleteOnExit();
        return elevator;
    }

    protected File extractMacElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Elevator";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/logicaldoc/util/exec/mac/run-with-privileges-on-osx");
        this.copyStream(out, in);
        in.close();
        out.close();
        if (!elevator.setExecutable(true)) {
            throw new IOException("Failed to set execute permission on " + path);
        }
        elevator.deleteOnExit();
        return elevator;
    }

    private void copyStream(OutputStream out, InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static boolean isWindows() {
        return System.getProperty(OS_NAME).toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return System.getProperty(OS_NAME).toLowerCase().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return System.getProperty(OS_NAME).toLowerCase().indexOf("nix") >= 0 || System.getProperty(OS_NAME).toLowerCase().indexOf("nux") >= 0 || System.getProperty(OS_NAME).toLowerCase().indexOf("aix") >= 0;
    }
}

