/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.exec;

import com.logicaldoc.util.exec.StreamGobbler;
import com.logicaldoc.util.exec.Worker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Exec {
    private static final String EXECUTING_COMMAND = "Executing command {}";
    private static final String COMMAND_FAILED_TO_EXECUTE = "Command failed to execute - {}";
    private static final String TIMEOUT_COMMAND = "Timeout command {}";
    private static final String ALLOWED_COMMANDS = "/allowed-commands.txt";
    protected static Logger log = LoggerFactory.getLogger(Exec.class);
    private String outPrefix = "out";
    private String errPrefix = "err";

    public void setErrPrefix(String errPrefix) {
        this.errPrefix = errPrefix;
    }

    public void setOutPrefix(String outPrefix) {
        this.outPrefix = outPrefix;
    }

    public boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public int execPB(List<String> commandLine, Map<String, String> environment, File directory, int timeout) throws IOException {
        Exec.checkAllowed(commandLine);
        if (log.isDebugEnabled()) {
            log.debug("Executing command: {}", (Object)commandLine);
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        pb.command(commandLine.toArray(new String[0]));
        pb.directory(directory);
        if (!CollectionUtils.isEmpty(environment)) {
            pb.environment().putAll(environment);
        }
        Thread worker = null;
        Process process = null;
        try {
            process = pb.start();
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
            outputGobbler.start();
            worker = new Worker(process);
            worker.start();
            if (timeout > 0) {
                worker.join((long)timeout * 1000L);
            } else {
                worker.join();
            }
            if (((Worker)worker).getExit() == null) {
                throw new TimeoutException();
            }
            int n2 = ((Worker)worker).getExit();
            return n2;
        }
        catch (TimeoutException e2) {
            log.error("Command timed out {}", (Object)commandLine);
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return 1;
    }

    public int execPB(List<String> commandLine, File directory, int timeout) throws IOException {
        return this.execPB(commandLine, null, directory, timeout);
    }

    public int exec(List<String> commandLine) throws IOException {
        return this.exec(commandLine, null, null, -1);
    }

    /*
     * Exception decompiling
     */
    public int exec(List<String> commandLine, List<String> env, File dir, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String execGetOutput(List<String> commandLine, List<String> env, File dir, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getProcessOutput(Process process) throws IOException {
        String s2;
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder out = new StringBuilder();
        while ((s2 = reader.readLine()) != null) {
            out.append(s2);
        }
        return out.toString();
    }

    private String commandForLog(String commandLine) {
        if (commandLine.length() <= 60) {
            return commandLine;
        }
        return StringUtils.left(commandLine, 30) + "..." + StringUtils.right(commandLine, 30);
    }

    public String execGetOutput(String commandLine, List<String> env, File dir) throws IOException {
        Exec.checkAllowed(commandLine);
        Process process = Runtime.getRuntime().exec(commandLine.split(" "), env != null ? env.toArray(new String[0]) : null, dir != null ? dir : null);
        return this.getProcessOutput(process);
    }

    /*
     * Exception decompiling
     */
    public int exec(String commandLine, List<String> env, File dir, StringBuilder buffer, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int exec(String commandLine, List<String> env, File dir, Writer outputWriter, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int exec(String commandLine, List<String> env, File dir, int timeout) throws IOException {
        return this.exec(commandLine, env, dir, (Writer)null, timeout);
    }

    private static void checkAllowed(List<String> commandLine) throws IOException {
        Exec.checkAllowed(commandLine.stream().collect(Collectors.joining(" ")));
    }

    private static void checkAllowed(String commandLine) throws IOException {
        boolean allowed;
        Set<String> allowedCommands = Exec.getAllowedCommands();
        if (allowedCommands.isEmpty()) {
            return;
        }
        String cmdLine = commandLine;
        if (cmdLine.startsWith("\"")) {
            cmdLine = commandLine.substring(1);
        }
        if (!(allowed = allowedCommands.contains(cmdLine))) {
            for (String row : allowedCommands) {
                if (!"*".equals(row) && !cmdLine.startsWith(row)) continue;
                allowed = true;
                break;
            }
        }
        if (!allowed) {
            throw new IOException("Command " + commandLine + " is not allowed. Add it to allowed-commands.txt.");
        }
    }

    private static Set<String> getAllowedCommands() {
        HashSet<String> allowedCommands = new HashSet<String>();
        URL resource = Exec.class.getResource(ALLOWED_COMMANDS);
        if (resource == null) {
            return allowedCommands;
        }
        InputStream is = null;
        try {
            try {
                is = new FileInputStream(resource.getFile());
            }
            catch (FileNotFoundException e2) {
                log.error(e2.getMessage(), e2);
            }
            if (is == null) {
                is = Exec.class.getResourceAsStream(ALLOWED_COMMANDS);
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (Scanner sc = new Scanner(is);){
                while (sc.hasNext()) {
                    String line = sc.nextLine().trim();
                    if (!StringUtils.isNotEmpty(line) || line.startsWith("#") || allowedCommands.contains(line)) continue;
                    allowedCommands.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Exec.close(is);
            throw throwable;
        }
        Exec.close(is);
        return allowedCommands;
    }

    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class CallableProcess
    implements Callable<Integer> {
        private Process p;

        public CallableProcess(Process process) {
            this.p = process;
        }

        @Override
        public Integer call() throws Exception {
            return this.p.waitFor();
        }
    }
}

