/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.dbinit;

import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBInit {
    protected static Logger log = LoggerFactory.getLogger(DBInit.class);
    private String dbms = "";
    private String driver = "";
    private String url = "";
    private String username = "";
    private String password = System.getProperty("database.password");
    private Connection con;
    private List<String> sqlList = new ArrayList<String>();

    public DBInit(List<String> sqlList) {
        this.sqlList = sqlList;
    }

    public DBInit() {
    }

    public void execute() {
        try {
            this.doConnection();
            for (String sql : this.sqlList) {
                this.execute(sql);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException e1) {
                log.error(e1.getMessage(), e1);
            }
        }
    }

    public void executeSql(String sql) {
        try {
            this.doConnection();
            Throwable throwable = null;
            Object var3_5 = null;
            try (PreparedStatement st = this.con.prepareStatement(sql);){
                st.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
            log.error("Failed to execute " + sql, e2);
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException e1) {
                log.error(e1.getMessage(), e1);
            }
        }
    }

    private void execute(String sqlFile) throws IOException, SQLException {
        log.debug("Execute {}", (Object)sqlFile);
        System.out.println("Execute " + sqlFile);
        File file = new File(sqlFile);
        if (!file.exists() || !file.canRead()) {
            file = FileUtil.createTempFile(file.getName(), ".sql");
            file.deleteOnExit();
            FileUtil.copyResource(sqlFile, file);
        }
        SqlFile sFile = new SqlFile(file, "Cp1252", false);
        try {
            sFile.setContinueOnError(true);
            sFile.setConnection(this.con);
            sFile.execute();
        }
        catch (SqlToolError e2) {
            throw new SQLException(e2.getMessage());
        }
    }

    protected void doConnection() {
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.username, this.password);
            this.con.setAutoCommit(true);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    protected void rollback() {
        try {
            this.con.rollback();
        }
        catch (Exception ex) {
            log.error("can't rollback", ex);
        }
    }

    public boolean isConnected() {
        try {
            return !this.con.isClosed();
        }
        catch (Exception ex) {
            log.debug("db-connection is open: {}", (Object)ex.getMessage(), (Object)ex);
            return false;
        }
    }

    public boolean testConnection() {
        boolean result = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.username, this.password);
            result = true;
            this.con.close();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        return result;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getSqlList() {
        return this.sqlList;
    }

    public String getDbms() {
        return this.dbms;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }
}

