/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.csv;

import com.logicaldoc.util.csv.CSVFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class CSVFileReader
extends CSVFile
implements Closeable {
    protected BufferedReader in;

    public CSVFileReader(String inputFileName) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.UTF_8);
        this.in = new BufferedReader(isr);
    }

    public CSVFileReader(String inputFileName, char sep) throws FileNotFoundException, UnsupportedEncodingException {
        super(sep);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.UTF_8);
        this.in = new BufferedReader(isr);
    }

    public CSVFileReader(String inputFileName, char sep, char qual) throws FileNotFoundException, UnsupportedEncodingException {
        super(sep, qual);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.UTF_8);
        this.in = new BufferedReader(isr);
    }

    public List<String> readFields() throws IOException {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String line = this.in.readLine();
        if (line == null) {
            return new ArrayList<String>();
        }
        if (line.length() == 0) {
            fields.add(line);
            return fields;
        }
        int i2 = 0;
        do {
            sb.setLength(0);
            if (i2 < line.length() && line.charAt(i2) == this.textQualifier) {
                ++i2;
                i2 = this.handleQuotedField(line, sb, i2);
            } else {
                i2 = this.handlePlainField(line, sb, i2);
            }
            fields.add(sb.toString());
        } while (++i2 < line.length());
        return fields;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    protected int handleQuotedField(String s2, StringBuilder sb, int i2) {
        int len = s2.length();
        int j2 = i2;
        while (j2 < len) {
            boolean stopCycle = false;
            if (s2.charAt(j2) == this.textQualifier && j2 + 1 < len) {
                if (s2.charAt(j2 + 1) == this.textQualifier) {
                    ++j2;
                } else if (s2.charAt(j2 + 1) == this.fieldSeparator) {
                    ++j2;
                    stopCycle = true;
                }
            } else if (s2.charAt(j2) == this.textQualifier && j2 + 1 == len) {
                stopCycle = true;
            }
            if (stopCycle) break;
            sb.append(s2.charAt(j2));
            ++j2;
        }
        return j2;
    }

    protected int handlePlainField(String s2, StringBuilder sb, int i2) {
        int j2 = s2.indexOf(this.fieldSeparator, i2);
        if (j2 == -1) {
            sb.append(s2.substring(i2));
            return s2.length();
        }
        sb.append(s2.substring(i2, j2));
        return j2;
    }
}

