/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.crypt;

import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptUtil {
    private static Logger log = LoggerFactory.getLogger(CryptUtil.class);
    public static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    public static final String DES_ENCRYPTION_SCHEME = "DES";
    public static final String DEFAULT_ENCRYPTION_KEY = "This is a fairly long phrase used to encrypt";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;

    public CryptUtil(String encryptionKey) throws EncryptionException {
        this(DES_ENCRYPTION_SCHEME, encryptionKey);
    }

    public CryptUtil(String encryptionScheme, String encryptionKey) throws EncryptionException {
        if (encryptionKey == null) {
            throw new IllegalArgumentException("encryption key was null");
        }
        try {
            String key = encryptionKey;
            if (encryptionKey.length() < 32) {
                key = StringUtils.rightPad(encryptionKey, 32, '*');
            }
            byte[] keyAsBytes = key.getBytes(StandardCharsets.UTF_8);
            if (encryptionScheme.equals(DESEDE_ENCRYPTION_SCHEME)) {
                this.keySpec = new DESedeKeySpec(keyAsBytes);
            } else if (encryptionScheme.equals(DES_ENCRYPTION_SCHEME)) {
                this.keySpec = new DESKeySpec(keyAsBytes);
            } else {
                throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
            }
            this.keyFactory = SecretKeyFactory.getInstance(encryptionScheme);
            this.cipher = Cipher.getInstance(encryptionScheme);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e2) {
            throw new EncryptionException(e2);
        }
    }

    public void encrypt(File inputFile, File outputFile) throws EncryptionException {
        if (inputFile == null || !inputFile.exists()) {
            throw new IllegalArgumentException("Unencrypted file not found in inpout file");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(1, key);
            byte[] clearContent = FileUtils.readFileToByteArray(inputFile);
            byte[] encryptedContent = this.cipher.doFinal(clearContent);
            outputFile.mkdirs();
            FileUtil.delete(outputFile);
            boolean created = outputFile.createNewFile();
            if (!created) {
                throw new IOException("Cannot create file " + outputFile.getAbsolutePath());
            }
            FileUtils.writeByteArrayToFile(outputFile, encryptedContent);
        }
        catch (IOException | InvalidKeyException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException e2) {
            throw new EncryptionException(e2);
        }
    }

    public void decrypt(File inputFile, File outputFile) throws EncryptionException {
        try {
            if (inputFile == null || !inputFile.exists()) {
                throw new IllegalArgumentException("Encrypted file not found in input file");
            }
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, key);
            byte[] encryptedContent = FileUtils.readFileToByteArray(inputFile);
            byte[] clearContent = this.cipher.doFinal(encryptedContent);
            outputFile.mkdirs();
            FileUtil.delete(outputFile);
            boolean created = outputFile.createNewFile();
            if (!created) {
                throw new IOException("Cannot create file " + outputFile.getAbsolutePath());
            }
            FileUtils.writeByteArrayToFile(outputFile, clearContent);
        }
        catch (IOException | InvalidKeyException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException e2) {
            throw new EncryptionException(e2);
        }
    }

    public String encrypt(String unencryptedString) throws EncryptionException {
        if (unencryptedString == null || unencryptedString.trim().length() == 0) {
            throw new IllegalArgumentException("unencrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(1, key);
            byte[] cleartext = unencryptedString.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return new String(Base64.getMimeEncoder().encode(ciphertext), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException e2) {
            throw new EncryptionException(e2);
        }
    }

    public String decrypt(String encryptedString) throws EncryptionException {
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("encrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, key);
            byte[] cleartext = Base64.getMimeDecoder().decode(encryptedString);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return CryptUtil.bytes2String(ciphertext);
        }
        catch (InvalidKeyException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException e2) {
            throw new EncryptionException(e2);
        }
    }

    private static String bytes2String(byte[] bytes) {
        StringBuilder stringBuffer = new StringBuilder();
        int i2 = 0;
        while (i2 < bytes.length) {
            stringBuffer.append((char)bytes[i2]);
            ++i2;
        }
        return stringBuffer.toString();
    }

    public static String encryptSHA(String original) throws NoSuchAlgorithmException {
        StringBuilder copy = new StringBuilder();
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] digest = md.digest(original.getBytes(StandardCharsets.UTF_8));
        int i2 = 0;
        while (i2 < digest.length) {
            copy.append(Integer.toHexString(digest[i2] & 0xFF));
            ++i2;
        }
        return copy.toString();
    }

    public static String encryptSHA256(String original) throws NoSuchAlgorithmException {
        StringBuilder copy = new StringBuilder();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(original.getBytes(StandardCharsets.UTF_8));
        int i2 = 0;
        while (i2 < digest.length) {
            copy.append(String.format("%02X", digest[i2]));
            ++i2;
        }
        return copy.toString();
    }

    public static String hashMD4(String original) {
        if (original == null) {
            original = "";
        }
        String copy = "";
        try {
            MD4Digest md4 = new MD4Digest();
            byte[] pwdBytes = original.getBytes();
            md4.update(pwdBytes, 0, pwdBytes.length);
            byte[] encPwd = new byte[md4.getDigestSize()];
            md4.doFinal(encPwd, 0);
            copy = CryptUtil.getHex(encPwd).toLowerCase();
        }
        catch (Exception nsae) {
            log.error(nsae.getMessage());
        }
        return copy;
    }

    public static String hashNTLM1(String original) {
        try {
            if (original == null) {
                original = "";
            }
            MD4Digest md4 = new MD4Digest();
            int len = original.length();
            byte[] pwdBytes = new byte[len * 2];
            int i2 = 0;
            while (i2 < len) {
                char ch = original.charAt(i2);
                pwdBytes[i2 * 2] = (byte)ch;
                pwdBytes[i2 * 2 + 1] = (byte)(ch >> 8 & 0xFF);
                ++i2;
            }
            md4.update(pwdBytes, 0, pwdBytes.length);
            byte[] encPwd = new byte[16];
            md4.doFinal(encPwd, 0);
            return CryptUtil.getHex(encPwd).substring(0, 32);
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            return null;
        }
    }

    public static String getHex(byte[] raw) {
        String hexes = "0123456789ABCDEF";
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        byte[] byArray = raw;
        int n2 = raw.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b2 = byArray[n3];
            hex.append(hexes.charAt((b2 & 0xF0) >> 4)).append(hexes.charAt(b2 & 0xF));
            ++n3;
        }
        return hex.toString();
    }

    public static class EncryptionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EncryptionException(Throwable t2) {
            super(t2);
        }
    }
}

