/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import com.logicaldoc.util.config.XMLBean;
import java.util.HashMap;
import org.jdom2.Element;

public class SecurityConfigurator {
    private static final String VALUE = "value";
    protected XMLBean xml;

    public SecurityConfigurator(String resource) {
        this.xml = this.getClass().getClassLoader().getResource(resource) != null ? new XMLBean(this.getClass().getClassLoader().getResource(resource)) : new XMLBean(resource);
    }

    public SecurityConfigurator() {
        this.xml = new XMLBean(this.getClass().getClassLoader().getResource("context-security.xml"));
    }

    public String getContentSecurityPolicy() {
        Element header = this.getContentSecurityPolicyElement();
        if (header != null) {
            return header.getAttributeValue(VALUE);
        }
        return null;
    }

    public boolean setContentSecurityPolicy(String contentSecurityPolicy) {
        String currentValue;
        Element header = this.getContentSecurityPolicyElement();
        boolean modified = false;
        if (header != null && (currentValue = header.getAttributeValue(VALUE)) != null && !currentValue.equals(contentSecurityPolicy)) {
            header.setAttribute(VALUE, contentSecurityPolicy);
            modified = true;
        }
        if (modified) {
            this.xml.writeXMLDoc();
        }
        return modified;
    }

    private Element getContentSecurityPolicyElement() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("security", "http://www.springframework.org/schema/security");
        return this.xml.findElement("//security:header[@name='Content-Security-Policy']", namespaces);
    }
}

