/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public class OrderedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(new TreeSet<Object>(super.keySet()));
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        List<String> keys = this.getKeys();
        DataOutputStream dataoutputstream = new DataOutputStream(out);
        dataoutputstream.writeBytes("#" + header + "\n");
        Date now = new Date();
        dataoutputstream.writeBytes("#" + String.valueOf(now) + "\n");
        int i2 = 0;
        while (i2 < keys.size()) {
            String thekey = keys.get(i2);
            String thevalue = this.getProperty(thekey);
            thevalue = this.doubleSlash(thevalue);
            String oneline = thekey + "=" + thevalue + "\n";
            dataoutputstream.writeBytes(oneline);
            ++i2;
        }
        dataoutputstream.flush();
        dataoutputstream.close();
    }

    private String doubleSlash(String orig) {
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        while (i2 < orig.length()) {
            if (orig.charAt(i2) == '\\') {
                buf.append("\\\\");
            } else {
                buf.append(orig.charAt(i2));
            }
            ++i2;
        }
        return buf.toString();
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : this.keySet()) {
            keys.add(key.toString());
        }
        Collections.sort(keys);
        return keys;
    }
}

