/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import com.logicaldoc.util.config.OrderedProperties;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextProperties
extends OrderedProperties {
    private static final String UNABLE_TO_READ_FROM = "Unable to read from %s";
    private static final long serialVersionUID = 1L;
    private File file;
    private File overrideFile;
    protected static Logger log = LoggerFactory.getLogger(ContextProperties.class);
    protected int maxBackups;

    public ContextProperties(int maxBackups) throws IOException {
        this();
        this.maxBackups = maxBackups;
    }

    public ContextProperties() throws IOException {
        this.maxBackups = 10;
        try {
            this.load(ContextProperties.class.getClassLoader().getResource("context.properties"));
        }
        catch (Exception e2) {
            this.load(ContextProperties.class.getClassLoader().getResource("/context.properties"));
        }
    }

    public ContextProperties(String filePath) throws IOException {
        FileInputStream fis;
        Object var3_8;
        Throwable e22;
        this.maxBackups = 10;
        this.file = new File(filePath);
        if (!this.file.exists()) {
            try {
                URL url;
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                if ("file".equals((url = ContextProperties.class.getClassLoader().getResource(filePath)).getProtocol())) {
                    this.file = new File(url.getPath());
                }
            }
            catch (Exception e22) {
                log.error("Unable to find classpath resource {}", (Object)filePath);
                log.error(e22.getMessage(), e22);
            }
        }
        try {
            e22 = null;
            var3_8 = null;
            try {
                fis = new FileInputStream(this.file);
                try {
                    this.load(fis);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e22 == null) {
                    e22 = throwable;
                } else if (e22 != throwable) {
                    e22.addSuppressed(throwable);
                }
                throw e22;
            }
        }
        catch (IOException e3) {
            throw new IOException(String.format(UNABLE_TO_READ_FROM, filePath), e3);
        }
        this.overrideFile = this.detectOverrideFile();
        if (this.overrideFile != null) {
            try {
                e22 = null;
                var3_8 = null;
                try {
                    fis = new FileInputStream(this.overrideFile);
                    try {
                        this.load(fis);
                        log.info("Override settings defined in {}", (Object)this.overrideFile.getPath());
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e22 == null) {
                        e22 = throwable;
                    } else if (e22 != throwable) {
                        e22.addSuppressed(throwable);
                    }
                    throw e22;
                }
            }
            catch (IOException e4) {
                throw new IOException(String.format(UNABLE_TO_READ_FROM, this.overrideFile.getPath()), e4);
            }
        }
    }

    private File detectOverrideFile() {
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        File override = new File(this.file.getParentFile(), FileUtil.getBaseName(this.file.getName()) + "-override." + FileUtil.getExtension(this.file.getName()));
        return override.exists() ? override : null;
    }

    public ContextProperties(URL fileUrl) throws IOException {
        this.maxBackups = 10;
        this.load(fileUrl);
    }

    private void load(URL fileUrl) throws IOException {
        FileInputStream fis;
        Object var3_8;
        Throwable e22;
        try {
            this.file = new File(URLDecoder.decode(fileUrl.getPath(), "UTF-8"));
        }
        catch (Exception e22) {
            throw new IOException(String.format(UNABLE_TO_READ_FROM, this.file.getPath()), e22);
        }
        try {
            e22 = null;
            var3_8 = null;
            try {
                fis = new FileInputStream(this.file);
                try {
                    this.load(fis);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e22 == null) {
                    e22 = throwable;
                } else if (e22 != throwable) {
                    e22.addSuppressed(throwable);
                }
                throw e22;
            }
        }
        catch (IOException e3) {
            throw new IOException(String.format(UNABLE_TO_READ_FROM, this.file.getPath()), e3);
        }
        this.overrideFile = this.detectOverrideFile();
        if (this.overrideFile != null) {
            try {
                e22 = null;
                var3_8 = null;
                try {
                    fis = new FileInputStream(this.overrideFile);
                    try {
                        this.load(fis);
                        log.debug("Override settings defined in {}", (Object)this.overrideFile.getPath());
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e22 == null) {
                        e22 = throwable;
                    } else if (e22 != throwable) {
                        e22.addSuppressed(throwable);
                    }
                    throw e22;
                }
            }
            catch (IOException e4) {
                throw new IOException(String.format(UNABLE_TO_READ_FROM, this.overrideFile.getPath()), e4);
            }
        }
    }

    public ContextProperties(File file) throws IOException {
        FileInputStream fis;
        Object var3_7;
        block23: {
            this.maxBackups = 10;
            try {
                if (!file.exists()) break block23;
                this.file = file;
                Throwable throwable = null;
                var3_7 = null;
                try {
                    fis = new FileInputStream(file);
                    try {
                        this.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                throw new IOException("Unable to read from " + file.getPath(), e2);
            }
        }
        this.overrideFile = this.detectOverrideFile();
        if (this.overrideFile != null) {
            try {
                Throwable e2 = null;
                var3_7 = null;
                try {
                    fis = new FileInputStream(this.overrideFile);
                    try {
                        this.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (IOException e3) {
                throw new IOException(String.format(UNABLE_TO_READ_FROM, this.overrideFile.getPath()), e3);
            }
        }
    }

    public ContextProperties(InputStream is) throws IOException {
        this.maxBackups = 10;
        this.file = null;
        this.overrideFile = null;
        try {
            this.load(is);
        }
        catch (IOException e2) {
            throw new IOException("Unable to read from stream", e2);
        }
    }

    public synchronized void write() throws IOException {
        this.checkFile();
        this.backup();
        File tmpFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
        try {
            Files.deleteIfExists(tmpFile.toPath());
            Files.createFile(tmpFile.toPath(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                this.store(fos, "");
                log.info("Saved settings into temp file {}", (Object)tmpFile.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            FileUtil.moveQuitely(tmpFile, this.file);
        }
        finally {
            FileUtil.delete(tmpFile);
        }
    }

    private void checkFile() throws IOException {
        if (this.file == null) {
            throw new IOException("File not given");
        }
    }

    protected void backup() throws IOException {
        if (this.maxBackups < 1) {
            return;
        }
        this.checkFile();
        File parent = this.file.getParentFile();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String today = df.format(new Date());
        File backup = new File(parent, this.file.getName() + "." + today);
        if (!backup.exists()) {
            FileUtils.copyFile(this.file, backup);
            log.debug("Backup saved in {}", (Object)backup.getPath());
        }
        this.deleteOldestBackups();
    }

    private void deleteOldestBackups() throws IOException {
        List<File> oldBackups = this.getBackups();
        if (oldBackups.size() > this.maxBackups) {
            List backupsToRetain = oldBackups.stream().limit(this.maxBackups).toList();
            for (File backupFile : oldBackups) {
                if (backupsToRetain.contains(backupFile)) continue;
                FileUtil.delete(backupFile);
            }
        }
    }

    public List<File> getBackups() throws IOException {
        this.checkFile();
        File[] oldBackups = this.file.getParentFile().listFiles((dir, name) -> name.startsWith(this.file.getName() + ".") && name.substring(name.lastIndexOf(46) + 1).length() == 8);
        Arrays.sort(oldBackups, (f1, f2) -> {
            String date1 = f1.getName().substring(f1.getName().lastIndexOf(46) + 1);
            String date2 = f2.getName().substring(f2.getName().lastIndexOf(46) + 1);
            return date2.compareTo(date1);
        });
        return Arrays.asList(oldBackups);
    }

    public String getString(String property) {
        return this.getProperty(property);
    }

    public String getString(String property, String defaultValue) {
        return this.getProperty(property, defaultValue);
    }

    public int getInt(String property) {
        return this.getInt(property, 0);
    }

    public int getInt(String property, int defaultValue) {
        String v2 = this.getProperty(property);
        if (v2 == null || v2.trim().isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(v2.trim());
    }

    public long getLong(String property) {
        return this.getLong(property, 0L);
    }

    public long getLong(String property, long defaultValue) {
        String v2 = this.getProperty(property);
        if (v2 == null || v2.trim().isEmpty()) {
            return defaultValue;
        }
        return Long.parseLong(v2.trim());
    }

    public boolean getBoolean(String property) {
        return this.getBoolean(property, false);
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        String v2 = this.getProperty(property, "" + defaultValue).trim();
        return "true".equals(v2) || "yes".equals(v2) || "1".equals(v2);
    }

    public double getDouble(String property) {
        return this.getDouble(property, 0.0);
    }

    public double getDouble(String property, double defaultValue) {
        String v2 = this.getProperty(property);
        if (v2 == null || v2.trim().isEmpty()) {
            return defaultValue;
        }
        return Double.parseDouble(v2.trim());
    }

    public float getFloat(String property) {
        return this.getFloat(property, 0.0f);
    }

    public float getFloat(String property, float defaultValue) {
        String v2 = this.getProperty(property);
        if (v2 == null || v2.trim().isEmpty()) {
            return defaultValue;
        }
        return Float.parseFloat(v2.trim());
    }

    @Override
    public String getProperty(String property) {
        return StrSubstitutor.replaceSystemProperties(super.getProperty(property));
    }

    @Override
    public String getProperty(String property, String defaultValue) {
        return StrSubstitutor.replaceSystemProperties(super.getProperty(property, defaultValue));
    }

    public int getMaxBackups() {
        return this.maxBackups;
    }

    public void setMaxBackups(int maxBackups) {
        this.maxBackups = maxBackups;
    }

    public String getTenantProperty(String tenant, String property) {
        String key = tenant + "." + property;
        if (this.containsKey(key)) {
            return this.getProperty(key);
        }
        return this.getProperty(property);
    }

    public Map<String, String> getTenantProperties(String tenant) {
        return this.getProperties(tenant + ".");
    }

    public Map<String, String> getProperties(String prefix) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Object key : this.keySet()) {
            String prop = key.toString();
            if (!prop.startsWith(prefix)) continue;
            props.put(prop.substring(prefix.length()), this.getProperty(prop));
        }
        return props;
    }

    public void removeTenantProperties(String tenant) {
        if ("default".equals(tenant)) {
            return;
        }
        ArrayList<String> toBeDeleted = new ArrayList<String>();
        for (Object key : this.keySet()) {
            String prop = key.toString();
            if (!prop.startsWith(tenant + ".")) continue;
            toBeDeleted.add(prop);
        }
        for (String prop : toBeDeleted) {
            this.remove(prop);
        }
    }

    public void replicateTenantSettings(String tenant) {
        Map<String, String> defaultProps = this.getTenantProperties("default");
        for (String prop : defaultProps.keySet()) {
            String tenantProp = tenant + "." + prop;
            if (this.containsKey(tenantProp)) continue;
            this.setProperty(tenantProp, this.getProperty("default." + prop));
        }
    }
}

