/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.cache;

import com.logicaldoc.util.config.XMLBean;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class CacheConfigurator {
    private XMLBean xml;

    public CacheConfigurator(String resource) {
        this.xml = this.getClass().getClassLoader().getResource(resource) != null ? new XMLBean(this.getClass().getClassLoader().getResource(resource)) : new XMLBean(resource);
    }

    public CacheConfigurator() {
        this.xml = new XMLBean(this.getClass().getClassLoader().getResource("cache.xml"));
    }

    private Element getCacheElement(String cacheName) {
        List caches = this.xml.getRootElement().getChildren("cache", this.xml.getRootElement().getNamespace());
        for (Element elem : caches) {
            String name = elem.getAttributeValue("name");
            if (!cacheName.equals(name)) continue;
            return elem;
        }
        return null;
    }

    public boolean containsCache(String cacheName) {
        return this.getCacheElement(cacheName) != null;
    }

    public void removeCache(String cacheName) {
        Element cacheElement = this.getCacheElement(cacheName);
        if (cacheElement != null) {
            cacheElement.getParent().removeContent((Content)cacheElement);
        }
    }

    public void addCache(String cacheName, int maxElementsInMemory) {
        if (this.containsCache(cacheName)) {
            return;
        }
        List children = this.xml.getRootElement().getChildren("defaultCache", this.xml.getRootElement().getNamespace());
        int index = this.xml.getRootElement().getChildren().indexOf(children.get(0));
        Element cache = new Element("cache", this.xml.getRootElement().getNamespace());
        cache.setAttribute("name", cacheName);
        cache.setAttribute("maxElementsInMemory", "" + maxElementsInMemory);
        cache.setAttribute("eternal", "true");
        cache.setAttribute("overflowToDisk", "true");
        cache.setAttribute("diskPersistent", "true");
        children = this.xml.getRootElement().getChildren();
        children.add(index + 1, cache);
    }

    public void setCacheDir(String path) {
        List<Element> list = this.xml.getAllChildren("diskStore");
        Element elem = list.iterator().next();
        elem.setAttribute("path", path);
    }

    public void write() {
        this.xml.writeXMLDoc();
    }
}

