/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

import com.logicaldoc.util.config.ContextProperties;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class TagUtil {
    public static final int MAX_FIELD_LENGTH = 4000;

    private TagUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<String> extractTags(String tenantName, String words) {
        HashSet<String> coll = new HashSet<String>();
        if (words == null) {
            return coll;
        }
        if (!((String)words).contains(",")) {
            words = "," + (String)words + ",";
        }
        words = ((String)words).replace("\\,", "__comma__");
        int minSize = 3;
        int maxSize = 9;
        try {
            ContextProperties conf = new ContextProperties();
            minSize = conf.getInt(tenantName + ".tag.minsize");
            maxSize = conf.getInt(tenantName + ".tag.maxsize");
        }
        catch (IOException conf) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer((String)words, ",", false);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (!StringUtils.isNotEmpty(word = word.replace("__comma__", ",")) || (word = word.trim()).length() < minSize) continue;
            if (word.length() > maxSize) {
                coll.add(word.substring(0, maxSize));
                continue;
            }
            coll.add(word);
        }
        return coll;
    }

    public static String normalizeTags(String tenantName, String words) {
        Set<String> tags = TagUtil.extractTags(tenantName, words);
        StringBuilder sb = new StringBuilder();
        for (String tag : tags) {
            tag = tag.replace(",", "\\,");
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(tag);
        }
        String str = sb.toString();
        if (str.length() > 4000) {
            str = str.substring(0, 4000);
        }
        return str;
    }
}

