/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    private static final String UTF_8 = "UTF-8";

    private StringUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String split(String src, char separator, int tokenSize) {
        StringBuilder sb = new StringBuilder();
        String[] tokens = StringUtil.split(src, tokenSize);
        int i2 = 0;
        while (i2 < tokens.length) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(tokens[i2]);
            ++i2;
        }
        return sb.toString();
    }

    public static String[] split(String src, int tokenSize) {
        ArrayList<String> buf = new ArrayList<String>();
        int i2 = 0;
        while (i2 < src.length()) {
            int j2 = i2 + tokenSize;
            if (j2 > src.length()) {
                j2 = src.length();
            }
            buf.add(src.substring(i2, j2));
            i2 += tokenSize;
        }
        return buf.toArray(new String[0]);
    }

    public static String writeToString(Reader reader) throws IOException {
        return StringUtil.writeToString(reader, UTF_8);
    }

    /*
     * Loose catch block
     */
    public static String writeToString(Reader reader, String targetEncoding) throws IOException {
        String enc = UTF_8;
        if (StringUtils.isNotEmpty(targetEncoding)) {
            enc = targetEncoding;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            String string;
            OutputStreamWriter osw;
            ByteArrayOutputStream baos;
            block18: {
                block17: {
                    String inputLine;
                    baos = new ByteArrayOutputStream();
                    osw = new OutputStreamWriter((OutputStream)baos, enc);
                    BufferedWriter bw = new BufferedWriter(osw);
                    BufferedReader br = new BufferedReader(reader);
                    while ((inputLine = br.readLine()) != null) {
                        bw.write(inputLine);
                        bw.newLine();
                    }
                    bw.flush();
                    osw.flush();
                    string = new String(baos.toByteArray(), enc);
                    if (osw == null) break block17;
                    osw.close();
                }
                if (baos == null) break block18;
                baos.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (baos != null) {
                            baos.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String writeToString(InputStream is, String targetEncoding) throws IOException {
        String enc = UTF_8;
        if (StringUtils.isNotEmpty(targetEncoding)) {
            enc = targetEncoding;
        }
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                InputStreamReader isr = new InputStreamReader(is, enc);
                try {
                    try (BufferedReader reader = new BufferedReader(isr);){
                        int n2;
                        while ((n2 = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n2);
                        }
                    }
                    if (isr == null) return ((Object)writer).toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (isr == null) throw throwable;
                    isr.close();
                    throw throwable;
                }
                isr.close();
                return ((Object)writer).toString();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String arrayToString(Object[] a2, String separator) {
        StringBuilder result = new StringBuilder("");
        if (a2.length > 0) {
            result.append(a2[0].toString());
            int i2 = 1;
            while (i2 < a2.length) {
                result.append(separator);
                result.append(a2[i2]);
                ++i2;
            }
        }
        return result.toString();
    }

    public static String collectionToString(Collection<?> collection, String separator) {
        return String.join((CharSequence)separator, collection.stream().map(Object::toString).toList());
    }

    public static String removeNonUtf8Chars(String src) {
        return src.replace('\uffff', ' ').replace('\ud835', ' ');
    }

    public static boolean matches(String str, String[] includes, String[] excludes) {
        if (!(excludes != null && excludes.length != 0 || includes != null && includes.length != 0)) {
            return true;
        }
        boolean matchesExclusions = StringUtil.filtersCheck(str, excludes);
        if (matchesExclusions) {
            return false;
        }
        boolean matchesInclusions = StringUtil.filtersCheck(str, includes);
        if (matchesInclusions) {
            return true;
        }
        return includes == null || includes.length == 0;
    }

    private static boolean filtersCheck(String str, String[] filters) {
        if (filters != null && filters.length > 0) {
            String[] stringArray = filters;
            int n2 = filters.length;
            int n3 = 0;
            while (n3 < n2) {
                String s2 = stringArray[n3];
                if (StringUtils.isNotEmpty(s2) && str.matches(s2)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static String unaccent(String src) {
        return Normalizer.normalize(src, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String printFileSize(long size) {
        return StringUtil.printFileSize(size, Locale.getDefault());
    }

    public static String printFileSize(long size, Locale locale) {
        if (size <= 0L) {
            return "0";
        }
        if (size < 1024L) {
            return size + " B";
        }
        int z2 = (63 - Long.numberOfLeadingZeros(size)) / 10;
        double value = (double)size / (double)(1L << z2 * 10);
        DecimalFormat df = new DecimalFormat("##,###.#", new DecimalFormatSymbols(locale));
        String numberPart = df.format(value);
        return numberPart + String.format(" %sB", Character.valueOf(" KMGTPE".charAt(z2)));
    }

    public static String defaultString(String input, String def) {
        return StringUtils.defaultString(input, def);
    }
}

