/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

public class SoftwareVersion
implements Comparable<SoftwareVersion> {
    private String version;

    public final String get() {
        return this.version;
    }

    public SoftwareVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (version.length() > 20) {
            throw new IllegalArgumentException("Version can not be more than 20 characters");
        }
        if (!version.matches("\\d+(\\.\\d+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.version = version;
    }

    @Override
    public int compareTo(SoftwareVersion that) {
        if (that == null) {
            return 1;
        }
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = that.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        int i2 = 0;
        while (i2 < length) {
            int thatPart;
            int thisPart = i2 < thisParts.length ? Integer.parseInt(thisParts[i2]) : 0;
            int n2 = thatPart = i2 < thatParts.length ? Integer.parseInt(thatParts[i2]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart > thatPart) {
                return 1;
            }
            ++i2;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((SoftwareVersion)that) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }
}

