/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.event.SystemEventListener;
import com.logicaldoc.util.event.SystemEventStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public class Context
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    protected static Logger log = LoggerFactory.getLogger(Context.class);
    private static Map<SystemEventStatus, LinkedList<SystemEventListener>> systemEvents = new EnumMap<SystemEventStatus, LinkedList<SystemEventListener>>(SystemEventStatus.class);
    private static Context instance;
    private ApplicationContext applicationContext;

    private Context() {
        instance = this;
    }

    public static Context get() {
        return instance;
    }

    public ContextProperties getProperties() {
        return this.getBean(ContextProperties.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object getBean(String id) {
        return this.applicationContext.containsBean(id) ? this.applicationContext.getBean(id) : this.applicationContext.getBean(Character.toLowerCase(id.charAt(0)) + id.substring(1));
    }

    public boolean containsBean(String id) {
        return this.applicationContext.containsBean(id) || this.applicationContext.containsBean(Character.toLowerCase(id.charAt(0)) + id.substring(1));
    }

    public List<String> getBeanIds() {
        return Arrays.asList(this.applicationContext.getBeanDefinitionNames());
    }

    public <R> List<R> getBeansOfType(Class<R> requiredType) {
        ArrayList<R> beans = new ArrayList<R>();
        String[] stringArray = this.applicationContext.getBeanNamesForType(requiredType);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            beans.add(requiredType.cast(this.getBean(name)));
            ++n3;
        }
        return beans;
    }

    public <R> R getBean(Class<R> requiredType) {
        String id = requiredType.getName();
        if (!this.applicationContext.containsBean(id)) {
            id = id.substring(id.lastIndexOf(46) + 1);
        }
        return requiredType.cast(this.getBean(id));
    }

    public void refresh() {
        if (this.applicationContext != null) {
            try {
                Context.closeCaches();
                ((AbstractApplicationContext)this.applicationContext).stop();
                ((AbstractApplicationContext)this.applicationContext).start();
                ((AbstractApplicationContext)this.applicationContext).refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void closeCaches() {
        CacheManager cm1 = CacheManager.getInstance();
        cm1.shutdown();
        for (CacheManager cm : Context.get().getBeansOfType(CacheManager.class)) {
            cm.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SystemEventListener evt) {
        Map<SystemEventStatus, LinkedList<SystemEventListener>> map = systemEvents;
        synchronized (map) {
            LinkedList<SystemEventListener> evts = systemEvents.get((Object)evt.getSystemStatus());
            if (evts == null) {
                evts = new LinkedList();
                systemEvents.put(evt.getSystemStatus(), evts);
            }
            evts.add(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(SystemEventListener evt) {
        Map<SystemEventStatus, LinkedList<SystemEventListener>> map = systemEvents;
        synchronized (map) {
            LinkedList<SystemEventListener> evts = systemEvents.get((Object)evt.getSystemStatus());
            if (CollectionUtils.isEmpty(evts)) {
                return;
            }
            evts.remove(evt);
        }
    }

    public Resource[] getResources(String resourcePattern) {
        try {
            return this.applicationContext.getResources(resourcePattern);
        }
        catch (IOException iOException) {
            return new Resource[0];
        }
    }

    public Resource getResource(String resourceLocation) {
        return this.applicationContext.getResource(resourceLocation);
    }

    public synchronized void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStartedEvent || event instanceof ContextRefreshedEvent) {
            this.processEvents(SystemEventStatus.BEANS_AVAILABLE);
        } else if (event instanceof ContextClosedEvent) {
            this.processEvents(SystemEventStatus.SYSTEM_DESTORY);
        }
    }

    private void processEvents(SystemEventStatus st) {
        LinkedList<SystemEventListener> evts = systemEvents.get((Object)st);
        if (CollectionUtils.isEmpty(evts)) {
            return;
        }
        for (SystemEventListener evt : evts) {
            try {
                evt.processEvent();
            }
            catch (Exception t2) {
                log.error(t2.getMessage(), t2);
            }
        }
    }

    public void close() {
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            configurableContext.close();
        }
    }
}

