/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

public class Base64Coder {
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char[] map1 = new char[64];
    private static final byte[] map2;

    static {
        int i2 = 0;
        int c2 = 65;
        while (c2 <= 90) {
            Base64Coder.map1[i2++] = c2;
            c2 = (char)(c2 + 1);
        }
        c2 = 97;
        while (c2 <= 122) {
            Base64Coder.map1[i2++] = c2;
            c2 = (char)(c2 + 1);
        }
        c2 = 48;
        while (c2 <= 57) {
            Base64Coder.map1[i2++] = c2;
            c2 = (char)(c2 + 1);
        }
        Base64Coder.map1[i2++] = 43;
        Base64Coder.map1[i2++] = 47;
        map2 = new byte[128];
        i2 = 0;
        while (i2 < map2.length) {
            Base64Coder.map2[i2] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < 64) {
            Base64Coder.map2[Base64Coder.map1[i2]] = (byte)i2;
            ++i2;
        }
    }

    private Base64Coder() {
        throw new IllegalStateException("Utility class");
    }

    public static String encodeString(String s2) {
        return new String(Base64Coder.encode(s2.getBytes()));
    }

    public static String encodeLines(byte[] in) {
        return Base64Coder.encodeLines(in, 0, in.length, 76, SYSTEM_LINE_SEPARATOR);
    }

    public static String encodeLines(byte[] in, int iOff, int iLen, int lineLen, String lineSeparator) {
        int blockLen = lineLen * 3 / 4;
        if (blockLen <= 0) {
            throw new IllegalArgumentException();
        }
        int lines = (iLen + blockLen - 1) / blockLen;
        int bufLen = (iLen + 2) / 3 * 4 + lines * lineSeparator.length();
        StringBuilder buf = new StringBuilder(bufLen);
        int ip = 0;
        while (ip < iLen) {
            int l2 = Math.min(iLen - ip, blockLen);
            buf.append(Base64Coder.encode(in, iOff + ip, l2));
            buf.append(lineSeparator);
            ip += l2;
        }
        return buf.toString();
    }

    public static char[] encode(byte[] in) {
        return Base64Coder.encode(in, 0, in.length);
    }

    public static char[] encode(byte[] in, int iLen) {
        return Base64Coder.encode(in, 0, iLen);
    }

    public static char[] encode(byte[] in, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n2 = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n2;
            ++op;
        }
        return out;
    }

    public static String decodeString(String s2) {
        return new String(Base64Coder.decode(s2));
    }

    public static byte[] decodeLines(String s2) {
        char[] buf = new char[s2.length()];
        int p2 = 0;
        int ip = 0;
        while (ip < s2.length()) {
            char c2 = s2.charAt(ip);
            if (c2 != ' ' && c2 != '\r' && c2 != '\n' && c2 != '\t') {
                buf[p2++] = c2;
            }
            ++ip;
        }
        return Base64Coder.decode(buf, 0, p2);
    }

    public static byte[] decode(String s2) {
        return Base64Coder.decode(s2.toCharArray());
    }

    public static byte[] decode(char[] in) {
        return Base64Coder.decode(in, 0, in.length);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] decode(char[] in, int iOff, int iLen) {
        if (iLen % 4 == 0) ** GOTO lbl4
        throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
lbl-1000:
        // 1 sources

        {
            --iLen;
lbl4:
            // 2 sources

            ** while (iLen > 0 && in[iOff + iLen - 1] == '=')
        }
lbl5:
        // 1 sources

        oLen = iLen * 3 / 4;
        out = new byte[oLen];
        ip = iOff;
        iEnd = iOff + iLen;
        op = 0;
        while (ip < iEnd) {
            i0 = in[ip++];
            i1 = in[ip++];
            i2 = ip < iEnd ? in[ip++] : 65;
            i3 = ip < iEnd ? in[ip++] : 65;
            Base64Coder.checkIllegalCharacter1(i0, i1, i2, i3);
            b0 = Base64Coder.map2[i0];
            b1 = Base64Coder.map2[i1];
            b2 = Base64Coder.map2[i2];
            b3 = Base64Coder.map2[i3];
            Base64Coder.checkIllegalCharacter2(b0, b1, b2, b3);
            o0 = b0 << 2 | b1 >>> 4;
            o1 = (b1 & 15) << 4 | b2 >>> 2;
            o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    private static void checkIllegalCharacter2(int b0, int b1, int b2, int b3) {
        if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
            throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
        }
    }

    private static void checkIllegalCharacter1(int i0, int i1, int i2, int i3) {
        if (i0 > 127 || i1 > 127 || i2 > 127 || i3 > 127) {
            throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
        }
    }
}

