/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ServiceUtil {
    public static boolean exists(String service) {
        try {
            int c2;
            Process p2 = Runtime.getRuntime().exec("sc query " + service);
            BufferedInputStream stdoutStream = new BufferedInputStream(p2.getInputStream());
            StringBuilder buffer = new StringBuilder();
            while ((c2 = ((InputStream)stdoutStream).read()) != -1) {
                buffer.append((char)c2);
            }
            String outputText = buffer.toString();
            ((InputStream)stdoutStream).close();
            return outputText.contains(service);
        }
        catch (Exception t2) {
            return false;
        }
    }

    public static String getServicePermissions(String service) {
        try {
            String line;
            Process p2 = Runtime.getRuntime().exec("sc sdshow " + service);
            StringBuilder buffer = new StringBuilder();
            BufferedReader input = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            while ((line = input.readLine()) != null) {
                buffer.append(line);
            }
            input.close();
            String outputText = buffer.toString();
            return outputText;
        }
        catch (Exception t2) {
            return "";
        }
    }

    public static void grantPermissions(String service, String profileId) {
        String newPermissionString;
        String basePermissionString = String.format("(A;;CCLCSWRPWPDTLOCRRC;;;%s)", profileId);
        String defaultPermissions = ServiceUtil.getServicePermissions(service);
        int index = defaultPermissions.lastIndexOf("S:(AU;");
        if (index > 0) {
            newPermissionString = defaultPermissions.substring(0, index) + basePermissionString + defaultPermissions.substring(index);
            try {
                Runtime.getRuntime().exec("sc sdset " + service + " \"" + newPermissionString + "\"");
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if ((index = (defaultPermissions = ServiceUtil.getServicePermissions(service + "-Update")).lastIndexOf("S:(AU;")) > 0) {
            newPermissionString = defaultPermissions.substring(0, index) + basePermissionString + defaultPermissions.substring(index);
            try {
                Runtime.getRuntime().exec("sc sdset " + service + "-Update \"" + newPermissionString + "\"");
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public static String findSuitableName(String baseName) {
        String service = baseName;
        int i2 = 1;
        while (i2 < 100 && ServiceUtil.exists(service)) {
            service = baseName + i2++;
        }
        return service;
    }

    public static boolean isRunning(String service) throws IOException {
        int c2;
        Process p2 = Runtime.getRuntime().exec("sc query " + service);
        BufferedInputStream stdoutStream = new BufferedInputStream(p2.getInputStream());
        StringBuilder buffer = new StringBuilder();
        while ((c2 = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c2);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText.toLowerCase().contains("running");
    }

    public static void main(String[] args) {
        ServiceUtil.grantPermissions("LogicalDOC-Devel", "pippo");
    }
}

